/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.transfernodes;

import com.rwtema.extrautils2.transfernodes.IPipe;
import com.rwtema.extrautils2.utils.CapGetter;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class TransferHelper {
    public static boolean isInputtingPipe(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        IPipe pipe = TransferHelper.getPipe(world, pos);
        return pipe != null && pipe.canInput(world, pos, dir);
    }

    public static IPipe getPipe(IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IPipe) {
            return (IPipe)tileEntity;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block instanceof IPipe) {
            return (IPipe)block;
        }
        return null;
    }

    public static boolean isOutputtingPipe(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        IPipe pipe = TransferHelper.getPipe(world, pos);
        return pipe != null && pipe.canOutput(world, pos, dir);
    }

    public static boolean hasValidCapability(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        TileEntity tileEntity = world.func_175625_s(pos);
        return tileEntity != null && TransferHelper.hasValidCapability((ICapabilityProvider)tileEntity, dir);
    }

    public static boolean hasValidCapability(ICapabilityProvider tileEntity, EnumFacing dir) {
        for (CapGetter<?> capability : CapGetter.caps) {
            if (!capability.hasInterface(tileEntity, dir)) continue;
            return true;
        }
        return false;
    }
}

