/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.transfernodes;

import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicContainerTile;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.IWidgetClientNetwork;
import com.rwtema.extrautils2.gui.backend.WidgetClickBase;
import com.rwtema.extrautils2.gui.backend.WidgetRawData;
import com.rwtema.extrautils2.gui.backend.WidgetScrollBar;
import com.rwtema.extrautils2.gui.backend.WidgetSlotItemHandler;
import com.rwtema.extrautils2.itemhandler.InventoryHelper;
import com.rwtema.extrautils2.itemhandler.PublicWrapper;
import com.rwtema.extrautils2.network.PacketBuffer;
import com.rwtema.extrautils2.tile.TilePower;
import com.rwtema.extrautils2.transfernodes.IPipe;
import com.rwtema.extrautils2.transfernodes.IPipeConnect;
import com.rwtema.extrautils2.transfernodes.TransferHelper;
import com.rwtema.extrautils2.utils.CapGetter;
import com.rwtema.extrautils2.utils.PositionPool;
import com.rwtema.extrautils2.utils.blockaccess.ThreadSafeBlockAccess;
import com.rwtema.extrautils2.utils.client.GLStateAttributes;
import com.rwtema.extrautils2.utils.datastructures.ItemRef;
import com.rwtema.extrautils2.utils.datastructures.ItemRefComparator;
import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TObjectIntProcedure;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.HttpUtil;
import net.minecraft.util.ITickable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileIndexer
extends TilePower
implements ITickable,
IDynamicHandler,
IPipeConnect {
    public static final int COUNTDOWN_SINGLE = 10;
    public HashMultimap<ItemRef, SidedPos> itemRefPosEntryHashMultimap = HashMultimap.create();
    public List<SidedPos> positions = new ArrayList<SidedPos>();
    public TObjectIntHashMap<ItemRef> counts = new TObjectIntHashMap();
    public TObjectIntHashMap<ItemRef> countDown = new TObjectIntHashMap();
    public TObjectIntHashMap<ItemRef> orders = new TObjectIntHashMap();
    public ItemStackHandler stacks = this.registerNBT("stacks", new ItemStackHandler(9));
    public ItemStackHandler returnStacks = this.registerNBT("return", new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            TileIndexer.this.func_70296_d();
            TileIndexer.this.dirty = true;
        }
    });
    public IItemHandler publicHandler = new PublicWrapper.Extract((IItemHandler)this.returnStacks);
    public long positionsHash;
    public long itemsHash;
    public ListenableFuture<Runnable> submit;
    public boolean dirty;

    public void reload() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.active || this.submit != null) {
            return;
        }
        final PositionPool pool = new PositionPool();
        final HashSet<BlockPos> alreadyChecking = new HashSet<BlockPos>();
        final LinkedList<BlockPos> toCheck = new LinkedList<BlockPos>();
        BlockPos intern = pool.intern(this.field_174879_c);
        boolean adjacentPipe = false;
        final ArrayList sides = new ArrayList();
        alreadyChecking.add(intern);
        for (EnumFacing facing : EnumFacing.values()) {
            BlockPos offset = pool.offset(intern, facing);
            adjacentPipe = adjacentPipe || TransferHelper.getPipe((IBlockAccess)this.field_145850_b, offset) != null;
            alreadyChecking.add(offset);
            toCheck.add(offset);
        }
        if (!adjacentPipe) {
            return;
        }
        final ThreadSafeBlockAccess world = new ThreadSafeBlockAccess((WorldServer)this.field_145850_b);
        this.submit = HttpUtil.field_180193_a.submit((Callable)new Callable<Runnable>(){

            @Override
            public Runnable call() throws Exception {
                BlockPos pos;
                long hash = alreadyChecking.hashCode() * 31 + toCheck.hashCode();
                while ((pos = (BlockPos)toCheck.poll()) != null) {
                    if (!TileIndexer.this.active || TileIndexer.this.func_145837_r()) {
                        return null;
                    }
                    hash = hash * 31L + (long)pos.hashCode() + 1L;
                    IPipe pipe = TransferHelper.getPipe(world, pos);
                    if (pipe == null) continue;
                    hash = hash * 31L + (long)pipe.hashCode();
                    for (EnumFacing facing : EnumFacing.values()) {
                        BlockPos offset;
                        if (pipe.hasCapability(world, pos, facing, CapGetter.ItemHandler)) {
                            sides.add(new SidedPos(pos, facing));
                            hash = (hash * 31L + (long)pos.hashCode()) * 31L + (long)facing.ordinal();
                        }
                        if (alreadyChecking.contains(offset = pool.offset(pos, facing))) continue;
                        hash = hash * 31L + (long)facing.ordinal();
                        IPipe otherPipe = TransferHelper.getPipe(world, offset);
                        if (otherPipe == null || (!pipe.canOutput(world, pos, facing) || !otherPipe.canInput(world, offset, facing.func_176734_d())) && (!pipe.canInput(world, pos, facing) || !otherPipe.canOutput(world, offset, facing.func_176734_d()))) continue;
                        hash = hash * 31L + (long)offset.hashCode();
                        alreadyChecking.add(offset);
                        toCheck.add(offset);
                    }
                }
                final long finalHash = hash;
                return new Runnable(){

                    @Override
                    public void run() {
                        TileIndexer.this.process(sides, finalHash);
                    }
                };
            }
        });
        Futures.addCallback(this.submit, (FutureCallback)new FutureCallback<Runnable>(){

            public void onSuccess(Runnable result) {
                if (result != null) {
                    MinecraftServer.func_71276_C().func_152344_a(result);
                }
                TileIndexer.this.submit = null;
            }

            public void onFailure(final @Nonnull Throwable t) {
                MinecraftServer.func_71276_C().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        throw Throwables.propagate((Throwable)t);
                    }
                });
                TileIndexer.this.submit = null;
            }
        });
    }

    private void process(List<SidedPos> sidedPositions, long finalHash) {
        if (this.positionsHash == finalHash) {
            return;
        }
        this.positionsHash = finalHash;
        this.process(sidedPositions);
    }

    private void process(List<SidedPos> sidedPositions) {
        long h = 0L;
        if (!this.isLoaded() || this.field_145850_b.field_72995_K) {
            return;
        }
        HashMultimap itemRefPosEntryHashMultimap = HashMultimap.create();
        TObjectIntHashMap counts = new TObjectIntHashMap();
        Interner interner = Interners.newStrongInterner();
        for (ItemRef itemRef : this.counts.keySet()) {
            interner.intern((Object)itemRef);
        }
        HashSet<IItemHandler> processedHandlers = new HashSet<IItemHandler>();
        for (SidedPos sidedPos : sidedPositions) {
            IItemHandler handler;
            IPipe pipe = TransferHelper.getPipe((IBlockAccess)this.field_145850_b, sidedPos.pos);
            if (pipe == null || (handler = pipe.getCapability((IBlockAccess)this.field_145850_b, sidedPos.pos, sidedPos.side, CapGetter.ItemHandler)) == null || processedHandlers.contains(handler)) continue;
            processedHandlers.add(handler);
            h = h * 31L + (long)sidedPos.hashCode();
            h = h * 31L + (long)handler.getSlots();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemRef itemRef;
                ItemStack stack = handler.extractItem(i, 64, true);
                if (stack == null || (itemRef = (ItemRef)interner.intern((Object)ItemRef.wrap(stack))) == ItemRef.NULL) continue;
                itemRefPosEntryHashMultimap.put((Object)itemRef, (Object)sidedPos);
                counts.adjustOrPutValue((Object)itemRef, stack.field_77994_a, stack.field_77994_a);
                h = h * 31L + (long)i;
                h = h * 31L + (long)itemRef.hashCode();
                h = h * 31L + (long)stack.field_77994_a;
            }
        }
        this.positions = sidedPositions;
        this.itemRefPosEntryHashMultimap = itemRefPosEntryHashMultimap;
        this.counts = counts;
        this.itemsHash = h;
    }

    @Override
    public void onPowerChanged() {
        if (!this.active && this.submit != null) {
            this.submit.cancel(true);
        }
    }

    @Override
    public IItemHandler getItemHandler(EnumFacing facing) {
        return this.publicHandler;
    }

    @Override
    public float getPower() {
        return 8.0f;
    }

    public void func_73660_a() {
        if (this.itemRefPosEntryHashMultimap == null || this.field_145850_b.func_82737_E() % 200L == 0L) {
            this.reload();
        }
        if (!this.countDown.isEmpty()) {
            TObjectIntIterator iterator = this.countDown.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                int value = iterator.value();
                if (--value == 0) {
                    ItemRef key = (ItemRef)iterator.key();
                    int i = this.orders.get((Object)key);
                    if (i <= 0) {
                        iterator.remove();
                        this.orders.remove((Object)key);
                        continue;
                    }
                    if (i == 1) {
                        iterator.remove();
                        this.orders.remove((Object)key);
                        this.retrieve(key, 1);
                        this.dirty = true;
                        continue;
                    }
                    if (i <= 1) continue;
                    if (this.retrieve(key, 1)) {
                        iterator.setValue(10);
                        this.orders.put((Object)key, i - 1);
                    } else {
                        iterator.remove();
                        this.orders.remove((Object)key);
                    }
                    this.dirty = true;
                    continue;
                }
                iterator.setValue(value);
            }
        }
        if (this.dirty) {
            this.process();
            this.reload();
        }
    }

    public void process() {
        this.process(this.positions);
    }

    private boolean retrieve(ItemRef key, int order) {
        HashMultimap<ItemRef, SidedPos> itemRefPosEntryHashMultimap = this.itemRefPosEntryHashMultimap;
        Set sidedPositions = itemRefPosEntryHashMultimap.get((Object)key);
        if ((order = InventoryHelper.getMaxInsert((IItemHandler)this.stacks, key.createItemStack(order))) <= 0) {
            return false;
        }
        boolean inserted = false;
        HashSet<IItemHandler> processedHandlers = new HashSet<IItemHandler>();
        for (SidedPos sidedPos : sidedPositions) {
            IItemHandler handler;
            if (sidedPos.pos.equals((Object)this.field_174879_c)) {
                TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(sidedPos.side));
                if (tileEntity == null) continue;
                handler = CapGetter.ItemHandler.getInterface((ICapabilityProvider)tileEntity, sidedPos.side.func_176734_d());
            } else {
                IPipe pipe = TransferHelper.getPipe((IBlockAccess)this.field_145850_b, sidedPos.pos);
                if (pipe == null) continue;
                handler = pipe.getCapability((IBlockAccess)this.field_145850_b, sidedPos.pos, sidedPos.side, CapGetter.ItemHandler);
            }
            if (handler == null || !processedHandlers.add(handler)) continue;
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.extractItem(i, order, true);
                if (stack == null || !key.equalsItemStack(stack)) continue;
                int toOrder = InventoryHelper.getMaxInsert((IItemHandler)this.stacks, stack);
                if (toOrder == 0) {
                    return inserted;
                }
                inserted = true;
                ItemStack extracted = handler.extractItem(i, toOrder, false);
                InventoryHelper.insert((IItemHandler)this.stacks, extracted, false);
                if ((order -= toOrder) > 0) continue;
                return true;
            }
        }
        return inserted;
    }

    public void order(ItemRef ref, boolean b) {
        if (this.orders.containsKey((Object)ref)) {
            return;
        }
        int order = b ? ref.getMaxStackSize() : 1;
        this.orders.put((Object)ref, order);
        this.countDown.put((Object)ref, 10);
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        this.positionsHash = 0L;
        this.process();
        this.reload();
        return new ContainerIndexer(this, player);
    }

    @Override
    public boolean forceConnect(EnumFacing side) {
        return true;
    }

    public static class ContainerIndexer
    extends DynamicContainerTile {
        static final int HORIZONTAL_SLOTS = 9;
        static final int VERTICAL_SLOTS = 4;
        private final EntityPlayer player;
        public ArrayList<ItemRef> list = new ArrayList();
        WidgetScrollBar scrollBar;
        private TileIndexer tileIndexer;

        public ContainerIndexer(final TileIndexer tileIndexer, EntityPlayer player) {
            super(tileIndexer);
            int xi;
            this.player = player;
            this.scrollBar = new WidgetScrollBar(170, 4, 72, 0, 0);
            this.addWidget(this.scrollBar);
            this.addWidget(new WidgetRawData(){

                @Override
                public void addToDescription(PacketBuffer packet) {
                    packet.writeBoolean(tileIndexer.active);
                }

                @Override
                public void handleDescriptionPacket(PacketBuffer packet) {
                    tileIndexer.active = packet.readBoolean();
                }
            });
            this.addWidget(new WidgetRawData(){

                @Override
                public void addToDescription(final PacketBuffer packet) {
                    TObjectIntHashMap<ItemRef> countDown = tileIndexer.countDown;
                    packet.writeInt(countDown.size());
                    countDown.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<ItemRef>(){

                        public boolean execute(ItemRef a, int b) {
                            a.write(packet);
                            packet.writeInt(b);
                            return true;
                        }
                    });
                }

                @Override
                public void handleDescriptionPacket(PacketBuffer packet) {
                    int n = packet.readInt();
                    if (n == 0) {
                        if (!tileIndexer.countDown.isEmpty()) {
                            tileIndexer.countDown.clear();
                        }
                        return;
                    }
                    TObjectIntHashMap countDown = new TObjectIntHashMap(n);
                    for (int i = 0; i < n; ++i) {
                        ItemRef ref = ItemRef.read(packet);
                        countDown.put((Object)ref, packet.readInt());
                    }
                    tileIndexer.countDown = countDown;
                }
            });
            this.addWidget(new WidgetRawData(){
                long lastSentHash = 0L;

                @Override
                public void addToDescription(PacketBuffer packet) {
                    if (tileIndexer.itemsHash == this.lastSentHash) {
                        packet.writeBoolean(true);
                        return;
                    }
                    tileIndexer.itemsHash = this.lastSentHash;
                    packet.writeBoolean(false);
                    TObjectIntHashMap<ItemRef> counts = tileIndexer.counts;
                    packet.writeInt(counts.size());
                    TObjectIntIterator iterator = counts.iterator();
                    while (iterator.hasNext()) {
                        iterator.advance();
                        ((ItemRef)iterator.key()).write(packet);
                        packet.writeInt(iterator.value());
                    }
                }

                @Override
                public void handleDescriptionPacket(PacketBuffer packet) {
                    if (packet.readBoolean()) {
                        return;
                    }
                    TObjectIntHashMap items = new TObjectIntHashMap();
                    TreeSet<ItemRef> refTreeSet = new TreeSet<ItemRef>(ItemRefComparator.names);
                    int n = packet.readInt();
                    for (int i = 0; i < n; ++i) {
                        ItemRef itemRef = ItemRef.read(packet);
                        refTreeSet.add(itemRef);
                        int count = packet.readInt();
                        items.put((Object)itemRef, count);
                    }
                    tileIndexer.counts = items;
                    ContainerIndexer.this.list = Lists.newArrayList(refTreeSet);
                    int size = ContainerIndexer.this.list.size();
                    ContainerIndexer.this.scrollBar.setValues(0, Math.max(0, size / 9 - 4 + 1));
                }
            });
            for (int yi = 0; yi < 4; ++yi) {
                for (xi = 0; xi < 9; ++xi) {
                    int i = yi * 9 + xi;
                    this.addWidget(new WidgetItemRefButton(i, 4 + xi * 18, 4 + yi * 18));
                }
            }
            this.crop();
            int left = (this.width - 162) / 2;
            for (xi = 0; xi < 9; ++xi) {
                this.addWidget(new WidgetSlotItemHandler((IItemHandler)tileIndexer.stacks, xi, left + xi * 18, this.height){

                    public boolean func_75214_a(ItemStack stack) {
                        return false;
                    }
                });
            }
            for (xi = 0; xi < 9; ++xi) {
                this.addWidget(new WidgetSlotItemHandler((IItemHandler)tileIndexer.returnStacks, xi, left + xi * 18, this.height + 27){

                    public boolean func_82869_a(EntityPlayer playerIn) {
                        return false;
                    }
                });
            }
            this.cropAndAddPlayerSlots(player.field_71071_by);
            this.validate();
            this.tileIndexer = tileIndexer;
        }

        public class WidgetItemRefButton
        extends WidgetClickBase
        implements IWidgetClientNetwork {
            private final int i;

            public WidgetItemRefButton(int i, int x, int y) {
                super(x, y, 18, 18);
                this.i = i;
            }

            public ItemRef getRef() {
                if (!((ContainerIndexer)ContainerIndexer.this).tileIndexer.active) {
                    return ItemRef.NULL;
                }
                int j = this.i + ContainerIndexer.this.scrollBar.scrollValue * 9;
                if (j < 0) {
                    return ItemRef.NULL;
                }
                ArrayList<ItemRef> list = ContainerIndexer.this.list;
                if (j < list.size()) {
                    return list.get(j);
                }
                return ItemRef.NULL;
            }

            @Override
            public void receiveClientPacket(PacketBuffer buffer) {
                ItemRef read = ItemRef.read(buffer);
                if (read == ItemRef.NULL) {
                    return;
                }
                boolean b = buffer.readBoolean();
                ContainerIndexer.this.tileIndexer.order(read, b);
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public PacketBuffer getPacketToSend(int mouseButton) {
                PacketBuffer pkt = new PacketBuffer();
                ItemRef ref = this.getRef();
                if (ref == ItemRef.NULL) {
                    return null;
                }
                ref.write(pkt);
                pkt.writeBoolean(GuiContainer.func_146272_n());
                return pkt;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void renderForeground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
                float t;
                ItemRef ref = this.getRef();
                if (ref != ItemRef.NULL) {
                    int i = ((ContainerIndexer)ContainerIndexer.this).tileIndexer.counts.get((Object)ref);
                    String s = i <= 0 ? "0" : "" + i;
                    GlStateManager.func_179145_e();
                    RenderHelper.func_74520_c();
                    gui.renderSmallStackText(ref.createItemStack(1), s, guiLeft + this.getX() + 1, guiTop + this.getY() + 1);
                    RenderHelper.func_74518_a();
                    GlStateManager.func_179140_f();
                }
                if (((ContainerIndexer)ContainerIndexer.this).tileIndexer.active) {
                    int i1 = ((ContainerIndexer)ContainerIndexer.this).tileIndexer.countDown.get((Object)ref);
                    if (i1 <= 0) {
                        return;
                    }
                    t = (float)i1 / 10.0f % 1.0f;
                } else {
                    t = 1.0f;
                }
                if (t <= 0.0f) {
                    return;
                }
                GLStateAttributes states = GLStateAttributes.loadStates();
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(guiLeft + this.getX()), (float)(guiTop + this.getY()), (float)300.0f);
                GlStateManager.func_179147_l();
                GlStateManager.func_179097_i();
                GlStateManager.func_179118_c();
                GlStateManager.func_179090_x();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
                Tessellator instance = Tessellator.func_178181_a();
                WorldRenderer tess = instance.func_178180_c();
                tess.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                double angle = 1.5707963267948966 + (double)t * Math.PI * 2.0;
                float dx = (float)Math.cos(angle);
                float dy = (float)Math.sin(angle);
                float adx = Math.abs(dx);
                float ady = Math.abs(dy);
                if (adx < ady) {
                    dx /= ady;
                    dy = Math.signum(dy);
                } else {
                    dy /= adx;
                    dx = Math.signum(dx);
                }
                dx = (1.0f + dx) / 2.0f * 18.0f;
                dy = 18.0f - (1.0f + dy) / 2.0f * 18.0f;
                if ((double)t <= 0.125) {
                    tess.func_181662_b(9.0, 0.0, 0.0).func_181675_d();
                    tess.func_181662_b((double)dx, (double)dy, 0.0).func_181675_d();
                    tess.func_181662_b((double)dx, (double)dy, 0.0).func_181675_d();
                    tess.func_181662_b(9.0, 9.0, 0.0).func_181675_d();
                } else if ((double)t <= 0.375) {
                    tess.func_181662_b((double)dx, (double)dy, 0.0).func_181675_d();
                    tess.func_181662_b(9.0, 9.0, 0.0).func_181675_d();
                    tess.func_181662_b(9.0, 0.0, 0.0).func_181675_d();
                    tess.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
                } else if ((double)t <= 0.625) {
                    tess.func_181662_b(0.0, 18.0, 0.0).func_181675_d();
                    tess.func_181662_b(9.0, 9.0, 0.0).func_181675_d();
                    tess.func_181662_b(9.0, 0.0, 0.0).func_181675_d();
                    tess.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
                    tess.func_181662_b((double)dx, (double)dy, 0.0).func_181675_d();
                    tess.func_181662_b(9.0, 9.0, 0.0).func_181675_d();
                    tess.func_181662_b(9.0, 9.0, 0.0).func_181675_d();
                    tess.func_181662_b(0.0, 18.0, 0.0).func_181675_d();
                } else if ((double)t <= 0.875) {
                    tess.func_181662_b(0.0, 18.0, 0.0).func_181675_d();
                    tess.func_181662_b(9.0, 9.0, 0.0).func_181675_d();
                    tess.func_181662_b(9.0, 0.0, 0.0).func_181675_d();
                    tess.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
                    tess.func_181662_b(0.0, 18.0, 0.0).func_181675_d();
                    tess.func_181662_b(18.0, 18.0, 0.0).func_181675_d();
                    tess.func_181662_b((double)dx, (double)dy, 0.0).func_181675_d();
                    tess.func_181662_b(9.0, 9.0, 0.0).func_181675_d();
                } else if (t <= 1.0f) {
                    tess.func_181662_b(0.0, 18.0, 0.0).func_181675_d();
                    tess.func_181662_b(9.0, 9.0, 0.0).func_181675_d();
                    tess.func_181662_b(9.0, 0.0, 0.0).func_181675_d();
                    tess.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
                    tess.func_181662_b(0.0, 18.0, 0.0).func_181675_d();
                    tess.func_181662_b(18.0, 18.0, 0.0).func_181675_d();
                    tess.func_181662_b(18.0, 0.0, 0.0).func_181675_d();
                    tess.func_181662_b(9.0, 9.0, 0.0).func_181675_d();
                    tess.func_181662_b(18.0, 0.0, 0.0).func_181675_d();
                    tess.func_181662_b((double)dx, (double)dy, 0.0).func_181675_d();
                    tess.func_181662_b((double)dx, (double)dy, 0.0).func_181675_d();
                    tess.func_181662_b(9.0, 9.0, 0.0).func_181675_d();
                } else {
                    tess.func_181662_b(0.0, 18.0, 0.0).func_181675_d();
                    tess.func_181662_b(18.0, 18.0, 0.0).func_181675_d();
                    tess.func_181662_b(18.0, 0.0, 0.0).func_181675_d();
                    tess.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
                }
                instance.func_78381_a();
                GlStateManager.func_179098_w();
                GlStateManager.func_179141_d();
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
                states.restore();
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public List<String> getToolTip() {
                ItemRef ref = this.getRef();
                if (ref == ItemRef.NULL) {
                    return null;
                }
                ItemStack itemStack = ref.createItemStack(1);
                if (itemStack == null) {
                    return null;
                }
                return itemStack.func_82840_a(ContainerIndexer.this.player, Minecraft.func_71410_x().field_71474_y.field_82882_x);
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
                gui.drawSlotBackground(guiLeft + this.getX(), guiTop + this.getY());
            }
        }
    }

    public static class SidedPos {
        @Nonnull
        public final EnumFacing side;
        @Nonnull
        public final BlockPos pos;

        public SidedPos(@Nonnull BlockPos pos, @Nonnull EnumFacing side) {
            this.pos = pos;
            this.side = side;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SidedPos sidedPos = (SidedPos)o;
            return this.side == sidedPos.side && this.pos.equals((Object)sidedPos.pos);
        }

        public int hashCode() {
            return 31 * this.side.hashCode() + this.pos.hashCode();
        }
    }
}

