/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.transfernodes;

import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.XUItemFlatMetadata;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.transfernodes.TileIndexer;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.NBTHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class ItemIndexerRemote
extends XUItemFlatMetadata
implements IDynamicHandler {
    public ItemIndexerRemote() {
        super("indexer_remote");
        this.func_77625_d(1);
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("BlockPos", 10)) {
            return false;
        }
        if (worldIn.field_72995_K) {
            return worldIn.func_175625_s(pos) instanceof TileIndexer;
        }
        TileEntity entity = worldIn.func_175625_s(pos);
        if (!(entity instanceof TileIndexer)) {
            return false;
        }
        TileIndexer indexer = (TileIndexer)entity;
        if (!indexer.isValidPlayer(playerIn)) {
            return true;
        }
        NBTTagCompound nbt = NBTHelper.getOrInitTagCompound(stack);
        nbt.func_74768_a("Dimension", worldIn.field_73011_w.func_177502_q());
        nbt.func_74782_a("BlockPos", (NBTBase)NBTHelper.blockPosToNBT(pos));
        return true;
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        if (worldIn.field_72995_K) {
            return itemStackIn;
        }
        if (!itemStackIn.func_77942_o()) {
            return itemStackIn;
        }
        NBTTagCompound nbt = itemStackIn.func_77978_p();
        int dimension = nbt.func_74762_e("Dimension");
        WorldServer world = DimensionManager.getWorld((int)dimension);
        if (world == null) {
            playerIn.func_146105_b((IChatComponent)Lang.chat("Unable to contact indexer", new Object[0]));
            return itemStackIn;
        }
        BlockPos blockPos = NBTHelper.nbtToBlockPos(nbt.func_74775_l("BlockPos"));
        if (!world.func_175667_e(blockPos)) {
            playerIn.func_146105_b((IChatComponent)Lang.chat("Unable to contact indexer", new Object[0]));
            return itemStackIn;
        }
        TileEntity tile = world.func_175625_s(blockPos);
        if (!(tile instanceof TileIndexer)) {
            playerIn.func_146105_b((IChatComponent)Lang.chat("Unable to contact indexer", new Object[0]));
            return itemStackIn;
        }
        if (((TileIndexer)tile).isValidPlayer(playerIn)) {
            playerIn.openGui((Object)ExtraUtils2.instance, -1, (World)world, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
        }
        return itemStackIn;
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        TileIndexer indexer;
        BlockPos pos = new BlockPos(x, y, z);
        if (world.field_72995_K) {
            indexer = new TileIndexer();
            indexer.func_145834_a(world);
            indexer.func_174878_a(pos);
        } else {
            if (!world.func_175667_e(pos)) {
                return null;
            }
            TileEntity tile = world.func_175625_s(pos);
            if (!(tile instanceof TileIndexer)) {
                return null;
            }
            indexer = (TileIndexer)tile;
            indexer.positionsHash = 0L;
            indexer.reload();
        }
        return new TileIndexer.ContainerIndexer(indexer, player);
    }
}

