/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.transfernodes;

import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.transfernodes.Grocket;
import com.rwtema.extrautils2.transfernodes.TransferNodeItem;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public enum GrocketType {
    TRANSFER_NODE_ITEMS{

        @Override
        public Grocket create() {
            return new TransferNodeItem();
        }

        @Override
        public BoxModel createBaseModel() {
            BoxModel model = new BoxModel();
            model.addBoxI(1, 0, 1, 15, 1, 15);
            model.addBoxI(2, 1, 2, 14, 2, 14).setInvisible(0);
            model.addBoxI(4, 2, 4, 12, 4, 12).setTextureSides(new Object[0]).setInvisible(0);
            model.setTextures("transfernodes/transfernode_side", 0, "transfernodes/transfernode_back", 1, "transfernodes/transfernode_front");
            return model;
        }
    };

    BoxModel[] cache = new BoxModel[6];

    public abstract Grocket create();

    public abstract BoxModel createBaseModel();

    @Nonnull
    public BoxModel createBaseModel(EnumFacing facing) {
        BoxModel model = this.createBaseModel();
        model.rotateToSide(facing);
        for (Box box : model) {
            box.tint = 6 + facing.ordinal();
        }
        return model;
    }

    public ItemStack createStack() {
        return XU2Entries.grocket.newStack(this.ordinal());
    }
}

