/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.transfernodes;

import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.transfernodes.BlockTransferPipe;
import com.rwtema.extrautils2.transfernodes.Grocket;
import com.rwtema.extrautils2.transfernodes.TileTransferHolder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockTransferHolder
extends XUBlock {
    private static IBlockState holderState;

    public BlockTransferHolder() {
        super(Material.field_151576_e);
        holderState = this.func_176223_P();
    }

    public static boolean placePipe(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState.func_177230_c().func_176200_f(world, pos)) {
            return world.func_175656_a(pos, (IBlockState)BlockTransferPipe.stateBuilder.defaultState);
        }
        if (blockState == holderState) {
            TileEntity tile = world.func_175625_s(pos);
            if (!(tile instanceof TileTransferHolder)) {
                world.func_175713_t(pos);
                tile = world.func_175625_s(pos);
            }
            TileTransferHolder holder = (TileTransferHolder)tile;
            if (holder.centerPipe != null) {
                return false;
            }
            holder.centerPipe = BlockTransferPipe.stateBuilder.defaultState;
            world.func_175689_h(pos);
            return true;
        }
        return false;
    }

    public static boolean placeGrocket(EntityPlayer player, World world, BlockPos pos, Grocket grocket, EnumFacing facing) {
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState == holderState) {
            TileEntity tile = world.func_175625_s(pos);
            if (!(tile instanceof TileTransferHolder)) {
                world.func_175713_t(pos);
                tile = world.func_175625_s(pos);
            }
            TileTransferHolder holder = (TileTransferHolder)tile;
            if (holder.grockets[facing.ordinal()] != null) {
                return false;
            }
            holder.addGrocket(player, grocket, facing);
            world.func_175689_h(pos);
            return true;
        }
        if (BlockTransferPipe.stateBuilder.genericPipeStates.contains(blockState)) {
            world.func_175656_a(pos, holderState);
            world.func_175713_t(pos);
            TileTransferHolder tileEntity = (TileTransferHolder)world.func_175625_s(pos);
            tileEntity.addGrocket(player, grocket, facing);
            tileEntity.centerPipe = blockState;
            world.func_175689_h(pos);
            return true;
        }
        if (blockState.func_177230_c().func_176200_f(world, pos)) {
            world.func_175656_a(pos, holderState);
            TileTransferHolder tileEntity = (TileTransferHolder)world.func_175625_s(pos);
            tileEntity.addGrocket(player, grocket, facing);
            world.func_175689_h(pos);
            return true;
        }
        return false;
    }

    public boolean isToolEffective(String type, IBlockState state) {
        return true;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    @Override
    @Nonnull
    public BoxModel getWorldModel(IBlockAccess world, BlockPos pos, @Nullable IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileTransferHolder) {
            TileTransferHolder transferHolder = (TileTransferHolder)tileEntity;
            BoxModel worldModel = transferHolder.worldModel;
            if (worldModel != null) {
                return worldModel;
            }
            worldModel = new BoxModel();
            IBlockState centerPipe = transferHolder.centerPipe;
            if (centerPipe != null) {
                worldModel.addAll(((BlockTransferPipe)BlockTransferPipe.stateBuilder.mainBlock).getWorldModel(world, pos, centerPipe));
            }
            Grocket[] grockets = transferHolder.grockets;
            for (EnumFacing facing : EnumFacing.values()) {
                Grocket grocket = grockets[facing.ordinal()];
                if (grocket == null) continue;
                worldModel.addAll(grocket.getWorldModel(facing));
            }
            return worldModel;
        }
        return new BoxModel(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public BoxModel getRenderModel(IBlockAccess world, BlockPos pos, @Nullable IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileTransferHolder) {
            TileTransferHolder transferHolder = (TileTransferHolder)tileEntity;
            BoxModel worldModel = transferHolder.worldModel;
            if (worldModel != null) {
                return worldModel;
            }
            worldModel = new BoxModel();
            IBlockState centerPipe = transferHolder.centerPipe;
            if (centerPipe != null) {
                worldModel.addAll(((BlockTransferPipe)BlockTransferPipe.stateBuilder.mainBlock).getRenderModel(world, pos, centerPipe));
            }
            Grocket[] grockets = transferHolder.grockets;
            for (EnumFacing facing : EnumFacing.values()) {
                Grocket grocket = grockets[facing.ordinal()];
                if (grocket == null) continue;
                worldModel.addAll(grocket.getWorldModel(facing));
            }
            return worldModel;
        }
        return new BoxModel(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileTransferHolder();
    }

    @Override
    @Nonnull
    public BoxModel getInventoryModel(@Nullable ItemStack item) {
        return new BoxModel();
    }

    @Override
    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te) {
        if (te instanceof TileTransferHolder) {
            TileTransferHolder holder = (TileTransferHolder)te;
            if (holder.centerPipe != null) {
                BlockTransferHolder.func_180635_a((World)world, (BlockPos)pos, (ItemStack)XU2Entries.pipe.newStack());
            }
            for (Grocket grocket : holder.grockets) {
                if (grocket == null) continue;
                for (ItemStack itemStack : grocket.getDrops()) {
                    BlockTransferHolder.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemStack);
                }
            }
        } else {
            super.func_180657_a(world, player, pos, state, null);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileTransferHolder) {
            TileTransferHolder holder = (TileTransferHolder)tileEntity;
            if (holder.centerPipe != null) {
                list.add(XU2Entries.pipe.newStack());
            }
            for (Grocket grocket : holder.grockets) {
                if (grocket == null) continue;
                list.addAll(grocket.getDrops());
            }
        }
        return list;
    }
}

