/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.google.common.collect.Lists;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.model.XUBlockState;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.itemhandler.ConcatItemHandler;
import com.rwtema.extrautils2.itemhandler.InventoryHelper;
import com.rwtema.extrautils2.network.PacketBuffer;
import com.rwtema.extrautils2.utils.helpers.NBTHelper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public abstract class XUTile
extends TileEntity {
    @Nullable
    public HashMap<Capability<?>, XUTileCapabilitySide<?, ?>> sidedCapabilities;
    XUBlock xuBlock;
    XUBlockState state;
    @Nullable
    private HashMap<String, INBTSerializable> nbtHandlers;

    public static boolean isLoaded(TileEntity tile) {
        return !tile.func_145837_r() && tile.func_145831_w() != null && tile.func_174877_v() != null && tile.func_145831_w().func_175667_e(tile.func_174877_v()) && tile.func_145831_w().func_175625_s(tile.func_174877_v()) == tile;
    }

    public static <T extends TileEntity> List<T> searchAABBForTiles(World world, AxisAlignedBB area, Class<T> tileClazz, boolean firstOnly, List<T> list) {
        int x0 = (int)Math.floor(area.field_72340_a) >> 4;
        int x1 = (int)Math.ceil(area.field_72336_d) >> 4;
        int z0 = (int)Math.floor(area.field_72339_c) >> 4;
        int z1 = (int)Math.ceil(area.field_72334_f) >> 4;
        if (list == null) {
            list = Lists.newArrayList();
        }
        for (int x = x0; x <= x1; ++x) {
            for (int z = z0; z <= z1; ++z) {
                Chunk chunk = world.func_72964_e(x, z);
                for (Map.Entry entry : chunk.func_177434_r().entrySet()) {
                    BlockPos pos = (BlockPos)entry.getKey();
                    if (tileClazz != ((TileEntity)entry.getValue()).getClass() || !area.func_72318_a(new Vec3((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5))) continue;
                    list.add((TileEntity)entry.getValue());
                    if (!firstOnly) continue;
                    return list;
                }
            }
        }
        return list;
    }

    protected <T extends INBTSerializable> T registerNBT(String key, T t) {
        if (this.nbtHandlers == null) {
            this.nbtHandlers = new HashMap();
        }
        this.nbtHandlers.put(key, t);
        return t;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (this.nbtHandlers != null) {
            for (Map.Entry entry : this.nbtHandlers.entrySet()) {
                NBTBase tag = compound.func_74781_a((String)entry.getKey());
                if (tag == null) continue;
                ((INBTSerializable)entry.getValue()).deserializeNBT(tag);
            }
        }
        if (this.sidedCapabilities != null) {
            for (XUTileCapabilitySide xUTileCapabilitySide : this.sidedCapabilities.values()) {
                xUTileCapabilitySide.readNBT(compound);
            }
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        if (this.nbtHandlers != null) {
            for (Map.Entry entry : this.nbtHandlers.entrySet()) {
                compound.func_74782_a((String)entry.getKey(), ((INBTSerializable)entry.getValue()).serializeNBT());
            }
        }
        if (this.sidedCapabilities != null) {
            for (XUTileCapabilitySide xUTileCapabilitySide : this.sidedCapabilities.values()) {
                xUTileCapabilitySide.writeNBT(compound);
            }
        }
    }

    public boolean isLoaded() {
        return XUTile.isLoaded(this);
    }

    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack, XUBlock xuBlock) {
    }

    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
    }

    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        IItemHandler itemHandler = this.getItemHandler(null);
        if (itemHandler != null) {
            InventoryHelper.dropAll(worldIn, pos, itemHandler);
        }
    }

    public boolean harvestBlock(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state) {
        return false;
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.xuBlock = null;
        this.state = null;
    }

    public XUBlockState getBlockState() {
        if (this.state == null) {
            this.state = (XUBlockState)this.field_145850_b.func_180495_p(this.field_174879_c);
        }
        return this.state;
    }

    public XUBlock getXUBlock() {
        if (this.xuBlock == null) {
            this.xuBlock = (XUBlock)this.getBlockState().func_177230_c();
        }
        return this.xuBlock;
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this instanceof IDynamicHandler) {
            if (!worldIn.field_72995_K) {
                this.openGUI(playerIn);
            }
            return true;
        }
        return false;
    }

    public void openGUI(EntityPlayer player) {
        this.openGUI(player, 0);
    }

    public void openGUI(EntityPlayer player, int modGuiId) {
        player.openGui((Object)ExtraUtils2.instance, modGuiId, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
    }

    public IItemHandler getItemHandler(EnumFacing facing) {
        return null;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        IItemHandler handler;
        XUTileCapabilitySide<?, ?> capabilityEntry;
        Object handler2;
        if (this.sidedCapabilities != null && this.sidedCapabilities.containsKey(capability) && (handler2 = (capabilityEntry = this.sidedCapabilities.get(capability)).get(facing)) != null) {
            return (T)handler2;
        }
        if (CapabilityItemHandler.ITEM_HANDLER_CAPABILITY == capability && (handler = this.getItemHandler(facing)) != null) {
            return (T)handler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public final boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public void addToDescriptionPacket(PacketBuffer packet) {
    }

    public void handleDescriptionPacket(PacketBuffer packet) {
    }

    public Packet func_145844_m() {
        ByteBuf buffer = Unpooled.buffer();
        this.addToDescriptionPacket(new PacketBuffer(buffer));
        int readableBytes = buffer.readableBytes();
        if (readableBytes == 0) {
            return null;
        }
        byte[] b = new byte[readableBytes];
        buffer.readBytes(b);
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74773_a("a", b);
        return new S35PacketUpdateTileEntity(this.field_174879_c, -1, tags);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound nbtCompound = pkt.func_148857_g();
        if (nbtCompound.func_150297_b("a", 7)) {
            this.handleDescriptionPacket(new PacketBuffer(Unpooled.wrappedBuffer((byte[])nbtCompound.func_74770_j("a"))));
        }
        super.onDataPacket(net, pkt);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderBakedModel(IBlockAccess world, WorldRenderer renderer, BlockRendererDispatcher blockRenderer, IBakedModel model) {
        blockRenderer.func_175019_b().func_178267_a(world, model, (IBlockState)this.getBlockState(), this.func_174877_v(), renderer, false);
    }

    public static abstract class XUTileCapabilitySide<T, S extends Enum<S>> {
        public final XUTileSideManager<S> manager;
        private final XUTile parent;
        private final Capability<T> capability;
        private final T defaultValue;
        public EnumMap<EnumFacing, S> choices = new EnumMap(EnumFacing.class);
        EnumMap<S, T> sidedChoices;

        public XUTileCapabilitySide(XUTile parent, XUTileSideManager<S> manager, Capability<T> capability, T defaultValue, T ... values) {
            this.parent = parent;
            this.manager = manager;
            this.capability = capability;
            this.defaultValue = defaultValue;
            this.choices.putAll(manager.defaultChoices);
            this.sidedChoices = new EnumMap(manager.basePassThru);
            if (values.length != manager.values.length) {
                throw new IllegalArgumentException("Insufficent handlers");
            }
            for (int i = 0; i < values.length; ++i) {
                this.sidedChoices.put((S)manager.values[i], values[i]);
            }
            if (parent.sidedCapabilities == null) {
                parent.sidedCapabilities = new HashMap();
            }
            parent.sidedCapabilities.put(capability, this);
        }

        public void readNBT(NBTTagCompound compound) {
            NBTTagCompound tagCompound = NBTHelper.getOrInitTagCompound(compound, this.capability.getName());
            for (EnumFacing facing : EnumFacing.values()) {
                byte i;
                String name = facing.func_176610_l();
                if (!tagCompound.func_150297_b(name, 1) || (i = tagCompound.func_74771_c(name)) < 0 || i >= this.manager.values.length) {
                    this.choices.put(facing, this.manager.defaultChoices.get(facing));
                    continue;
                }
                this.choices.put(facing, this.manager.values[i]);
            }
        }

        public void setValue(EnumFacing facing, int ordinal) {
            if (ordinal < 0 || ordinal >= this.manager.values.length) {
                this.choices.put(facing, this.manager.defaultChoices.get(facing));
            } else {
                this.choices.put(facing, this.manager.values[ordinal]);
            }
        }

        public void writeNBT(NBTTagCompound compound) {
            NBTTagCompound tagCompound = NBTHelper.getOrInitTagCompound(compound, this.capability.getName());
            S[] values = this.manager.values;
            for (EnumFacing facing : EnumFacing.values()) {
                String name = facing.func_176610_l();
                Enum s = (Enum)this.choices.get(facing);
                tagCompound.func_74774_a(name, (byte)s.ordinal());
            }
        }

        public T get(EnumFacing facing) {
            if (facing == null) {
                return this.defaultValue;
            }
            return this.sidedChoices.get(this.getValue(facing));
        }

        public void cycleForward(EnumFacing side) {
            this.cycle(1, side);
        }

        public void cycleBackward(EnumFacing side) {
            this.cycle(-1, side);
        }

        public void cycle(int increase, EnumFacing side) {
            int i = (this.manager.values.length + ((Enum)this.choices.get(side)).ordinal() + increase) % this.manager.values.length;
            this.choices.put(side, this.manager.values[i]);
            this.parent.func_70296_d();
        }

        public S getValue(EnumFacing facing) {
            Enum s = (Enum)this.choices.get(facing);
            if (s == null) {
                s = (Enum)this.manager.defaultChoices.get(facing);
                this.choices.put(facing, (S)s);
            }
            return (S)s;
        }
    }

    public static class XUTileSideManager<S extends Enum<S>> {
        public final S[] values;
        public final EnumMap<EnumFacing, S> defaultChoices = new EnumMap(EnumFacing.class);
        public final Class<S> enumClass;
        public final EnumMap<S, ?> basePassThru;

        public XUTileSideManager(Class<S> enumClass, S[] defaultChoices) {
            this.enumClass = enumClass;
            this.values = (Enum[])enumClass.getEnumConstants();
            for (int i = 0; i < 6; ++i) {
                this.defaultChoices.put(EnumFacing.values()[i], defaultChoices[Math.min(i, defaultChoices.length - 1)]);
            }
            this.basePassThru = new EnumMap(enumClass);
        }
    }

    public static class XUTileSideItemHandlerXUTile<S extends Enum<S>>
    extends XUTileCapabilitySide<IItemHandler, S> {
        public XUTileSideItemHandlerXUTile(XUTile parent, XUTileSideManager<S> manager, IItemHandler ... values) {
            super(parent, manager, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, ConcatItemHandler.concatNonNull(values), values);
        }
    }

    public static enum IN_OUT_DISABLED {
        INPUT,
        OUTPUT,
        DISABLED;

        public static IN_OUT_DISABLED[] _default;
        public static XUTileSideManager<IN_OUT_DISABLED> defaultManager;

        public static XUTileSideItemHandlerXUTile<IN_OUT_DISABLED> newItemHandlerInstance(XUTile parent, IItemHandler input, IItemHandler output) {
            return new XUTileSideItemHandlerXUTile<IN_OUT_DISABLED>(parent, defaultManager, input, output, EmptyHandler.INSTANCE);
        }

        static {
            _default = new IN_OUT_DISABLED[]{OUTPUT, INPUT, OUTPUT};
            defaultManager = new XUTileSideManager(IN_OUT_DISABLED.class, (Enum[])_default);
        }
    }
}

