/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.rwtema.extrautils2.asm.Lighting;
import com.rwtema.extrautils2.lighting.ILight;
import com.rwtema.extrautils2.tile.TilePower;
import com.rwtema.extrautils2.utils.helpers.LightMathHelper;
import java.util.EnumMap;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class TileSun
extends TilePower
implements ILight {
    private static final int range = 120;

    @Override
    public World getLightWorld() {
        return this.field_145850_b;
    }

    @Override
    public float getLightOffset(BlockPos lightPos) {
        float dz;
        float dy;
        float dx = lightPos.func_177958_n() - this.field_174879_c.func_177958_n();
        float mH = 1.0f - LightMathHelper.approxSqrt(dx * dx + (dy = (float)(lightPos.func_177956_o() - this.field_174879_c.func_177956_o())) * dy + (dz = (float)(lightPos.func_177952_p() - this.field_174879_c.func_177952_p())) * dz, 14400.0f);
        if (mH < 0.06666665f) {
            return 0.0f;
        }
        Chunk chunk = this.field_145850_b.func_175726_f(lightPos);
        int lightFor = chunk.func_177413_a(EnumSkyBlock.SKY, lightPos);
        return 0.0f;
    }

    public float sqr(float a) {
        return a * a;
    }

    @Override
    public EnumSkyBlock[] getLightType() {
        return new EnumSkyBlock[]{EnumSkyBlock.BLOCK};
    }

    @Override
    public void onPowerChanged() {
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    @Override
    public float getPower() {
        return 16.0f;
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74757_a("Active", this.active);
        return new S35PacketUpdateTileEntity(this.field_174879_c, -1, tags);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        boolean b = nbt.func_74767_n("Active");
        if (b != this.active) {
            this.active = b;
            this.updateLight();
        }
    }

    private void updateLight() {
        this.field_145850_b.func_147458_c(this.field_174879_c.func_177958_n() - 120, this.field_174879_c.func_177956_o() - 120, this.field_174879_c.func_177952_p() - 120, this.field_174879_c.func_177958_n() + 120, this.field_174879_c.func_177956_o() + 120, this.field_174879_c.func_177952_p() + 120);
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        Lighting.unregister(this, this.getLightMap());
        if (this.field_145850_b.field_72995_K) {
            this.updateLight();
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        Lighting.unregister(this, this.getLightMap());
        if (this.field_145850_b.field_72995_K) {
            this.updateLight();
        }
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        Lighting.register(this, this.getLightMap());
    }

    protected WeakHashMap<World, EnumMap<EnumSkyBlock, Set<ILight>>> getLightMap() {
        return Lighting.plusLights;
    }
}

