/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.rwtema.extrautils2.asm.Lighting;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.blocks.BlockSpotlight;
import com.rwtema.extrautils2.lighting.ILight;
import com.rwtema.extrautils2.tile.TilePower;
import com.rwtema.extrautils2.utils.helpers.LightMathHelper;
import com.rwtema.extrautils2.utils.helpers.NBTHelper;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class TileSpotlight
extends TilePower
implements ILight {
    public static final int range = 78;
    public static final int range_side = 32;
    public static final int range_back = 1;
    public static final float POWER = 4.0f;
    public static HashMap<EnumFacing, float[]> baseNormals;
    public float[] normal;

    private static void initNormals() {
        baseNormals = new HashMap();
        baseNormals.put(EnumFacing.DOWN, new float[]{0.0f, -1.0f, 0.0f});
        baseNormals.put(EnumFacing.UP, new float[]{0.0f, 1.0f, 0.0f});
        float sqr2 = (float)Math.sqrt(0.5);
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            float[] normal = new float[]{(float)facing.func_82601_c() * sqr2, -sqr2, (float)facing.func_82599_e() * sqr2};
            baseNormals.put(facing, normal);
        }
    }

    @Override
    public float getPower() {
        return 4.0f;
    }

    @Override
    public World getLightWorld() {
        return this.field_145850_b;
    }

    @Override
    public float getLightOffset(BlockPos p) {
        float foreDist;
        if (!this.active) {
            return 0.0f;
        }
        if (this.normal == null) {
            this.normal = this.getBaseNormal();
        }
        if ((foreDist = 1.0f + this.normal[0] * (float)(p.func_177958_n() - this.field_174879_c.func_177958_n()) + this.normal[1] * (float)(p.func_177956_o() - this.field_174879_c.func_177956_o()) + this.normal[2] * (float)(p.func_177952_p() - this.field_174879_c.func_177952_p())) <= 0.0f) {
            return 0.0f;
        }
        float sideDist = this.dist((float)(p.func_177958_n() - this.field_174879_c.func_177958_n()) - foreDist * this.normal[0], (float)(p.func_177956_o() - this.field_174879_c.func_177956_o()) - foreDist * this.normal[1], (float)(p.func_177952_p() - this.field_174879_c.func_177952_p()) - foreDist * this.normal[2]);
        float mH = 1.0f - LightMathHelper.approxSqrt(foreDist * foreDist + sideDist * sideDist, 6084.0f);
        if (mH < 0.0f) {
            return 0.0f;
        }
        if ((mH *= 1.0f - sideDist / (0.5f + foreDist) / 2.0f) < 0.0f) {
            return 0.0f;
        }
        return Math.min(mH * 16.0f, 16.0f);
    }

    private float dist(float a, float b, float c) {
        return MathHelper.func_76129_c((float)(a * a + b * b + c * c));
    }

    public float sqr(float a) {
        return a * a;
    }

    @Override
    public EnumSkyBlock[] getLightType() {
        return new EnumSkyBlock[]{EnumSkyBlock.BLOCK};
    }

    @Override
    public void onPowerChanged() {
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74757_a("Active", this.active);
        this.writeNormal(tags);
        return new S35PacketUpdateTileEntity(this.field_174879_c, -1, tags);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        boolean b = nbt.func_74767_n("Active");
        float[] prevNormal = this.normal != null ? (float[])this.normal.clone() : null;
        this.readNormal(nbt);
        if (b != this.active || !Arrays.equals(prevNormal, this.normal)) {
            BlockSpotlight.worldModelCache.remove(this);
            BlockSpotlight.renderModelCache.remove(this);
            this.active = b;
            this.updateLight();
        }
    }

    private void updateLight() {
        this.field_145850_b.func_147458_c(this.field_174879_c.func_177958_n() - 78, this.field_174879_c.func_177956_o() - 78, this.field_174879_c.func_177952_p() - 78, this.field_174879_c.func_177958_n() + 78, this.field_174879_c.func_177956_o() + 78, this.field_174879_c.func_177952_p() + 78);
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.writeNormal(compound);
    }

    protected void writeNormal(NBTTagCompound compound) {
        if (this.normal != null) {
            NBTTagCompound normal = NBTHelper.getOrInitTagCompound(compound, "Normal");
            normal.func_74776_a("NormalX", this.normal[0]);
            normal.func_74776_a("NormalY", this.normal[1]);
            normal.func_74776_a("NormalZ", this.normal[2]);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readNormal(compound);
    }

    protected void readNormal(NBTTagCompound compound) {
        if (compound.func_150297_b("Normal", 10)) {
            this.normal = new float[3];
            NBTTagCompound normalTag = compound.func_74775_l("Normal");
            this.normal[0] = normalTag.func_74760_g("NormalX");
            this.normal[1] = normalTag.func_74760_g("NormalY");
            this.normal[2] = normalTag.func_74760_g("NormalZ");
        } else {
            this.normal = null;
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        Lighting.unregister(this, this.getLightMap());
        if (this.field_145850_b.field_72995_K) {
            this.updateLight();
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        Lighting.unregister(this, this.getLightMap());
        if (this.field_145850_b.field_72995_K) {
            this.updateLight();
        }
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        Lighting.register(this, this.getLightMap());
    }

    protected WeakHashMap<World, EnumMap<EnumSkyBlock, Set<ILight>>> getLightMap() {
        return Lighting.plusLights;
    }

    public float[] getBaseNormal() {
        if (this.normal == null) {
            EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)XUBlockStateCreator.ROTATION_HORIZONTAL_INC_DOWN);
            this.normal = (float[])baseNormals.get(facing).clone();
        }
        return this.normal;
    }

    @Override
    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack, XUBlock xuBlock) {
        super.onBlockPlacedBy(worldIn, pos, state, placer, stack, xuBlock);
        this.normal = null;
        this.updateNormal(state, placer);
    }

    public void updateNormal(IBlockState state, EntityLivingBase placer) {
        double v;
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)XUBlockStateCreator.ROTATION_ALL);
        Vec3 lookVec = placer.func_70040_Z();
        lookVec = lookVec.func_72432_b();
        if (this.normal != null && (v = lookVec.func_72430_b(new Vec3((double)this.normal[0], (double)this.normal[1], (double)this.normal[2]))) > 0.995) {
            lookVec = new Vec3(-lookVec.field_72450_a, -lookVec.field_72448_b, -lookVec.field_72449_c);
        }
        this.normal = (v = lookVec.func_72430_b(new Vec3(facing.func_176730_m()))) < 0.75 ? new float[]{(float)lookVec.field_72450_a, (float)lookVec.field_72448_b, (float)lookVec.field_72449_c} : baseNormals.get(facing);
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (this.isValidPlayer(playerIn)) {
            return false;
        }
        this.updateNormal(state, (EntityLivingBase)playerIn);
        worldIn.func_175689_h(pos);
        return true;
    }

    public boolean canRenderBreaking() {
        return true;
    }

    static {
        TileSpotlight.initNormals();
    }
}

