/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.network.SpecialChat;
import com.rwtema.extrautils2.power.Freq;
import com.rwtema.extrautils2.power.IPower;
import com.rwtema.extrautils2.power.IWorldPowerMultiplier;
import com.rwtema.extrautils2.power.PowerManager;
import com.rwtema.extrautils2.tile.XUTile;
import com.rwtema.extrautils2.utils.Lang;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public abstract class TilePower
extends XUTile
implements IPower {
    public static final String NBT_FREQUENCY = "Frequency";
    public static final String NBT_ACTIVE = "Active";
    public static final int FREQUENCY_CREATIVE = 1337;
    public int frequency;
    public boolean active;

    @Override
    public World world() {
        return this.func_145831_w();
    }

    @Override
    public int frequency() {
        return this.frequency;
    }

    @Override
    public void powerChanged(boolean powered) {
        if (this.active != powered) {
            this.active = powered;
            this.func_70296_d();
            this.onPowerChanged();
        }
    }

    public abstract void onPowerChanged();

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74768_a(NBT_FREQUENCY, this.frequency);
        compound.func_74757_a(NBT_ACTIVE, this.active);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.frequency = compound.func_74762_e(NBT_FREQUENCY);
        this.active = compound.func_74767_n(NBT_ACTIVE);
    }

    @Override
    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack, XUBlock xuBlock) {
        if (!this.field_145850_b.field_72995_K && placer instanceof EntityPlayerMP) {
            this.frequency = Freq.getBasePlayerFreq((EntityPlayerMP)placer);
        }
    }

    @Override
    public IWorldPowerMultiplier getMultiplier() {
        return IWorldPowerMultiplier.CONSTANT;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            PowerManager.instance.removePowerHandler(this);
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (!this.field_145850_b.field_72995_K) {
            PowerManager.instance.removePowerHandler(this);
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K) {
            PowerManager.instance.addPowerHandler(this);
        }
    }

    public boolean isValidPlayer(EntityPlayer playerIn) {
        return PowerManager.canUse(playerIn, this);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.getBlockState().getUnlocalizedName();
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this instanceof IDynamicHandler) {
            if (!worldIn.field_72995_K) {
                if (PowerManager.canUse(playerIn, this)) {
                    this.openGUI(playerIn);
                } else {
                    SpecialChat.sendChat(playerIn, (IChatComponent)Lang.chat("Access Denied.", new Object[0]));
                }
            }
            return true;
        }
        return false;
    }
}

