/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.rwtema.extrautils2.asm.Lighting;
import com.rwtema.extrautils2.lighting.ILight;
import com.rwtema.extrautils2.tile.XUTile;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class TileLight
extends XUTile
implements ILight {
    static final int r = 96;
    public boolean active = false;

    @Override
    public World getLightWorld() {
        return this.field_145850_b;
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        boolean b = pkt.func_148857_g().func_74767_n("Active");
        if (b != this.active) {
            this.active = b;
            this.updateLight();
        }
    }

    private void updateLight() {
        this.field_145850_b.func_147458_c(this.field_174879_c.func_177958_n() - 96, this.field_174879_c.func_177956_o() - 96, this.field_174879_c.func_177952_p() - 96, this.field_174879_c.func_177958_n() + 96, this.field_174879_c.func_177956_o() + 96, this.field_174879_c.func_177952_p() + 96);
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74757_a("Active", this.active);
        return new S35PacketUpdateTileEntity(this.field_174879_c, -1, tags);
    }

    @Override
    public float getLightOffset(BlockPos pos) {
        if (!this.active) {
            return 0.0f;
        }
        return Math.max(15 - this.getRange(pos) * 15 / 96, 0);
    }

    public int getRange(BlockPos pos) {
        return Math.abs(this.field_174879_c.func_177958_n() - pos.func_177958_n()) + Math.abs(this.field_174879_c.func_177956_o() - pos.func_177956_o()) + Math.abs(this.field_174879_c.func_177952_p() - pos.func_177952_p());
    }

    @Override
    public EnumSkyBlock[] getLightType() {
        return new EnumSkyBlock[]{EnumSkyBlock.BLOCK};
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        Lighting.unregister(this, Lighting.plusLights);
        if (this.field_145850_b.field_72995_K) {
            this.updateLight();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        Lighting.unregister(this, Lighting.plusLights);
        if (this.field_145850_b.field_72995_K) {
            this.updateLight();
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        Lighting.register(this, Lighting.plusLights);
    }
}

