/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.rwtema.extrautils2.asm.Lighting;
import com.rwtema.extrautils2.lighting.ILight;
import com.rwtema.extrautils2.network.PacketBuffer;
import com.rwtema.extrautils2.tile.XUTile;
import com.rwtema.extrautils2.tile.tesr.ITESRHook;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import com.rwtema.extrautils2.utils.helpers.BlockStates;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEvil
extends XUTile
implements ILight,
ITESRHook {
    NBTSerializable.Float range = this.registerNBT("Range", new NBTSerializable.Float(0.0f));

    @Override
    public World getLightWorld() {
        return this.field_145850_b;
    }

    @Override
    public float getLightOffset(BlockPos lightPos) {
        int dx = lightPos.func_177958_n() - this.field_174879_c.func_177958_n();
        int dz = lightPos.func_177952_p() - this.field_174879_c.func_177952_p();
        int ri = Math.abs(dx) + Math.abs(lightPos.func_177956_o() - this.field_174879_c.func_177956_o()) + Math.abs(dz);
        if ((float)ri >= this.range.value) {
            return 0.0f;
        }
        float r = this.range.value - (float)ri;
        if (r > 16.0f) {
            r = 16.0f;
        }
        float v = (float)Math.atan2(dx, dz);
        float v2 = (1.0f + MathHelper.func_76134_b((float)(r / 24.0f + v * 10.0f))) / 2.0f;
        return -r * v2;
    }

    @Override
    public EnumSkyBlock[] getLightType() {
        return new EnumSkyBlock[]{EnumSkyBlock.BLOCK, EnumSkyBlock.SKY};
    }

    public void func_145843_s() {
        super.func_145843_s();
        Lighting.unregister(this, Lighting.negLights);
        if (this.field_145850_b.field_72995_K) {
            this.updateLight();
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        Lighting.register(this, Lighting.negLights);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        Lighting.unregister(this, Lighting.negLights);
        if (this.field_145850_b.field_72995_K) {
            this.updateLight();
        }
    }

    @Override
    public void addToDescriptionPacket(PacketBuffer packet) {
        packet.writeFloat(this.range.value);
    }

    @Override
    public void handleDescriptionPacket(PacketBuffer packet) {
        this.range.value = packet.readFloat();
        this.updateLight();
    }

    private void updateLight() {
        int r = (int)Math.ceil(this.range.value);
        this.field_145850_b.func_147458_c(this.field_174879_c.func_177958_n() - r, this.field_174879_c.func_177956_o() - r, this.field_174879_c.func_177952_p() - r, this.field_174879_c.func_177958_n() + r, this.field_174879_c.func_177956_o() + r, this.field_174879_c.func_177952_p() + r);
    }

    @Override
    public void render(IBlockAccess world, BlockPos pos, double x, double y, double z, float partialTicks, int destroyStage, WorldRenderer renderer, BlockRendererDispatcher blockRenderer) {
        IBakedModel model = blockRenderer.func_175022_a(BlockStates.enchanting_table, world, pos);
        this.renderBakedModel(world, renderer, blockRenderer, model);
    }
}

