/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.mojang.authlib.GameProfile;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.chunkloading.XUChunkLoaderManager;
import com.rwtema.extrautils2.tile.TilePower;
import com.rwtema.extrautils2.utils.helpers.NBTHelper;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;

public class TileChunkLoader
extends TilePower {
    private GameProfile profile;
    public final int CHUNK_RANGE = 1;

    @Override
    public void onPowerChanged() {
        XUChunkLoaderManager.dirty = true;
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        if (this.profile != null) {
            compound.func_74782_a("profile", (NBTBase)NBTHelper.proifleToNBT(this.profile));
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.profile = NBTHelper.profileFromNBT(compound.func_74775_l("profile"));
    }

    @Override
    public float getPower() {
        return 8.0f;
    }

    public GameProfile getProfile() {
        return this.profile;
    }

    public Collection<ChunkCoordIntPair> getChunkCoords() {
        ArrayList<ChunkCoordIntPair> list = new ArrayList<ChunkCoordIntPair>(10);
        int x = this.func_174877_v().func_177958_n() >> 4;
        int z = this.func_174877_v().func_177952_p() >> 4;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                list.add(new ChunkCoordIntPair(x + dx, z + dz));
            }
        }
        return list;
    }

    @Override
    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack, XUBlock xuBlock) {
        if (placer instanceof EntityPlayerMP) {
            GameProfile gameProfile = ((EntityPlayerMP)placer).func_146103_bH();
            this.profile = new GameProfile(gameProfile.getId(), gameProfile.getName());
        }
        super.onBlockPlacedBy(worldIn, pos, state, placer, stack, xuBlock);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            XUChunkLoaderManager.unregister(this);
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (!this.field_145850_b.field_72995_K) {
            XUChunkLoaderManager.unregister(this);
        }
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K) {
            XUChunkLoaderManager.register(this);
        }
    }
}

