/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.textures;

import com.google.common.collect.Lists;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.utils.LogHelper;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.util.ResourceLocation;

public class TextureSub
extends TextureAtlasSprite {
    String name;
    int x;
    int y;
    int size;
    int image_width;
    int image_height;

    public TextureSub(String spriteName, int x, int y, int image_width, int image_height, int size) {
        super(spriteName);
        this.x = x;
        this.y = y;
        this.size = size;
        this.image_width = image_width;
        this.image_height = image_height;
        this.name = spriteName + "_" + x + "_" + y + "_" + image_width + "_" + image_height + "_" + size;
    }

    public String func_94215_i() {
        return this.name;
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    public boolean load(IResourceManager par1ResourceManager, ResourceLocation location) {
        ResourceLocation resourcelocation = new ResourceLocation("ExtraUtils2:connected/" + super.func_94215_i());
        ResourceLocation resourcelocation1 = Textures.completeTextureResourceLocation(resourcelocation);
        try {
            IResource iresource = par1ResourceManager.func_110536_a(resourcelocation1);
            BufferedImage[] abufferedimage = new BufferedImage[1 + Minecraft.func_71410_x().field_71474_y.field_151442_I];
            abufferedimage[0] = ImageIO.read(iresource.func_110527_b());
            this.func_180598_a(abufferedimage, null);
        }
        catch (IOException ioexception1) {
            LogHelper.logger.error("Using missing texture, unable to load " + resourcelocation1, (Throwable)ioexception1);
            return true;
        }
        return false;
    }

    public void func_180598_a(BufferedImage[] p_147964_1_, AnimationMetadataSection p_147964_2_) {
        int s;
        this.func_110968_a(Lists.newArrayList());
        int w = p_147964_1_[0].getWidth();
        int h = p_147964_1_[0].getHeight();
        if (w % this.image_width != 0) {
            throw new RuntimeException("Wrong width (must be divisible by " + this.image_width + ")");
        }
        if (h % this.image_height != 0) {
            throw new RuntimeException("Wrong height (must be divisible by " + this.image_height + ")");
        }
        int scale = w / this.image_width;
        if (this.image_height * scale != h) {
            throw new RuntimeException("Wrong aspect ratio (must be " + this.image_width + "x" + this.image_height + ")");
        }
        this.field_130223_c = s = this.size * scale;
        this.field_130224_d = s;
        int[][] aint = new int[p_147964_1_.length][];
        BufferedImage bufferedimage = p_147964_1_[0];
        aint[0] = new int[s * s];
        bufferedimage.getRGB(this.x * scale, this.y * scale, s, s, aint[0], 0, w);
        this.field_110976_a.clear();
        this.field_110976_a.add(aint);
    }
}

