/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.textures;

import com.google.common.collect.Lists;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.textures.ConnectedTexturesHelper;
import com.rwtema.extrautils2.utils.LogHelper;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.util.ResourceLocation;

public class TextureConnectedTextures
extends TextureAtlasSprite {
    private final int texID;
    private static final String basePath = "textures";

    protected TextureConnectedTextures(String spriteName, int texID) {
        super(spriteName);
        this.texID = texID;
    }

    public static String iconName(String name, int offset) {
        return name + "_" + offset;
    }

    public String func_94215_i() {
        return TextureConnectedTextures.iconName(super.func_94215_i(), this.texID);
    }

    public void func_180598_a(BufferedImage[] p_147964_1_, AnimationMetadataSection p_147964_2_) {
        this.func_110968_a(Lists.newArrayList());
        int width = p_147964_1_[0].getWidth();
        int h = p_147964_1_[0].getHeight();
        this.field_130223_c = width;
        this.field_130224_d = width;
        if (width % 2 != 0) {
            throw new RuntimeException("Wrong width (must be divisible by 2)");
        }
        if (h != width * 5) {
            throw new RuntimeException("Wrong aspect ratio (must be 1x5)");
        }
        int[][] aint = new int[p_147964_1_.length][];
        BufferedImage bufferedimage = p_147964_1_[0];
        aint[0] = new int[width * width];
        int textureIndexMask = ConnectedTexturesHelper.textureIds[this.texID];
        int half_width = width / 2;
        int subImageIndex = textureIndexMask / 125;
        bufferedimage.getRGB(0, subImageIndex * width, half_width, half_width, aint[0], 0, width);
        textureIndexMask -= subImageIndex * 125;
        subImageIndex = textureIndexMask / 25;
        bufferedimage.getRGB(0, subImageIndex * width + half_width, half_width, half_width, aint[0], half_width * width, width);
        textureIndexMask -= subImageIndex * 25;
        subImageIndex = textureIndexMask / 5;
        bufferedimage.getRGB(half_width, subImageIndex * width + half_width, half_width, half_width, aint[0], half_width * (width + 1), width);
        textureIndexMask -= subImageIndex * 5;
        subImageIndex = textureIndexMask;
        bufferedimage.getRGB(half_width, subImageIndex * width, half_width, half_width, aint[0], half_width, width);
        this.field_110976_a.clear();
        this.field_110976_a.add(aint);
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    public boolean load(IResourceManager par1ResourceManager, ResourceLocation location) {
        ResourceLocation resourcelocation = new ResourceLocation("ExtraUtils2:connected/" + super.func_94215_i());
        ResourceLocation resourcelocation1 = Textures.completeTextureResourceLocation(resourcelocation);
        try {
            IResource iresource = par1ResourceManager.func_110536_a(resourcelocation1);
            BufferedImage[] abufferedimage = new BufferedImage[1 + Minecraft.func_71410_x().field_71474_y.field_151442_I];
            abufferedimage[0] = ImageIO.read(iresource.func_110527_b());
            this.func_180598_a(abufferedimage, null);
        }
        catch (IOException ioexception1) {
            LogHelper.logger.error("Using missing texture, unable to load " + resourcelocation1, (Throwable)ioexception1);
            return true;
        }
        return false;
    }
}

