/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.textures;

import com.rwtema.extrautils2.utils.LogHelper;
import com.rwtema.extrautils2.utils.helpers.ColorHelper;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;

public class TextureCompressed
extends TextureAtlasSprite {
    private final String textureBase;
    private final int n;
    private final float max_n;
    private final ResourceLocation textureLocation;

    public TextureCompressed(String textureBase, int n, float max_n) {
        super("extrautils2:compressed/" + textureBase + "_" + n);
        this.textureBase = textureBase;
        this.n = n;
        this.max_n = max_n;
        this.textureLocation = new ResourceLocation("minecraft", "textures/blocks/" + textureBase + ".png");
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        try {
            manager.func_110536_a(location);
            return false;
        }
        catch (IOException e) {
            return true;
        }
    }

    public boolean load(IResourceManager manager, ResourceLocation location) {
        try {
            IResource iresource = manager.func_110536_a(this.textureLocation);
            BufferedImage[] abufferedimage = new BufferedImage[1 + Minecraft.func_71410_x().field_71474_y.field_151442_I];
            AnimationMetadataSection animationmetadatasection = (AnimationMetadataSection)iresource.func_110526_a("animation");
            BufferedImage image = ImageIO.read(iresource.func_110527_b());
            int w = image.getWidth();
            int h = image.getHeight();
            BufferedImage newImage = ImageTypeSpecifier.createFromBufferedImageType(2).createBufferedImage(w, h);
            float border = (2.0f + (float)this.n / this.max_n / 2.0f) / 32.0f;
            for (int px = 0; px < w; ++px) {
                for (int py = 0; py < h; ++py) {
                    float x = (float)px / (float)(w - 1);
                    float y = (float)(py % w) / (float)(w - 1);
                    int col = image.getRGB(px, py);
                    float d = MathHelper.func_76129_c((float)((x - 0.5f) * (x - 0.5f) + (y - 0.5f) * (y - 0.5f)));
                    float br = 1.0f - (float)this.n / this.max_n + (0.5f - d) / 2.0f;
                    if (br > 1.0f) {
                        br = 1.0f;
                    }
                    if (x <= border || y < border || 1.0f - x <= border || 1.0f - y <= border) {
                        br *= 0.5f;
                    }
                    int a = ColorHelper.getA(col);
                    int r = MathHelper.func_76125_a((int)Math.round((float)ColorHelper.getR(col) * br), (int)0, (int)255);
                    int g = MathHelper.func_76125_a((int)Math.round((float)ColorHelper.getG(col) * br), (int)0, (int)255);
                    int b = MathHelper.func_76125_a((int)Math.round((float)ColorHelper.getB(col) * br), (int)0, (int)255);
                    newImage.setRGB(px, py, ColorHelper.color(r, g, b, a));
                }
            }
            abufferedimage[0] = newImage;
            this.func_180598_a(abufferedimage, animationmetadatasection);
        }
        catch (IOException ioexception1) {
            LogHelper.logger.error("Using missing texture, unable to load " + this.textureLocation, (Throwable)ioexception1);
            return true;
        }
        return false;
    }
}

