/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.render;

import com.rwtema.extrautils2.render.LayerSword;
import com.rwtema.extrautils2.render.LayerWings;
import com.rwtema.extrautils2.utils.datastructures.WeakLinkedSet;
import com.rwtema.extrautils2.utils.datastructures.WeakSet;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class LayersHandler {
    public static WeakSet<RendererLivingEntity<?>> initRenderers = new WeakSet();
    public static WeakLinkedSet<RendererLivingEntity<?>> toInit = new WeakLinkedSet();

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new LayersHandler());
    }

    @SubscribeEvent
    public void renderStart(RenderLivingEvent.Pre event) {
        if (!initRenderers.contains(event.renderer)) {
            initRenderers.add(event.renderer);
            toInit.add(event.renderer);
        }
    }

    @SubscribeEvent
    public void layers(TickEvent.RenderTickEvent event) {
        if (toInit.isEmpty()) {
            return;
        }
        for (RendererLivingEntity<?> rendererLivingEntity : toInit) {
            this.addLayers(rendererLivingEntity);
        }
        toInit.clear();
    }

    private void addLayers(RendererLivingEntity<?> renderer) {
        if (renderer instanceof RenderPlayer) {
            RenderPlayer renderPlayer = (RenderPlayer)renderer;
            renderer.func_177094_a((LayerRenderer)new LayerWings(renderPlayer));
            renderer.func_177094_a((LayerRenderer)new LayerSword(renderPlayer));
        }
    }
}

