/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.power.player;

import com.rwtema.extrautils2.power.Freq;
import com.rwtema.extrautils2.power.IPower;
import com.rwtema.extrautils2.power.IWorldPowerMultiplier;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public abstract class PlayerPower
implements IPower,
IWorldPowerMultiplier {
    public final int freq;
    @Nonnull
    private final EntityPlayer player;
    public int cooldown = 20;
    public final int dimension;
    public boolean invalid;

    public PlayerPower(@Nonnull EntityPlayer player) {
        this.player = player;
        this.freq = player instanceof EntityPlayerMP ? Freq.getBasePlayerFreq((EntityPlayerMP)player) : 0;
        this.dimension = player.field_70170_p.field_73011_w.func_177502_q();
    }

    @Override
    public IWorldPowerMultiplier getMultiplier() {
        return this;
    }

    @Override
    public int frequency() {
        return this.freq;
    }

    @Override
    public World world() {
        return null;
    }

    @Override
    public float multiplier(World world) {
        EntityPlayerMP playerMP = this.getPlayerMP();
        if (this.invalid || !MinecraftServer.func_71276_C().func_71203_ab().field_72404_b.contains(playerMP)) {
            return 0.0f;
        }
        return this.power((EntityPlayer)playerMP);
    }

    @Nonnull
    public EntityPlayer getPlayer() {
        return this.player;
    }

    @Nonnull
    public EntityPlayerMP getPlayerMP() {
        return (EntityPlayerMP)this.player;
    }

    public abstract float power(EntityPlayer var1);

    @Override
    public final float getPower() {
        return 1.0f;
    }

    public void onAdd() {
    }

    public void onRemove() {
    }

    public void update(boolean selected, ItemStack params) {
    }

    public void tick() {
    }

    public void onAddClient() {
    }

    public void onRemoveClient() {
    }

    public void tickClient() {
    }

    public void updateClient(boolean selected, ItemStack params) {
    }
}

