/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.network;

import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.network.PacketCodec;
import com.rwtema.extrautils2.network.XUPacketBase;
import com.rwtema.extrautils2.network.XUPacketServerToClient;
import com.rwtema.extrautils2.utils.LogHelper;
import com.rwtema.extrautils2.utils.helpers.PlayerHelper;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkHandler {
    public static EnumMap<Side, FMLEmbeddedChannel> channels;

    public static void init(ASMDataTable asmData) {
        for (ASMDataTable.ASMData aSMData : asmData.getAll(XUPacket.class.getName())) {
            NetworkHandler.registerPacket(aSMData.getClassName());
        }
        channels = NetworkRegistry.INSTANCE.newChannel("XU2", new ChannelHandler[]{new PacketCodec(), ExtraUtils2.proxy.getNewPacketHandler()});
        LogHelper.oneTimeInfo("Network Init");
        LogHelper.oneTimeInfo("Start " + channels);
        for (Map.Entry entry : channels.entrySet()) {
            FMLEmbeddedChannel value = (FMLEmbeddedChannel)entry.getValue();
            if (value == null) continue;
            Side side = (Side)entry.getKey();
            LogHelper.oneTimeInfo("Start Side:  " + side + " ");
            Map.Entry[] array = (Map.Entry[])Iterables.toArray((Iterable)value.pipeline(), Map.Entry.class);
            int arrayLength = array.length;
            for (int i = 0; i < arrayLength; ++i) {
                Map.Entry handlerEntry = array[i];
                LogHelper.oneTimeInfo("Start Channel Handler: (" + side + ")(" + i + ") " + handlerEntry.getKey() + " - " + handlerEntry.getValue());
            }
        }
    }

    public static void checkPacket(XUPacketBase packet, Side properSenderSide) {
        LogHelper.oneTimeInfo("Check Packet " + properSenderSide);
        if (!packet.isValidSenderSide(properSenderSide)) {
            throw new RuntimeException("Sending packet class" + packet.getClass().getSimpleName() + " from wrong side");
        }
    }

    public static void sendToAllPlayers(XUPacketBase packet) {
        NetworkHandler.checkPacket(packet, Side.SERVER);
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        channels.get(Side.SERVER).writeOutbound(new Object[]{packet});
    }

    public static void sendPacketToPlayer(XUPacketBase packet, EntityPlayer player) {
        NetworkHandler.checkPacket(packet, Side.SERVER);
        if (!PlayerHelper.isPlayerReal(player)) {
            return;
        }
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        channels.get(Side.SERVER).writeOutbound(new Object[]{packet});
    }

    public static void sendToAllAround(XUPacketBase packet, int dimension, double x, double y, double z, double range) {
        NetworkHandler.sendToAllAround(packet, new NetworkRegistry.TargetPoint(dimension, x, y, z, range));
    }

    public static void sendToAllAround(XUPacketBase packet, NetworkRegistry.TargetPoint point) {
        NetworkHandler.checkPacket(packet, Side.SERVER);
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        channels.get(Side.SERVER).writeAndFlush((Object)packet).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public static void sendPacketToServer(XUPacketBase packet) {
        NetworkHandler.checkPacket(packet, Side.CLIENT);
        channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        channels.get(Side.CLIENT).writeOutbound(new Object[]{packet});
    }

    public static void sendToAllAround(XUPacketBase packet, int chunkX, int chunkZ) {
        ChunkCoordIntPair chunkCoordIntPair = new ChunkCoordIntPair(chunkX, chunkZ);
        for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().field_72404_b) {
            if (!player.field_71129_f.contains(chunkCoordIntPair)) continue;
            NetworkHandler.sendPacketToPlayer(packet, (EntityPlayer)player);
        }
    }

    private static void registerPacket(String s) {
        try {
            Class<?> clazz = Class.forName(s);
            if (XUPacketBase.class.isAssignableFrom(clazz)) {
                LogHelper.oneTimeInfo("Register Packet");
                try {
                    clazz.newInstance();
                }
                catch (Throwable throwable) {
                    throw Throwables.propagate((Throwable)throwable);
                }
            } else {
                throw new RuntimeException("Invalid Class for packet: " + s);
            }
            PacketCodec.addClass(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Presented class (" + s + ") missing, FML Bug?", e);
        }
        catch (NoClassDefFoundError e) {
            throw new RuntimeException(s + " can't be created", e);
        }
    }

    public static void sendCrash(Throwable throwable, EntityPlayer callback) {
        LogHelper.oneTimeInfo("Sending Crash");
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            String s = sw.toString();
            NetworkHandler.sendPacketToPlayer(new PacketCrashLog(s), callback);
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    static {
        LogHelper.oneTimeInfo("Network Handler Static Init");
    }

    @XUPacket
    public static class PacketCrashLog
    extends XUPacketServerToClient {
        static Logger logger = LogManager.getLogger((String)"ExtraUtils2_Crash");
        String string;

        public PacketCrashLog() {
        }

        public PacketCrashLog(String string) {
            this.string = string;
        }

        @Override
        public void writeData() throws Exception {
            this.writeString(this.string);
        }

        @Override
        public void readData(EntityPlayer player) {
            this.string = this.readString();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public Runnable doStuffClient() {
            logger.info("Server Packet Crash");
            logger.info(this.string);
            return null;
        }
    }

    public static @interface XUPacket {
    }
}

