/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.rwtema.extrautils2.backend.XUItemFlat;
import com.rwtema.extrautils2.backend.model.Textures;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWateringCan
extends XUItemFlat
implements IFluidContainerItem {
    public ItemWateringCan() {
        this.func_77656_e(1000);
        this.func_77625_d(1);
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        return super.func_180614_a(stack, playerIn, worldIn, pos, side, hitX, hitY, hitZ);
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        subItems.add(new ItemStack(itemIn, 1, 0));
        subItems.add(new ItemStack(itemIn, 1, this.func_77612_l()));
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        BlockPos pos;
        MovingObjectPosition movingobjectposition = this.func_77621_a(worldIn, playerIn, true);
        if (movingobjectposition != null && movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && worldIn.func_180495_p(pos = movingobjectposition.func_178782_a()).func_177230_c().func_149688_o() == Material.field_151586_h) {
            playerIn.func_71008_a(itemStackIn, this.func_77626_a(itemStackIn));
            return itemStackIn;
        }
        if (itemStackIn.func_77952_i() == this.getMaxDamage(itemStackIn) && !playerIn.field_71075_bZ.field_75098_d) {
            return itemStackIn;
        }
        playerIn.func_71008_a(itemStackIn, this.func_77626_a(itemStackIn));
        return itemStackIn;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack == null || newStack == null || oldStack.func_77973_b() != this || newStack.func_77973_b() != this;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        BlockPos pos;
        int i = stack.func_77952_i();
        World worldObj = player.field_70170_p;
        MovingObjectPosition movingobjectposition = this.func_77621_a(worldObj, player, true);
        if (movingobjectposition == null) {
            return;
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && worldObj.func_180495_p(pos = movingobjectposition.func_178782_a()).func_177230_c().func_149688_o() == Material.field_151586_h) {
            if (!worldObj.field_72995_K && !player.field_71075_bZ.field_75098_d) {
                if ((i -= 5) < 0) {
                    i = 0;
                }
                stack.func_77964_b(i - 1);
            }
            return;
        }
        if (i == stack.func_77958_k()) {
            player.func_71034_by();
            return;
        }
        this.waterLocation(worldObj, movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c, movingobjectposition.field_178784_b, stack, player, 1);
        if (!player.field_71075_bZ.field_75098_d && i < stack.func_77958_k()) {
            stack.func_77964_b(i + 1);
        }
    }

    private void waterLocation(World worldObj, double hitX, double hitY, double hitZ, EnumFacing side, ItemStack stack, EntityPlayer play, int range) {
        List enderman = worldObj.func_72872_a(EntityEnderman.class, new AxisAlignedBB(hitX - (double)range, hitY - (double)range, hitZ - (double)range, hitX + (double)range, hitY + 6.0, hitZ + (double)range));
        if (enderman != null) {
            for (Object anEnderman : enderman) {
                ((EntityEnderman)anEnderman).func_70097_a(DamageSource.field_76369_e, 1.0f);
            }
        }
        boolean cheat = false;
        if (worldObj.field_72995_K) {
            double dx = side.func_82601_c();
            double dy = side.func_96559_d();
            double dz = side.func_82599_e();
            double x2 = hitX + dx * 0.1;
            double y2 = hitY + dy * 0.1;
            double z2 = hitZ + dz * 0.1;
            for (int i = 0; i < 4 * range; ++i) {
                worldObj.func_175688_a(EnumParticleTypes.WATER_SPLASH, x2 + worldObj.field_73012_v.nextGaussian() * 0.6 * (double)range, y2, z2 + worldObj.field_73012_v.nextGaussian() * 0.6 * (double)range, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            List ents = worldObj.func_72872_a(Entity.class, new AxisAlignedBB(hitX - (double)range, hitY - (double)range, hitZ - (double)range, hitX + (double)range, hitY + (double)range + 6.0, hitZ + (double)range));
            if (ents != null) {
                for (Object ent : ents) {
                    if (!((Entity)ent).func_70027_ad()) continue;
                    float p = 0.01f;
                    if (ent instanceof EntityPlayer) {
                        p = 0.333f;
                    }
                    ((Entity)ent).func_70066_B();
                    if (!(worldObj.field_73012_v.nextDouble() < (double)p)) continue;
                    if (stack.func_77952_i() < 3) {
                        stack.func_77964_b(1);
                    }
                    if (play != null) {
                        play.func_71034_by();
                    }
                    return;
                }
            }
            int blockX = (int)Math.floor(hitX);
            int blockY = (int)Math.floor(hitY);
            int blockZ = (int)Math.floor(hitZ);
            for (int x = blockX - range; x <= blockX + range; ++x) {
                for (int y = blockY - range; y <= blockY + range; ++y) {
                    for (int z = blockZ - range; z <= blockZ + range; ++z) {
                        BlockPos pos = new BlockPos(x, y, z);
                        Block id = worldObj.func_180495_p(pos).func_177230_c();
                        if (worldObj.func_175623_d(pos)) continue;
                        if (id == Blocks.field_150480_ab) {
                            worldObj.func_175698_g(pos);
                        }
                        if (id == Blocks.field_150458_ak) {
                            worldObj.func_180501_a(pos, id.func_176223_P().func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(7)), 2);
                        }
                        int timer = -1;
                        if (id == Blocks.field_150349_c) {
                            timer = 20;
                            if (!cheat && worldObj.field_73012_v.nextInt(4500) == 0 && worldObj.func_175623_d(pos.func_177984_a())) {
                                // empty if block
                            }
                        } else if (id == Blocks.field_150391_bh) {
                            timer = 20;
                        } else if (id == Blocks.field_150464_aj) {
                            timer = 40;
                        } else if (id instanceof BlockSapling) {
                            timer = 50;
                        } else if (id instanceof IPlantable || id instanceof IGrowable) {
                            timer = 40;
                        } else if (id.func_149688_o() == Material.field_151577_b) {
                            timer = 20;
                        }
                        if (stack.func_77952_i() == 2) {
                            timer *= 20;
                        }
                        if ((timer /= range) <= 0 || !id.func_149653_t()) continue;
                        worldObj.func_175684_a(pos, id, worldObj.field_73012_v.nextInt(timer));
                    }
                }
            }
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        Textures.register("watering_can");
    }

    @Override
    public int getMaxMetadata() {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getTexture(@Nullable ItemStack itemStack, int renderPass) {
        return "watering_can";
    }

    public FluidStack getFluid(ItemStack container) {
        int amount = this.getMaxDamage(container) - container.func_77952_i();
        return new FluidStack(FluidRegistry.WATER, amount);
    }

    public int getCapacity(ItemStack container) {
        return this.getMaxDamage(container);
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluid() != FluidRegistry.WATER || resource.amount <= 0) {
            return 0;
        }
        if (container.func_77952_i() <= resource.amount) {
            if (doFill) {
                container.func_77964_b(container.func_77952_i() - resource.amount);
            }
            return resource.amount;
        }
        int m = container.func_77952_i();
        if (doFill) {
            container.func_77964_b(0);
        }
        return m;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        return null;
    }
}

