/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.IXUItem;
import com.rwtema.extrautils2.backend.model.PassthruModelItem;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.datastructures.ThreadLocalBoolean;
import com.rwtema.extrautils2.utils.helpers.CollectionHelper;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSickle
extends ItemTool
implements IXUItem {
    public static final String[] TYPE_NAMES = new String[]{"sickle_wood", "sickle_stone", "sickle_iron", "sickle_gold", "sickle_diamond"};
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.field_150329_H, Blocks.field_150362_t, Blocks.field_150361_u});
    public static Item.ToolMaterial[] VANILLA_MATERIALS = new Item.ToolMaterial[]{Item.ToolMaterial.WOOD, Item.ToolMaterial.STONE, Item.ToolMaterial.IRON, Item.ToolMaterial.GOLD, Item.ToolMaterial.EMERALD};
    static ThreadLocal<Boolean> calling = new ThreadLocalBoolean(false);
    private final String name;
    public HashMap<Item.ToolMaterial, Integer> toolRanges = CollectionHelper.populateMap(new HashMap(), Item.ToolMaterial.WOOD, 1, Item.ToolMaterial.STONE, 2, Item.ToolMaterial.IRON, 3, Item.ToolMaterial.GOLD, 1, Item.ToolMaterial.EMERALD, 4);
    @SideOnly(value=Side.CLIENT)
    TextureAtlasSprite sprite;

    public ItemSickle(int i) {
        super(3.0f, VANILLA_MATERIALS[i], EFFECTIVE_ON);
        this.name = TYPE_NAMES[i];
        this.func_77655_b("ExtraUtils2:" + StringHelper.capFirst(this.name, false));
        this.func_77637_a(ExtraUtils2.creativeTabExtraUtils);
        this.func_77656_e(this.field_77862_b.func_77997_a() * 9);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        Textures.register("tools/" + this.name);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBakedModel createModel(int metadata) {
        return new PassthruModelItem(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getBaseTexture() {
        return this.sprite;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addQuads(PassthruModelItem.ModelLayer model, ItemStack stack) {
        model.addSprite(this.sprite);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void postTextureRegister() {
        this.sprite = Textures.sprites.get("tools/" + this.name);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderAsTool() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clearCaches() {
        this.sprite = null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean allowOverride() {
        return true;
    }

    public String func_77653_i(ItemStack stack) {
        return Lang.translate(this.func_77657_g(stack) + ".name", StringHelper.sepWords(((ResourceLocation)Item.field_150901_e.func_177774_c((Object)this)).func_110623_a().replace("Item", "")));
    }

    public boolean func_150897_b(Block blockIn) {
        return blockIn instanceof IPlantable || blockIn instanceof IShearable;
    }

    public float func_150893_a(ItemStack stack, Block block) {
        return block instanceof IPlantable ? this.field_77864_a : super.func_150893_a(stack, block);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        if (calling.get().booleanValue()) {
            return false;
        }
        World worldObj = player.field_70170_p;
        Block block = worldObj.func_180495_p(pos).func_177230_c();
        if (worldObj.field_72995_K || !this.func_150897_b(block)) {
            return false;
        }
        Item.ToolMaterial toolMaterial = ((ItemSickle)itemstack.func_77973_b()).func_150913_i();
        if (!this.toolRanges.containsKey(toolMaterial)) {
            return false;
        }
        int range = this.toolRanges.get(toolMaterial);
        try {
            calling.set(true);
            for (BlockPos.MutableBlockPos blockPos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-range, -range, -range), (BlockPos)pos.func_177982_a(range, range, range))) {
                IBlockState blockState = worldObj.func_180495_p((BlockPos)blockPos);
                if (block != blockState.func_177230_c()) continue;
                ExtraUtils2.proxy.onBlockStartBreak(worldObj, itemstack, (BlockPos)blockPos, player, true);
            }
            calling.set(false);
        }
        catch (Throwable throwable) {
            calling.set(false);
            throw Throwables.propagate((Throwable)throwable);
        }
        return true;
    }

    @Override
    public int getMaxMetadata() {
        return 0;
    }
}

