/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.rwtema.extrautils2.backend.XUItemFlat;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.crafting.ICustomMatching;
import com.rwtema.extrautils2.items.VillagerProfessions;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.MCTimer;
import com.rwtema.extrautils2.utils.helpers.NBTHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFence;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemGoldenLasso
extends XUItemFlat
implements ICustomMatching {
    public static final String NBT_ANIMAL = "Animal";
    public static final String NBT_ANIMAL_DISPLAY = "Animal_Metadata";
    public static final String NBT_GOLDEN_LASSO_PREVENT = "[GoldenLassoPrevent]";
    public static final List<ItemStack> genericNiceRecipeItemList = new ArrayList<ItemStack>();
    public static final List<ItemStack> genericEvilRecipeItemList = new ArrayList<ItemStack>();
    public static final String NBT_ANIMAL_ALREADYPICKEDUP = "CursedLassoPickedUp";
    public static final String NBT_ANIMAL_NOPLACE = "No_Place";
    public static final String NBT_ANIMAL_NOPLACE_OLD = "NoPlace";

    public ItemGoldenLasso() {
        this.func_77627_a(true);
        this.func_77625_d(1);
        MinecraftForge.EVENT_BUS.register((Object)this);
        genericNiceRecipeItemList.add(new ItemStack((Item)this, 1, 0));
        genericEvilRecipeItemList.add(new ItemStack((Item)this, 1, 1));
    }

    public static ItemStack newCraftingVillagerStack(boolean needsContract, VillagerProfessions profession) {
        ItemStack itemStack = ItemGoldenLasso.newCraftingStack(EntityVillager.class);
        NBTTagCompound tags = NBTHelper.getOrInitTagCompound(itemStack.func_77978_p(), NBT_ANIMAL);
        if (needsContract) {
            NBTHelper.getOrInitTagCompound(tags, "ForgeData").func_74757_a("Contracted", true);
        }
        if (profession != null) {
            tags.func_74768_a("Profession", profession.profession);
            tags.func_74768_a("Career", profession.career);
        }
        return itemStack;
    }

    public static ItemStack newCraftingStack(Class entity) {
        int meta = IMob.class.isAssignableFrom(entity) ? 1 : 0;
        ItemStack itemStack = XU2Entries.goldenLasso.newStack(1, meta);
        NBTTagCompound animalTag = NBTHelper.getOrInitTagCompound(NBTHelper.getOrInitTagCompound(itemStack), NBT_ANIMAL);
        animalTag.func_74778_a("id", (String)EntityList.field_75626_c.get(entity));
        ItemGoldenLasso.setNoPlace(itemStack);
        return itemStack;
    }

    public static void setNoPlace(ItemStack cursedLasso) {
        cursedLasso.func_77978_p().func_74757_a(NBT_ANIMAL_NOPLACE, true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderAsTool() {
        return true;
    }

    @Override
    public int getMaxMetadata() {
        return 2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        genericNiceRecipeItemList.clear();
        genericEvilRecipeItemList.clear();
        genericNiceRecipeItemList.add(new ItemStack((Item)this, 1, 0));
        genericEvilRecipeItemList.add(new ItemStack((Item)this, 1, 1));
        for (Class aClass : EntityList.field_75626_c.keySet()) {
            ItemStack itemStack;
            if (!EntityLiving.class.isAssignableFrom(aClass)) continue;
            if (IMob.class.isAssignableFrom(aClass)) {
                itemStack = ItemGoldenLasso.newCraftingStack(aClass);
                genericEvilRecipeItemList.add(itemStack);
                continue;
            }
            if (!EntityCreature.class.isAssignableFrom(aClass) && !EntityAmbientCreature.class.isAssignableFrom(aClass) && !EntityWaterMob.class.isAssignableFrom(aClass)) continue;
            itemStack = ItemGoldenLasso.newCraftingStack(aClass);
            genericNiceRecipeItemList.add(itemStack);
        }
        Textures.register("dark_lasso", "golden_lasso", "lasso_internal_1", "lasso_internal_2");
    }

    public boolean hasContainerItem(ItemStack stack) {
        return this.hasAnimal(stack);
    }

    public ItemStack getContainerItem(ItemStack stack) {
        ItemStack copy = stack.func_77946_l();
        NBTTagCompound tagCompound = copy.func_77978_p();
        tagCompound.func_82580_o(NBT_ANIMAL);
        tagCompound.func_82580_o("display");
        return copy;
    }

    @Override
    public String getTexture(@Nullable ItemStack itemStack, int renderPass) {
        switch (renderPass) {
            case 1: {
                return "lasso_internal_1";
            }
            case 2: {
                return "lasso_internal_2";
            }
        }
        if (itemStack != null && itemStack.func_77952_i() == 1) {
            return "dark_lasso";
        }
        return "golden_lasso";
    }

    @Override
    public int getRenderLayers(@Nullable ItemStack itemStack) {
        return this.hasAnimal(itemStack) ? 3 : 1;
    }

    @Override
    public boolean renderLayerIn3D(ItemStack stack, int renderPass) {
        return renderPass == 0;
    }

    @Override
    public int getTint(ItemStack stack, int i) {
        switch (i) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        return -1;
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int renderPass) {
        NBTTagCompound tags = stack.func_77978_p();
        if (!this.hasAnimal(tags)) {
            return 0xFFFFFF;
        }
        EntityList.EntityEggInfo egg = this.getEgg(tags.func_74775_l(NBT_ANIMAL));
        if (egg == null) {
            return 0xFFFFFF;
        }
        if (renderPass == 0) {
            return egg.field_75611_b;
        }
        return egg.field_75612_c;
    }

    public boolean hasAnimal(ItemStack itemStack) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        return this.hasAnimal(tagCompound);
    }

    private boolean hasAnimal(NBTTagCompound tagCompound) {
        return tagCompound != null && tagCompound.func_150297_b(NBT_ANIMAL, 10);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target) {
        if (this.hasAnimal(stack)) {
            return false;
        }
        if (target.field_70170_p.field_72995_K) {
            return true;
        }
        if (stack.func_77952_i() == 1) {
            if (!(target instanceof IMob)) {
                playerIn.func_146105_b((IChatComponent)Lang.chat("%s is not a hostile mob.", target.func_145748_c_()));
                return false;
            }
            if (!playerIn.field_71075_bZ.field_75098_d) {
                float maxHealth;
                float threshold;
                if (target instanceof IBossDisplayData) {
                    playerIn.func_146105_b((IChatComponent)Lang.chat("%s is too powerful.", target.func_145748_c_()));
                    return false;
                }
                NBTTagCompound data = target.getEntityData();
                if (data.func_74767_n(NBT_ANIMAL_ALREADYPICKEDUP)) {
                    return true;
                }
                float health = target.func_110143_aJ();
                if (health > (threshold = MathHelper.func_76131_a((float)((maxHealth = target.func_110138_aP()) / 4.0f), (float)4.0f, (float)10.0f))) {
                    playerIn.func_146105_b((IChatComponent)Lang.chat("%s has too much health (%s hearts). Reduce to %s hearts.", target.func_145748_c_(), (int)Math.floor(health / 2.0f), (int)Math.floor(threshold / 2.0f)));
                    return false;
                }
            }
        } else {
            if (target instanceof IMob) {
                playerIn.func_146105_b((IChatComponent)Lang.chat("%s is a hostile mob.", target.func_145748_c_()));
                return false;
            }
            if (!(target instanceof EntityCreature || target instanceof EntityAmbientCreature || target instanceof EntityWaterMob)) {
                return false;
            }
            if (((EntityLiving)target).func_70638_az() != null) {
                playerIn.func_146105_b((IChatComponent)Lang.chat("%s is too busy attacking someone.", target.func_145748_c_()));
                return false;
            }
        }
        return this.addTargetToLasso(stack, target);
    }

    public boolean addTargetToLasso(ItemStack stack, EntityLivingBase target) {
        if (target instanceof IMerchant) {
            target.func_145748_c_();
        }
        float health = target.func_110143_aJ();
        float maxHealth = target.func_110138_aP();
        NBTTagCompound entityTags = new NBTTagCompound();
        entityTags.func_74757_a(NBT_GOLDEN_LASSO_PREVENT, false);
        if (!target.func_98035_c(entityTags)) {
            return false;
        }
        if (!entityTags.func_74764_b(NBT_GOLDEN_LASSO_PREVENT) || entityTags.func_74767_n(NBT_GOLDEN_LASSO_PREVENT)) {
            return false;
        }
        entityTags.func_82580_o(NBT_GOLDEN_LASSO_PREVENT);
        String name = "";
        if (target.func_145818_k_()) {
            name = target.func_95999_t();
        }
        target.func_70106_y();
        NBTTagCompound nbt = NBTHelper.getOrInitTagCompound(stack);
        nbt.func_74757_a(NBT_ANIMAL_NOPLACE, false);
        nbt.func_74782_a(NBT_ANIMAL, (NBTBase)entityTags);
        NBTTagCompound display = NBTHelper.getOrInitTagCompound(nbt, NBT_ANIMAL_DISPLAY);
        display.func_74776_a("Health", health);
        display.func_74776_a("MaxHealth", maxHealth);
        if (!name.equals("")) {
            stack.func_151001_c(name);
        }
        return true;
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.hasAnimal(stack)) {
            return false;
        }
        NBTTagCompound stackTags = stack.func_77978_p();
        NBTTagCompound entityTags = stackTags.func_74775_l(NBT_ANIMAL);
        if (entityTags.func_82582_d() || !entityTags.func_150297_b("id", 8)) {
            stackTags.func_82580_o(NBT_ANIMAL);
            return false;
        }
        if (worldIn.field_72995_K) {
            return true;
        }
        if (!playerIn.func_175151_a(pos.func_177972_a(side), side, stack)) {
            return false;
        }
        if (stack.func_77952_i() == 1 && worldIn.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            playerIn.func_146105_b((IChatComponent)Lang.chat("Difficulty set to peaceful.", new Object[0]));
            return false;
        }
        if (stackTags.func_74767_n(NBT_ANIMAL_NOPLACE)) {
            if (playerIn.func_70093_af()) {
                stackTags.func_82580_o(NBT_ANIMAL);
                stackTags.func_82580_o(NBT_ANIMAL_DISPLAY);
                stackTags.func_82580_o(NBT_ANIMAL_NOPLACE);
                playerIn.func_146105_b((IChatComponent)Lang.chat("Mob soul released.", new Object[0]));
                stack.func_135074_t();
                return true;
            }
            float health = stackTags.func_74775_l(NBT_ANIMAL_DISPLAY).func_74760_g("Health");
            playerIn.func_146105_b((IChatComponent)Lang.chat("Unable to place mob.", new Object[0]));
            if ((double)health <= 1.0E-10) {
                playerIn.func_146105_b((IChatComponent)Lang.chat("Mob's body is dead.", new Object[0]));
            }
            playerIn.func_146105_b((IChatComponent)Lang.chat("Sneak-right-click to release soul.", new Object[0]));
            return true;
        }
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        pos = pos.func_177972_a(side);
        double d0 = 0.0;
        if (side == EnumFacing.UP && iblockstate.func_177230_c() instanceof BlockFence) {
            d0 = 0.5;
        }
        entityTags.func_74782_a("Pos", (NBTBase)this.newDoubleNBTList((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + d0, (double)pos.func_177952_p() + 0.5));
        entityTags.func_74782_a("Motion", (NBTBase)this.newDoubleNBTList(0.0, 0.0, 0.0));
        entityTags.func_74776_a("FallDistance", 0.0f);
        entityTags.func_74768_a("Dimension", worldIn.field_73011_w.func_177502_q());
        Entity entity = EntityList.func_75615_a((NBTTagCompound)entityTags, (World)worldIn);
        if (entity != null) {
            if (entity instanceof EntityLiving && stack.func_82837_s()) {
                entity.func_96094_a(stack.func_82833_r());
            }
            if (entity instanceof IMob) {
                entity.getEntityData().func_74757_a(NBT_ANIMAL_ALREADYPICKEDUP, true);
            }
            worldIn.func_72838_d(entity);
        }
        stackTags.func_82580_o(NBT_ANIMAL);
        stackTags.func_82580_o(NBT_ANIMAL_DISPLAY);
        stackTags.func_82580_o(NBT_ANIMAL_NOPLACE);
        stack.func_135074_t();
        if (playerIn.field_71075_bZ.field_75098_d) {
            playerIn.func_70062_b(0, stack.func_77946_l());
        }
        playerIn.field_71071_by.func_70296_d();
        return true;
    }

    private NBTTagList newDoubleNBTList(double ... numbers) {
        NBTTagList nbttaglist = new NBTTagList();
        for (double d0 : numbers) {
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(d0));
        }
        return nbttaglist;
    }

    @SideOnly(value=Side.CLIENT)
    public EntityList.EntityEggInfo getEgg(NBTTagCompound entityTag) {
        String id = entityTag.func_74779_i("id");
        Map eggs = EntityRegistry.getEggs();
        if (eggs.containsKey(id)) {
            return (EntityList.EntityEggInfo)eggs.get(id);
        }
        int i = EntityList.func_180122_a((String)id);
        if (EntityList.field_75627_a.containsKey(i)) {
            return (EntityList.EntityEggInfo)EntityList.field_75627_a.get(i);
        }
        return null;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        NBTTagCompound entityTags;
        NBTTagCompound itemTags = stack.func_77978_p();
        if (this.hasAnimal(itemTags) && (entityTags = itemTags.func_74775_l(NBT_ANIMAL)).func_74764_b("id")) {
            if (!tooltip.isEmpty()) {
                tooltip.set(0, tooltip.get(0).replaceFirst(EnumChatFormatting.ITALIC + stack.func_82833_r() + EnumChatFormatting.RESET, this.func_77653_i(stack)));
            }
            String id = entityTags.func_74779_i("id");
            String animal_name = StatCollector.func_74838_a((String)("entity." + id + ".name"));
            tooltip.add(animal_name);
            if ("Villager".equals(id)) {
                if (entityTags.func_74764_b("Profession")) {
                    int career = entityTags.func_74762_e("Career");
                    int profession = entityTags.func_74762_e("Profession");
                    int t = MCTimer.clientTimer >> 4;
                    String s1 = null;
                    switch (profession) {
                        case 0: {
                            if (career == 0) {
                                career = t % 4 + 1;
                            }
                            if (career == 1) {
                                s1 = "farmer";
                                break;
                            }
                            if (career == 2) {
                                s1 = "fisherman";
                                break;
                            }
                            if (career == 3) {
                                s1 = "shepherd";
                                break;
                            }
                            if (career != 4) break;
                            s1 = "fletcher";
                            break;
                        }
                        case 1: {
                            s1 = "librarian";
                            break;
                        }
                        case 2: {
                            s1 = "cleric";
                            break;
                        }
                        case 3: {
                            if (career == 0) {
                                career = t % 3 + 1;
                            }
                            if (career == 1) {
                                s1 = "armor";
                                break;
                            }
                            if (career == 2) {
                                s1 = "weapon";
                                break;
                            }
                            if (career != 3) break;
                            s1 = "tool";
                            break;
                        }
                        case 4: {
                            if (career == 0) {
                                career = t % 2 + 1;
                            }
                            if (career == 1) {
                                s1 = "butcher";
                                break;
                            }
                            if (career != 2) break;
                            s1 = "leather";
                        }
                    }
                    if (s1 != null) {
                        tooltip.add(StatCollector.func_74838_a((String)("entity.Villager." + s1)));
                    }
                }
                if (entityTags.func_74775_l("ForgeData").func_74767_n("Contracted")) {
                    tooltip.add(Lang.translate("*Under Contract*"));
                }
            }
            float health = itemTags.func_74775_l(NBT_ANIMAL_DISPLAY).func_74760_g("Health");
            float maxHealth = itemTags.func_74775_l(NBT_ANIMAL_DISPLAY).func_74760_g("MaxHealth");
            tooltip.add(Lang.translateArgs("Health: %s/%s", Float.valueOf(health), Float.valueOf(maxHealth)));
            if (stack.func_82837_s()) {
                tooltip.add(stack.func_82833_r());
            }
        }
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        subItems.add(new ItemStack(itemIn, 1, 0));
        subItems.add(new ItemStack(itemIn, 1, 1));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void cursedLassoAbsorb(LivingDeathEvent event) {
        if (!(event.entityLiving instanceof IMob) || event.entityLiving instanceof IBossDisplayData) {
            return;
        }
        Entity source = event.source.func_76346_g();
        if (!(source instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)source;
        ItemStack cursedLasso = this.check(player.func_70694_bm());
        if (cursedLasso == null) {
            for (int i = 0; cursedLasso == null && i < player.field_71071_by.func_70302_i_(); ++i) {
                cursedLasso = this.check(player.field_71071_by.func_70301_a(i));
            }
        }
        if (cursedLasso == null) {
            return;
        }
        if (!this.addTargetToLasso(cursedLasso, event.entityLiving)) {
            return;
        }
        ItemGoldenLasso.setNoPlace(cursedLasso);
        player.func_146105_b((IChatComponent)Lang.chat("%s absorbed into cursed lasso", event.entityLiving.func_145748_c_()));
    }

    public ItemStack check(ItemStack stack) {
        return stack == null || stack.func_77973_b() != this || stack.func_77952_i() != 1 || this.hasAnimal(stack) ? null : stack;
    }

    @SubscribeEvent
    public void goldenLassoActivate(EntityInteractEvent event) {
        ItemStack itemstack = event.entityPlayer.func_71045_bC();
        if (itemstack != null && itemstack.func_77973_b() == this) {
            Entity entity = event.target;
            if (entity instanceof EntityDragonPart) {
                entity = (Entity)((EntityDragonPart)entity).field_70259_a;
            }
            if (entity instanceof EntityLivingBase) {
                itemstack.func_111282_a(event.entityPlayer, (EntityLivingBase)entity);
                if (itemstack.field_77994_a <= 0) {
                    event.entityPlayer.func_71028_bD();
                }
                event.setCanceled(true);
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + stack.func_77952_i();
    }

    @Override
    public boolean itemsMatch(ItemStack slot, @Nonnull ItemStack target) {
        NBTTagCompound slotTags;
        String slotID;
        boolean sAnim;
        if (!OreDictionary.itemMatches((ItemStack)target, (ItemStack)slot, (boolean)false)) {
            return false;
        }
        boolean tAnim = this.hasAnimal(target);
        if (tAnim != (sAnim = this.hasAnimal(slot))) {
            return false;
        }
        if (!sAnim) {
            return true;
        }
        NBTTagCompound targetTags = this.getAnimalTags(target);
        String targetID = targetTags.func_74779_i("id");
        return targetID.equals(slotID = (slotTags = this.getAnimalTags(slot)).func_74779_i("id")) && this.satisfies((NBTBase)targetTags, (NBTBase)slotTags);
    }

    public boolean satisfies(NBTBase target, NBTBase presented) {
        if (presented == null) {
            return false;
        }
        byte id = target.func_74732_a();
        if (target instanceof NBTBase.NBTPrimitive) {
            if (!(presented instanceof NBTBase.NBTPrimitive)) {
                return false;
            }
            NBTBase.NBTPrimitive a = (NBTBase.NBTPrimitive)target;
            NBTBase.NBTPrimitive b = (NBTBase.NBTPrimitive)presented;
            switch (id) {
                case 1: {
                    return a.func_150290_f() == b.func_150290_f();
                }
                case 2: {
                    return a.func_150289_e() == b.func_150289_e();
                }
                case 3: {
                    return a.func_150287_d() == b.func_150287_d();
                }
                case 4: {
                    return a.func_150291_c() == b.func_150291_c();
                }
                case 5: {
                    return a.func_150288_h() == b.func_150288_h();
                }
                case 6: {
                    return a.func_150286_g() == b.func_150286_g();
                }
            }
            return false;
        }
        if (presented.func_74732_a() != id) {
            return false;
        }
        if (id == 10) {
            NBTTagCompound nbt_a = (NBTTagCompound)target;
            NBTTagCompound nbt_b = (NBTTagCompound)presented;
            for (String s : nbt_a.func_150296_c()) {
                if (this.satisfies(nbt_a.func_74781_a(s), nbt_b.func_74781_a(s))) continue;
                return false;
            }
            return true;
        }
        if (id == 9) {
            NBTTagList a = (NBTTagList)target;
            NBTTagList b = (NBTTagList)target;
            int n = a.func_74745_c();
            if (n != b.func_74745_c()) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.satisfies(a.func_179238_g(i), b.func_179238_g(i))) continue;
                return false;
            }
            return true;
        }
        return target.equals((Object)presented);
    }

    public NBTTagCompound getAnimalTags(ItemStack target) {
        return target.func_77978_p().func_74775_l(NBT_ANIMAL);
    }

    public boolean func_179215_a(NBTTagCompound nbt) {
        nbt.func_82580_o(NBT_ANIMAL_NOPLACE_OLD);
        return super.func_179215_a(nbt);
    }
}

