/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.rwtema.extrautils2.items.ItemSelectionWand;
import com.rwtema.extrautils2.utils.PositionPool;
import com.rwtema.extrautils2.utils.helpers.PlayerHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ItemDestructionWand
extends ItemSelectionWand {
    Item[] harvestDelegates = new Item[]{Items.field_151051_r, Items.field_151050_s, Items.field_151050_s};
    Item[] speedDelegates = new Item[]{Items.field_151037_a, Items.field_151035_b, Items.field_151035_b};

    public ItemDestructionWand(String texture, String name, float[] col, int range) {
        super(texture, name, col, range);
    }

    @Override
    protected boolean initialCheck(World world, BlockPos pos, EnumFacing side, ItemStack pickBlock1, Block block) {
        return !this.func_150897_b(block);
    }

    @Override
    protected int getNumBlocks(EntityPlayer player, int maxBlocks, ItemStack pickBlock1, boolean grassBlock) {
        return this.range;
    }

    @Override
    protected boolean checkAndAddBlocks(EntityPlayer player, World world, EnumFacing side, ItemStack pickBlock1, Block block, PositionPool pool, BlockPos p, List<BlockPos> blocks) {
        if (!player.func_146099_a(block)) {
            return false;
        }
        BlockPos p1 = p.func_177972_a(side);
        if (p.func_177958_n() == MathHelper.func_76128_c((double)player.field_70165_t) && p.func_177956_o() == MathHelper.func_76128_c((double)(player.field_70163_u - (double)0.2f)) && p.func_177952_p() == MathHelper.func_76128_c((double)player.field_70161_v)) {
            return false;
        }
        IBlockState blockState1 = world.func_180495_p(p1);
        Block block1 = blockState1.func_177230_c();
        if (block1.isNormalCube((IBlockAccess)world, p1)) {
            return false;
        }
        block1.func_180654_a((IBlockAccess)world, p1);
        AxisAlignedBB collisionBoundingBox = block1.func_180640_a(world, p1, blockState1);
        if (collisionBoundingBox != null) {
            collisionBoundingBox = collisionBoundingBox.func_72317_d((double)(-p1.func_177958_n()), (double)(-p1.func_177956_o()), (double)(-p1.func_177952_p()));
            switch (side) {
                case UP: {
                    if (collisionBoundingBox.field_72338_b <= 0.0) {
                        return false;
                    }
                }
                case DOWN: {
                    if (collisionBoundingBox.field_72337_e >= 1.0) {
                        return false;
                    }
                }
                case SOUTH: {
                    if (!(collisionBoundingBox.field_72339_c <= 0.0)) break;
                    return false;
                }
                case NORTH: {
                    if (!(collisionBoundingBox.field_72334_f >= 1.0)) break;
                    return false;
                }
                case EAST: {
                    if (!(collisionBoundingBox.field_72340_a <= 0.0)) break;
                    return false;
                }
                case WEST: {
                    if (!(collisionBoundingBox.field_72336_d >= 1.0)) break;
                    return false;
                }
            }
        }
        blocks.add(p);
        return true;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        World world = player.field_70170_p;
        if (world.func_175623_d(pos)) {
            return false;
        }
        if (world.field_72995_K) {
            return false;
        }
        MovingObjectPosition mop = PlayerHelper.rayTrace(player);
        if (mop == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK || !mop.func_178782_a().equals((Object)pos)) {
            return false;
        }
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        ItemStack pickBlock = this.getStack(world, pos);
        List<BlockPos> potentialBlocks = this.getPotentialBlocks(player, world, pos, mop.field_178784_b, this.range, pickBlock, blockState, block);
        if (potentialBlocks.isEmpty()) {
            return false;
        }
        boolean doDrops = !player.field_71075_bZ.field_75098_d;
        for (BlockPos potentialBlock : potentialBlocks) {
            IBlockState iblockstate = world.func_180495_p(potentialBlock);
            Block block1 = iblockstate.func_177230_c();
            if (block1.func_149688_o() == Material.field_151579_a) continue;
            if (doDrops) {
                block1.func_176226_b(world, potentialBlock, iblockstate, 0);
            }
            world.func_180501_a(potentialBlock, Blocks.field_150350_a.func_176223_P(), 3);
            world.func_175689_h(pos);
        }
        return true;
    }

    public boolean func_150897_b(Block blockIn) {
        if (blockIn.func_149688_o().func_76229_l()) {
            return true;
        }
        for (Item item : this.harvestDelegates) {
            if (!item.func_150897_b(blockIn)) continue;
            return true;
        }
        return super.func_150897_b(blockIn);
    }

    public float func_150893_a(ItemStack stack, Block block) {
        float t = super.func_150893_a(stack, block);
        for (Item item : this.speedDelegates) {
            t = Math.max(t, item.func_150893_a(stack, block));
        }
        return t;
    }

    public float getDigSpeed(ItemStack stack, IBlockState state) {
        float t = super.getDigSpeed(stack, state);
        for (Item item : this.speedDelegates) {
            t = Math.max(t, item.getDigSpeed(new ItemStack(item), state));
        }
        return t;
    }

    @SubscribeEvent
    public void adjustDigSpeed(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.entityPlayer;
        if (player.func_70694_bm() == null || player.func_70694_bm().func_77973_b() != this) {
            return;
        }
        World world = player.field_70170_p;
        BlockPos pos = event.pos;
        if (world.func_175623_d(pos)) {
            return;
        }
        MovingObjectPosition mop = PlayerHelper.rayTrace(player);
        if (mop == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK || !mop.func_178782_a().equals((Object)pos)) {
            event.setCanceled(true);
            return;
        }
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        ItemStack pickBlock = this.getStack(world, pos);
        List<BlockPos> potentialBlocks = this.getPotentialBlocks(player, world, pos, mop.field_178784_b, this.range, pickBlock, blockState, block);
        if (potentialBlocks.isEmpty()) {
            event.setCanceled(true);
            return;
        }
        event.newSpeed /= (float)potentialBlocks.size();
    }
}

