/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.rwtema.extrautils2.backend.XUItemFlatMetadata;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.WidgetSlotItemHandler;
import com.rwtema.extrautils2.itemhandler.SingleStackHandlerBase;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.CollectionHelper;
import com.rwtema.extrautils2.utils.helpers.NBTHelper;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class ItemBagOfHolding
extends XUItemFlatMetadata
implements IDynamicHandler {
    public ItemBagOfHolding() {
        super("bag_of_holding");
        this.func_77625_d(1);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new BagHoldingItemHandler(stack);
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        if (!worldIn.field_72995_K) {
            this.openItemGui(playerIn);
        }
        return itemStackIn;
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        if (player == null) {
            return null;
        }
        InventoryPlayer inventory = player.field_71071_by;
        int slot = inventory.field_70461_c;
        ItemStack heldItem = player.func_70694_bm();
        if (heldItem == null || heldItem.func_77973_b() != this) {
            return null;
        }
        IItemHandler handler = (IItemHandler)heldItem.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (handler == null || handler.getClass() != BagHoldingItemHandler.class) {
            return null;
        }
        return new ContainerBagHolding(player, slot, (BagHoldingItemHandler)handler);
    }

    public class ContainerBagHolding
    extends DynamicContainer {
        public final InventoryPlayer inventory;
        public final EntityPlayer player;
        public final int slot;

        public ContainerBagHolding(EntityPlayer player, int slot, BagHoldingItemHandler handler) {
            this.player = player;
            this.inventory = player.field_71071_by;
            this.slot = slot;
            this.addTitle(Lang.getItemName(ItemBagOfHolding.this), false);
            int i = 0;
            while (i < handler.getSlots()) {
                int slotX = i % 9;
                int slotY = i / 9;
                final int dSlot = i++;
                this.addWidget(new WidgetSlotItemHandler(handler, dSlot, 5 + slotX * 18, 15 + slotY * 18){
                    ItemStack lastReturned;

                    public boolean func_75214_a(ItemStack stack) {
                        if (stack == null) {
                            return false;
                        }
                        ItemStack remainder = ContainerBagHolding.this.getHandler().insertItem(dSlot, stack, true);
                        return remainder == null || remainder.field_77994_a < stack.field_77994_a;
                    }

                    public ItemStack func_75211_c() {
                        this.lastReturned = ContainerBagHolding.this.getHandler().getStackInSlot(dSlot);
                        return this.lastReturned;
                    }

                    public void func_75215_d(ItemStack stack) {
                        IItemHandler handler1 = ContainerBagHolding.this.getHandler();
                        if (handler1 instanceof BagHoldingItemHandler) {
                            ((IItemHandlerModifiable)((BagHoldingItemHandler)handler1).getSlotHandler(dSlot)).setStackInSlot(dSlot, stack);
                            this.lastReturned = stack;
                            this.func_75218_e();
                        }
                    }

                    @Override
                    public void func_75218_e() {
                        ItemStack lastReturned = this.lastReturned;
                        ItemStack stack = ContainerBagHolding.this.getHandler().getStackInSlot(dSlot);
                        if (lastReturned != null && stack != null && lastReturned.field_77994_a != stack.field_77994_a && ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)lastReturned)) {
                            this.func_75215_d(lastReturned);
                            return;
                        }
                        super.func_75218_e();
                    }

                    @Override
                    public void func_75220_a(ItemStack p_75220_1_, ItemStack p_75220_2_) {
                        super.func_75220_a(p_75220_1_, p_75220_2_);
                    }

                    public int func_178170_b(ItemStack stack) {
                        ItemStack maxAdd = stack.func_77946_l();
                        maxAdd.field_77994_a = maxAdd.func_77976_d();
                        IItemHandler itemHandler = ContainerBagHolding.this.getHandler();
                        ItemStack currentStack = itemHandler.getStackInSlot(dSlot);
                        ItemStack remainder = itemHandler.insertItem(dSlot, maxAdd, true);
                        int current = currentStack == null ? 0 : currentStack.field_77994_a;
                        int added = maxAdd.field_77994_a - (remainder != null ? remainder.field_77994_a : 0);
                        return current + added;
                    }

                    public boolean func_82869_a(EntityPlayer playerIn) {
                        return ContainerBagHolding.this.getHandler().extractItem(dSlot, 1, true) != null;
                    }

                    public ItemStack func_75209_a(int amount) {
                        ItemStack itemStack = ContainerBagHolding.this.getHandler().extractItem(dSlot, amount, false);
                        this.func_75211_c();
                        return itemStack;
                    }
                });
            }
            this.cropAndAddPlayerSlots(this.inventory);
            this.validate();
        }

        public IItemHandler getHandler() {
            ItemStack heldItem = this.player.func_70694_bm();
            if (heldItem == null || heldItem.func_77973_b() != ItemBagOfHolding.this) {
                return EmptyHandler.INSTANCE;
            }
            IItemHandler capability = (IItemHandler)heldItem.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (!(capability instanceof BagHoldingItemHandler)) {
                return EmptyHandler.INSTANCE;
            }
            return capability;
        }

        @Override
        public ItemStack func_75144_a(int slotId, int clickedButton, int mode, EntityPlayer playerIn) {
            return super.func_75144_a(slotId, clickedButton, mode, playerIn);
        }

        public boolean func_75145_c(EntityPlayer playerIn) {
            return playerIn == this.player && this.inventory.field_70461_c == this.slot && this.getHandler() != EmptyHandler.INSTANCE;
        }
    }

    public class BagHoldingItemHandler
    implements ICapabilityProvider,
    IItemHandler {
        final ItemStack bagStack;

        public BagHoldingItemHandler(ItemStack bagStack) {
            this.bagStack = bagStack;
        }

        public int getSlots() {
            return 54;
        }

        public IItemHandler getSlotHandler(final int slot) {
            if (slot < 0 || slot >= 54) {
                return EmptyHandler.INSTANCE;
            }
            return new SingleStackHandlerBase(){

                @Override
                public ItemStack getStack() {
                    String key;
                    NBTTagCompound itemsTag = NBTHelper.getOrInitTagCompound(NBTHelper.getOrInitTagCompound(BagHoldingItemHandler.this.bagStack), "Items");
                    if (itemsTag.func_150297_b(key = this.getSlotKey(), 10)) {
                        ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)itemsTag.func_74775_l(key));
                        if (itemStack == null) {
                            itemsTag.func_82580_o(key);
                        }
                        return itemStack;
                    }
                    return null;
                }

                @Nonnull
                public String getSlotKey() {
                    return CollectionHelper.STRING_DIGITS[slot];
                }

                @Override
                protected int getStackLimit(ItemStack stack) {
                    if (stack.func_77973_b() == ItemBagOfHolding.this) {
                        return 0;
                    }
                    if (stack.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                        return 0;
                    }
                    return super.getStackLimit(stack);
                }

                @Override
                public void setStack(ItemStack curStack) {
                    NBTTagCompound itemsTag = NBTHelper.getOrInitTagCompound(NBTHelper.getOrInitTagCompound(BagHoldingItemHandler.this.bagStack), "Items");
                    String key = this.getSlotKey();
                    if (curStack == null) {
                        itemsTag.func_82580_o(key);
                    } else {
                        curStack.func_77955_b(NBTHelper.getOrInitTagCompound(itemsTag, key));
                    }
                }
            };
        }

        public ItemStack getStackInSlot(int slot) {
            return this.getSlotHandler(slot).getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.getSlotHandler(slot).insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.getSlotHandler(slot).extractItem(slot, amount, simulate);
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return facing == null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(this.hasCapability(capability, facing) ? this : null);
        }
    }
}

