/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.itemhandler;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class InventoryHelper {
    private static final Random RANDOM = new Random();

    public static void dropAll(World world, BlockPos pos, IItemHandler handler) {
        InventoryHelper.dropAll(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), handler);
    }

    public static void dropAll(World world, int x, int y, int z, IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack == null) continue;
            InventoryHelper.dropItemStack(world, x, y, z, stack);
        }
    }

    public static void dropItemStack(World worldIn, double x, double y, double z, ItemStack stack) {
        float dx = RANDOM.nextFloat() * 0.8f + 0.1f;
        float dy = RANDOM.nextFloat() * 0.8f + 0.1f;
        float dz = RANDOM.nextFloat() * 0.8f + 0.1f;
        while (stack.field_77994_a > 0) {
            int i = RANDOM.nextInt(21) + 10;
            if (i > stack.field_77994_a) {
                i = stack.field_77994_a;
            }
            stack.field_77994_a -= i;
            EntityItem entityitem = new EntityItem(worldIn, x + (double)dx, y + (double)dy, z + (double)dz, new ItemStack(stack.func_77973_b(), i, stack.func_77960_j()));
            if (stack.func_77942_o()) {
                entityitem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
            }
            entityitem.field_70159_w = RANDOM.nextGaussian() * 0.05;
            entityitem.field_70181_x = RANDOM.nextGaussian() * 0.05 + 0.2;
            entityitem.field_70179_y = RANDOM.nextGaussian() * 0.05;
            worldIn.func_72838_d((Entity)entityitem);
        }
    }

    public static int transfer(IItemHandler src, int srcSlot, IItemHandler dest, int maxAmount, boolean allSlots) {
        int i;
        int sent = 0;
        if ((maxAmount = InventoryHelper.getStackLimit(src.extractItem(srcSlot, maxAmount, true))) == 0) {
            return sent;
        }
        int firstEmptySlot = -1;
        for (i = 0; i < dest.getSlots(); ++i) {
            if (dest.getStackInSlot(i) != null) {
                if (((sent += InventoryHelper.transferSlotAtoSlotB(src, srcSlot, dest, i, maxAmount - sent)) <= 0 || !allSlots) && sent < maxAmount) continue;
                return sent;
            }
            if (firstEmptySlot != -1) continue;
            firstEmptySlot = i;
        }
        if (firstEmptySlot == -1) {
            return sent;
        }
        for (i = firstEmptySlot; i < dest.getSlots(); ++i) {
            if (dest.getStackInSlot(i) != null || ((sent += InventoryHelper.transferSlotAtoSlotB(src, srcSlot, dest, i, maxAmount - sent)) <= 0 || !allSlots) && sent < maxAmount) continue;
            return sent;
        }
        return sent;
    }

    public static int getStackLimit(ItemStack stack) {
        return stack != null ? stack.field_77994_a : 0;
    }

    public static int transferSlotAtoSlotB(IItemHandler handlerA, int slotA, IItemHandler handlerB, int slotB, int maxAmount) {
        ItemStack initExtract = handlerA.extractItem(slotA, maxAmount, true);
        if (initExtract == null) {
            return 0;
        }
        ItemStack initRemainder = handlerB.insertItem(slotB, initExtract, true);
        int i = initExtract.field_77994_a - InventoryHelper.getStackLimit(initRemainder);
        if (i == 0) {
            return 0;
        }
        ItemStack actualExtract = handlerA.extractItem(slotA, i, false);
        handlerB.insertItem(slotB, actualExtract, false);
        return i;
    }

    public static ItemStack insert(IItemHandler handler, ItemStack insert, boolean simulate) {
        ItemStack stackInSlot;
        int i;
        int firstEmptySlot = -1;
        for (i = 0; i < handler.getSlots(); ++i) {
            stackInSlot = handler.getStackInSlot(i);
            if (stackInSlot != null) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stackInSlot, (ItemStack)insert) || (insert = handler.insertItem(i, insert, simulate)) != null) continue;
                return null;
            }
            if (firstEmptySlot != -1) continue;
            firstEmptySlot = i;
        }
        if (firstEmptySlot == -1) {
            return insert;
        }
        for (i = firstEmptySlot; i < handler.getSlots(); ++i) {
            stackInSlot = handler.getStackInSlot(i);
            if (stackInSlot != null || (insert = handler.insertItem(i, insert, simulate)) != null) continue;
            return null;
        }
        return insert;
    }

    public static int getMaxInsert(IItemHandler handler, ItemStack insert) {
        if (insert == null) {
            return 0;
        }
        int adding = insert.field_77994_a;
        for (int i = 0; i < handler.getSlots(); ++i) {
            if ((insert = handler.insertItem(i, insert, true)) != null) continue;
            return adding;
        }
        return adding - insert.field_77994_a;
    }
}

