/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.itemhandler;

import com.rwtema.extrautils2.itemhandler.ConcatFixedLengthSingleSlot;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ConcatFixedLength
implements IItemHandlerModifiable {
    final IItemHandler[] handlers;
    final int[] firstSlot;
    final int totalSlots;

    public ConcatFixedLength(IItemHandler ... handlers) {
        this.handlers = handlers;
        this.firstSlot = new int[handlers.length];
        int v = 0;
        for (int i = 0; i < handlers.length; ++i) {
            this.firstSlot[i] = v;
            v += handlers[i].getSlots();
        }
        this.totalSlots = v;
    }

    public static IItemHandler create(IItemHandler ... handlers) {
        for (IItemHandler handler : handlers) {
            if (handler.getSlots() == 1) continue;
            return new ConcatFixedLength(handlers);
        }
        return new ConcatFixedLengthSingleSlot(handlers);
    }

    public int getSlots() {
        return this.totalSlots;
    }

    public int getHandlerIndex(int slot) {
        int i = Arrays.binarySearch(this.firstSlot, slot);
        return i >= 0 ? i : -i - 2;
    }

    public ItemStack getStackInSlot(int slot) {
        int i = this.getHandlerIndex(slot);
        return this.handlers[i].getStackInSlot(slot - this.firstSlot[i]);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        int i = this.getHandlerIndex(slot);
        return this.handlers[i].insertItem(slot - this.firstSlot[i], stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        int i = this.getHandlerIndex(slot);
        return this.handlers[i].extractItem(slot - this.firstSlot[i], amount, simulate);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        int i = this.getHandlerIndex(slot);
        if (!(this.handlers[i] instanceof IItemHandlerModifiable)) {
            throw new UnsupportedOperationException();
        }
        ((IItemHandlerModifiable)this.handlers[i]).setStackInSlot(slot - this.firstSlot[i], stack);
    }
}

