/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.gui.backend;

import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.WidgetBase;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WidgetTileBackground
extends WidgetBase {
    private final World world;
    private final BlockPos pos;

    public WidgetTileBackground(World world, BlockPos pos, int y, int size) {
        super((170 - size) / 2, y, size, size);
        this.world = world;
        this.pos = pos;
    }

    @Override
    public void addToContainer(DynamicContainer container) {
        super.addToContainer(container);
        this.x = (container.width - this.w) / 2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2f);
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175022_a(this.world.func_180495_p(this.pos), (IBlockAccess)this.world, this.pos);
        Tessellator instance = Tessellator.func_178181_a();
        WorldRenderer t = instance.func_178180_c();
        t.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        this.renderQuads(t, model.func_177550_a(), guiLeft + this.x, guiTop + this.y, 0.0f);
        for (EnumFacing enumFacing : EnumFacing.values()) {
            this.renderQuads(t, model.func_177551_a(enumFacing), guiLeft + this.x, guiTop + this.y, 0.0f);
        }
        instance.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        GlStateManager.func_179084_k();
    }

    public void renderQuads(WorldRenderer t, List<BakedQuad> quadList, float x, float y, float z) {
        for (BakedQuad bakedQuad : quadList) {
            this.renderQuad(t, bakedQuad, x, y, z);
        }
    }

    private void renderQuad(WorldRenderer t, BakedQuad bakedQuad, float x, float y, float z) {
        int[] vertexData = bakedQuad.func_178209_a();
        for (int i = 0; i < 4; ++i) {
            t.func_181662_b((double)(x + (float)this.w * Float.intBitsToFloat(vertexData[i * 7])), (double)(y + (float)this.h * (1.0f - Float.intBitsToFloat(vertexData[i * 7 + 1]))), (double)z).func_181675_d();
        }
    }

    @Override
    public List<String> getToolTip() {
        return null;
    }
}

