/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.gui.backend;

import com.google.common.collect.Lists;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.IAdditionalWidgets;
import com.rwtema.extrautils2.gui.backend.IWidget;
import com.rwtema.extrautils2.gui.backend.WidgetScrollBar;
import com.rwtema.extrautils2.gui.backend.WidgetTextData;
import com.rwtema.extrautils2.network.PacketBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class WidgetTextDataScroll
extends WidgetTextData
implements IAdditionalWidgets {
    WidgetScrollBar scrollBar;
    List<String> strings = new ArrayList<String>();
    int numLines;

    public WidgetTextDataScroll(int x, int y, int w, int h) {
        super(x, y, w - 14, h);
        this.scrollBar = new WidgetScrollBar(x + w - 14, y, h, 0, 1){

            @Override
            protected void onChange() {
            }
        };
        this.numLines = h / 9;
    }

    @Override
    public List<IWidget> getAdditionalWidgets() {
        return Lists.newArrayList((Object[])new IWidget[]{this.scrollBar});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleDescriptionPacket(PacketBuffer packet) {
        super.handleDescriptionPacket(packet);
        this.strings = this.msg != null ? this.gui.getFontRenderer().func_78271_c(this.msg, this.w) : new ArrayList<String>();
        this.scrollBar.setValues(0, Math.max(0, this.strings.size() - this.numLines));
    }

    @Override
    public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
    }

    @Override
    public void renderForeground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
        if (this.msg == null || this.strings.isEmpty()) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int scrollValue = this.scrollBar.scrollValue;
        List<String> strings = this.strings;
        for (int i = scrollValue; i < Math.min(strings.size(), scrollValue + this.numLines); ++i) {
            gui.getFontRenderer().func_78276_b(strings.get(i), guiLeft + this.getX(), guiTop + this.getY() + (i - scrollValue) * 9, 0x404040);
        }
    }
}

