/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.gui.backend;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.IAdditionalWidgets;
import com.rwtema.extrautils2.gui.backend.IWidget;
import com.rwtema.extrautils2.gui.backend.IWidgetServerNetwork;
import com.rwtema.extrautils2.gui.backend.WidgetBase;
import com.rwtema.extrautils2.gui.backend.WidgetClick;
import com.rwtema.extrautils2.network.PacketBuffer;
import com.rwtema.extrautils2.tile.XUTile;
import com.rwtema.extrautils2.utils.Lang;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.EnumFacing;

public class WidgetSideHandler
extends WidgetBase
implements IWidget,
IAdditionalWidgets {
    static int[][] locations = new int[][]{{17, 33}, {17, 0}, {0, 24}, {34, 7}, {0, 7}, {34, 24}};
    static TObjectIntHashMap<String> xOffsets = new TObjectIntHashMap(10, 0.5f, 0);
    List<IWidget> buttons = new ArrayList<IWidget>(6);

    public WidgetSideHandler(XUTile.XUTileCapabilitySide XUTileCapabilitySide2) {
        super(4, 4, 48, 47);
        for (int i = 0; i < 6; ++i) {
            EnumFacing facing = EnumFacing.values()[i];
            this.buttons.add(new WidgetSideClick(i, XUTileCapabilitySide2, facing));
        }
    }

    @Override
    public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
        gui.func_73729_b(guiLeft + this.getX() + 14, guiTop + this.getY() + 14, 234, 0, 20, 19);
    }

    @Override
    public List<IWidget> getAdditionalWidgets() {
        return this.buttons;
    }

    static {
        xOffsets.put((Object)"input", 1);
        xOffsets.put((Object)"disabled", 2);
        xOffsets.put((Object)"output", 3);
    }

    private class WidgetSideClick
    extends WidgetClick
    implements IWidgetServerNetwork {
        private final XUTile.XUTileCapabilitySide XUTileCapabilitySide;
        private final EnumFacing facing;

        public WidgetSideClick(int i, XUTile.XUTileCapabilitySide XUTileCapabilitySide2, EnumFacing facing) {
            super(WidgetSideHandler.this.getX() + locations[i][0], WidgetSideHandler.this.getY() + locations[i][1], 14, 14);
            this.XUTileCapabilitySide = XUTileCapabilitySide2;
            this.facing = facing;
        }

        @Override
        public List<String> getToolTip() {
            return ImmutableList.of((Object)Lang.translate(this.facing.func_176742_j()));
        }

        @Override
        public void onClick(byte b) {
            if (b == 0) {
                this.XUTileCapabilitySide.cycleForward(this.facing);
            } else if (b == 1) {
                this.XUTileCapabilitySide.cycleBackward(this.facing);
            }
        }

        @Override
        public void renderForeground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
            String name = ((Enum)this.XUTileCapabilitySide.getValue(this.facing)).name().toLowerCase();
            int u = xOffsets.get((Object)name) * 14;
            gui.func_73729_b(guiLeft + this.getX(), guiTop + this.getY(), u, 128, 14, 14);
        }

        @Override
        public void addToDescription(PacketBuffer packet) {
            for (EnumFacing facing : EnumFacing.values()) {
                packet.writeByte(((Enum)this.XUTileCapabilitySide.getValue(facing)).ordinal());
            }
        }

        @Override
        public void handleDescriptionPacket(PacketBuffer packet) {
            for (EnumFacing facing : EnumFacing.values()) {
                this.XUTileCapabilitySide.setValue(facing, packet.readUnsignedByte());
            }
        }
    }
}

