/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.gui.backend;

import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicWindow;
import com.rwtema.extrautils2.gui.backend.IWidget;
import com.rwtema.extrautils2.gui.backend.IWidgetKeyInput;
import com.rwtema.extrautils2.gui.backend.IWidgetMouseInput;
import com.rwtema.extrautils2.gui.backend.WidgetButton;
import com.rwtema.extrautils2.utils.client.GLStateAttributes;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class DynamicGui
extends GuiContainer {
    public static final ResourceLocation texBackground = new ResourceLocation("extrautils2", "textures/guiBase.png");
    public static final ResourceLocation texBackgroundIndentation = new ResourceLocation("extrautils2", "textures/guiBaseIndent.png");
    public static final ResourceLocation texBackgroundBlack = new ResourceLocation("extrautils2", "textures/guiBaseBlack.png");
    public static final ResourceLocation texWidgets = new ResourceLocation("extrautils2", "textures/guiWidget.png");
    public final DynamicContainer container;
    public int mouseX;
    public int mouseY;
    TIntObjectHashMap<WidgetButton> buttonWidgets = new TIntObjectHashMap();

    public DynamicGui(DynamicContainer container) {
        super((Container)container);
        container.isClient = true;
        this.container = container;
        container.loadGuiDimensions(this);
    }

    public int nextButtonID() {
        return this.field_146292_n.size();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int y = 0;
        for (DynamicWindow dynamicWindow : this.container.getWindowWidgets().keySet()) {
            if (dynamicWindow == null) continue;
            Set iWidgets = this.container.getWindowWidgets().get((Object)dynamicWindow);
            dynamicWindow.crop(iWidgets);
            dynamicWindow.x = this.container.width;
            dynamicWindow.y = y;
        }
        this.container.loadGuiDimensions(this);
        for (IWidget widget : this.container.getWidgets()) {
            widget.addToGui(this);
        }
    }

    public void addButton(WidgetButton widgetButton, GuiButton button) {
        this.buttonWidgets.put(button.field_146127_k, (Object)widgetButton);
        this.field_146292_n.add(button);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        WidgetButton widgetButton;
        super.func_146284_a(button);
        if (button.field_146124_l && (widgetButton = (WidgetButton)this.buttonWidgets.get(button.field_146127_k)) != null) {
            widgetButton.onClientClick();
        }
    }

    public float getZLevel() {
        return this.field_73735_i;
    }

    public int getXSize() {
        return this.field_146999_f;
    }

    public int getYSize() {
        return this.field_147000_g;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public ResourceLocation getWidgetTexture() {
        return texWidgets;
    }

    public void drawScaledBox(ResourceLocation location, int x, int y, int w, int h) {
        this.field_146297_k.field_71446_o.func_110577_a(location);
        int dx = w / 2;
        int dy = h / 2;
        this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y, 0, 0, dx, dy);
        this.func_73729_b(this.field_147003_i + x + dx, this.field_147009_r + y, 256 - dx, 0, dx, dy);
        this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y + dy, 0, 256 - dy, dx, dy);
        this.func_73729_b(this.field_147003_i + x + dx, this.field_147009_r + y + dy, 256 - dx, 256 - dy, dx, dy);
    }

    protected void func_146976_a(float f, int a, int b) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        for (DynamicWindow dynamicWindow : this.container.getWindowWidgets().keySet()) {
            GLStateAttributes glStateAttributes;
            if (dynamicWindow == null) {
                if (!this.container.drawBackgroundOverride(this)) {
                    this.field_146297_k.field_71446_o.func_110577_a(texBackground);
                    this.drawBasicBackground(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
                }
                this.field_146297_k.field_71446_o.func_110577_a(this.getWidgetTexture());
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                glStateAttributes = GLStateAttributes.loadStates();
                for (IWidget widget : this.container.getWindowWidgets().get(null)) {
                    widget.renderBackground(this.field_146297_k.field_71446_o, this, this.field_147003_i, this.field_147009_r);
                    glStateAttributes.restore();
                }
                continue;
            }
            if (!dynamicWindow.drawBackgroundOverride(this, this.container)) {
                this.field_146297_k.field_71446_o.func_110577_a(texBackground);
                GlStateManager.func_179124_c((float)dynamicWindow.r, (float)dynamicWindow.g, (float)dynamicWindow.b);
                this.drawBasicBackground(this.field_147003_i + dynamicWindow.x, this.field_147009_r + dynamicWindow.y, dynamicWindow.w, dynamicWindow.h);
            }
            this.field_146297_k.field_71446_o.func_110577_a(this.getWidgetTexture());
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            glStateAttributes = GLStateAttributes.loadStates();
            for (IWidget widget : this.container.getWindowWidgets().get((Object)dynamicWindow)) {
                widget.renderBackground(this.field_146297_k.field_71446_o, this, this.field_147003_i + dynamicWindow.x, this.field_147009_r + dynamicWindow.y);
                glStateAttributes.restore();
            }
        }
    }

    public void drawBasicBackground(int x, int y, int w, int h) {
        int w2 = w >> 1;
        int h2 = h >> 1;
        int w3 = w - w2;
        int h3 = h - h2;
        this.func_73729_b(x, y, 0, 0, w2, h2);
        this.func_73729_b(x + w2, y, 256 - w3, 0, w3, h2);
        this.func_73729_b(x, y + h2, 0, 256 - h3, w2, h3);
        this.func_73729_b(x + w2, y + h2, 256 - w3, 256 - h3, w3, h3);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        List<String> tooltip = null;
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GLStateAttributes glStateAttributes = GLStateAttributes.loadStates();
        for (DynamicWindow dynamicWindow : this.container.getWindowWidgets().keySet()) {
            tooltip = dynamicWindow == null ? this.renderForeground(mouseX, mouseY, tooltip, null, this.field_147003_i, this.field_147009_r) : this.renderForeground(mouseX, mouseY, tooltip, dynamicWindow, this.field_147003_i + dynamicWindow.x, this.field_147009_r + dynamicWindow.y);
            glStateAttributes.restore();
        }
        if (tooltip != null) {
            this.drawHoveringText(tooltip, mouseX - this.field_147003_i, mouseY - this.field_147009_r, this.getFontRenderer());
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
        }
        RenderHelper.func_74520_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
    }

    private List<String> renderForeground(int mouseX, int mouseY, List<String> tooltip, DynamicWindow dynamicWindow, int guiX, int guiY) {
        for (IWidget widget : this.container.getWindowWidgets().get((Object)dynamicWindow)) {
            List<String> t;
            this.field_146297_k.field_71446_o.func_110577_a(this.getWidgetTexture());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            widget.renderForeground(this.field_146297_k.field_71446_o, this, guiX - this.field_147003_i, guiY - this.field_147009_r);
            if (!this.isInArea(mouseX, mouseY, widget) || (t = widget.getToolTip()) == null) continue;
            tooltip = t;
        }
        return tooltip;
    }

    public boolean isInArea(int x, int y, IWidget w) {
        DynamicWindow dynamicWindow = this.container.getWindowOwner().get(w);
        if (dynamicWindow == null) {
            x -= this.field_147003_i;
            y -= this.field_147009_r;
        } else {
            x -= dynamicWindow.x + this.field_147003_i;
            y -= dynamicWindow.y + this.field_147009_r;
        }
        return x >= w.getX() && x < w.getX() + w.getW() && y >= w.getY() && y < w.getY() + w.getH();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        for (IWidgetKeyInput input : this.container.getWidgetKeyInputs()) {
            input.keyTyped(typedChar, keyCode);
        }
    }

    public void func_146274_d() throws IOException {
        this.mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        this.mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        for (IWidgetMouseInput widgetMouseInput : this.container.getWidgetMouseInputs()) {
            widgetMouseInput.mouseTick(x, y, this.isInArea(x, y, widgetMouseInput));
        }
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        for (IWidgetMouseInput widgetMouseInput : this.container.getWidgetMouseInputs()) {
            widgetMouseInput.mouseWheelScroll(i);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int mouseButton) {
        super.func_146286_b(mouseX, mouseY, mouseButton);
        for (IWidgetMouseInput mouseInput : this.container.getWidgetMouseInputs()) {
            mouseInput.mouseReleased(mouseX, mouseY, mouseButton, this.isInArea(mouseX, mouseY, mouseInput));
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        for (IWidgetMouseInput mouseInput : this.container.getWidgetMouseInputs()) {
            mouseInput.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick, this.isInArea(mouseX, mouseY, mouseInput));
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (IWidgetMouseInput mouseInput : this.container.getWidgetMouseInputs()) {
            mouseInput.mouseClicked(mouseX, mouseY, mouseButton, this.isInArea(mouseX, mouseY, mouseInput));
        }
    }

    public void func_73730_a(int startX, int endX, int y, int color) {
        super.func_73730_a(startX, endX, y, color);
    }

    public void func_73728_b(int x, int startY, int endY, int color) {
        super.func_73728_b(x, startY, endY, color);
    }

    public void func_73733_a(int left, int top, int right, int bottom, int startColor, int endColor) {
        super.func_73733_a(left, top, right, bottom, startColor, endColor);
    }

    public void func_73732_a(FontRenderer fontRendererIn, String text, int x, int y, int color) {
        super.func_73732_a(fontRendererIn, text, x, y, color);
    }

    public void func_73731_b(FontRenderer fontRendererIn, String text, int x, int y, int color) {
        super.func_73731_b(fontRendererIn, text, x, y, color);
    }

    public void func_73729_b(int x, int y, int textureX, int textureY, int width, int height) {
        super.func_73729_b(x, y, textureX, textureY, width, height);
    }

    public void func_175174_a(float xCoord, float yCoord, int minU, int minV, int maxU, int maxV) {
        super.func_175174_a(xCoord, yCoord, minU, minV, maxU, maxV);
    }

    public void func_175175_a(int xCoord, int yCoord, TextureAtlasSprite textureSprite, int widthIn, int heightIn) {
        super.func_175175_a(xCoord, yCoord, textureSprite, widthIn, heightIn);
    }

    public void renderStack(ItemStack stack, int x, int y, String altText) {
        if (stack == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.field_146289_q;
        }
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_180453_a(font, stack, x, y, altText);
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
        GlStateManager.func_179121_F();
    }

    public void drawRectangle(int x, int y, int w, int h, int color) {
        DynamicGui.func_73734_a((int)x, (int)y, (int)(x + w), (int)(y + h), (int)color);
    }

    public void drawSlotBackground(int x, int y) {
        this.func_73729_b(x, y, 0, 0, 18, 18);
    }

    public void renderSmallStackText(ItemStack stack, String s, int x, int y) {
        if (stack == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.field_146289_q;
        }
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_180453_a(font, stack, x, y, "");
        if (!StringUtils.func_151246_b((String)s)) {
            float scaledFontWidth;
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179084_k();
            float scale = 2.0f;
            while (true) {
                float f;
                scaledFontWidth = (float)this.field_146289_q.func_78256_a(s) / scale;
                if (!(f >= 15.0f)) break;
                scale += 1.0f;
            }
            GlStateManager.func_179109_b((float)((float)(x + 16) - scaledFontWidth), (float)((float)(y + 17) - 9.0f / scale), (float)0.0f);
            GlStateManager.func_179152_a((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
            this.field_146289_q.func_175063_a(s, 0.0f, 0.0f, 0xFFFFFF);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
        }
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
        GlStateManager.func_179121_F();
    }
}

