/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.gui.backend;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.ISidedFunction;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.DynamicWindow;
import com.rwtema.extrautils2.gui.backend.IAdditionalWidgets;
import com.rwtema.extrautils2.gui.backend.ISlotClick;
import com.rwtema.extrautils2.gui.backend.IWidget;
import com.rwtema.extrautils2.gui.backend.IWidgetClientNetwork;
import com.rwtema.extrautils2.gui.backend.IWidgetKeyInput;
import com.rwtema.extrautils2.gui.backend.IWidgetMouseInput;
import com.rwtema.extrautils2.gui.backend.IWidgetServerNetwork;
import com.rwtema.extrautils2.gui.backend.WidgetSlot;
import com.rwtema.extrautils2.gui.backend.WidgetText;
import com.rwtema.extrautils2.gui.backend.WidgetTextTranslate;
import com.rwtema.extrautils2.network.NetworkHandler;
import com.rwtema.extrautils2.network.PacketBuffer;
import com.rwtema.extrautils2.network.XUPacketClientToServer;
import com.rwtema.extrautils2.network.XUPacketServerToClient;
import com.rwtema.extrautils2.utils.Lang;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public abstract class DynamicContainer
extends Container {
    public static final int playerInvWidth = 162;
    public static final int centerX = 85;
    public static final int centerSlotX = 76;
    public static final int playerInvHeight = 95;
    public static final ISidedFunction<String, Integer> STRING_WIDTH_FUNCTION = new ISidedFunction<String, Integer>(){

        @Override
        @SideOnly(value=Side.SERVER)
        public Integer applyServer(String input) {
            return input != null ? input.length() : 0;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public Integer applyClient(String input) {
            return input != null ? Minecraft.func_71410_x().field_71466_p.func_78256_a(input) : 0;
        }
    };
    public static final ISidedFunction<Pair<String, Integer>, Integer> STRING_HEIGHTS = new ISidedFunction<Pair<String, Integer>, Integer>(){

        @Override
        public Integer applyServer(Pair<String, Integer> input) {
            String[] split;
            int w = 0;
            for (String s : split = ((String)input.getKey()).split("\n")) {
                float sw = STRING_WIDTH_FUNCTION.applyServer(s).intValue();
                w += MathHelper.func_76143_f((double)(sw / (float)w));
            }
            return w * 9;
        }

        @Override
        public Integer applyClient(Pair<String, Integer> input) {
            List strings = Minecraft.func_71410_x().field_71466_p.func_78271_c((String)input.getKey(), ((Integer)input.getValue()).intValue());
            return strings.size() * 9;
        }
    };
    private static final ItemStack genericItemStack = new ItemStack(Blocks.field_150347_e, 0);
    public int playerSlotsStart = -1;
    public LinkedList<EntityPlayerMP> entityPlayerMPs = new LinkedList();
    public int width = 176;
    public int height = 166;
    public boolean changesOnly = false;
    public boolean isClient = false;
    ByteBuf previousPacket = Unpooled.buffer();
    boolean fixed = false;
    private LinkedHashMultimap<DynamicWindow, IWidget> windowWidgets = LinkedHashMultimap.create();
    private List<IWidget> widgets = new ArrayList<IWidget>();
    private List<IWidgetKeyInput> widgetKeyInputs = new ArrayList<IWidgetKeyInput>();
    private List<IWidgetMouseInput> widgetMouseInputs = new ArrayList<IWidgetMouseInput>();
    private List<IWidgetClientNetwork> widgetReceivers = new ArrayList<IWidgetClientNetwork>();
    private List<IWidgetServerNetwork> widgetNetworks = new ArrayList<IWidgetServerNetwork>();
    private HashMap<IWidget, DynamicWindow> windowOwner = new HashMap();
    private HashSet<DynamicWindow> windows = new HashSet();

    public HashMap<IWidget, DynamicWindow> getWindowOwner() {
        return this.windowOwner;
    }

    public LinkedHashMultimap<DynamicWindow, IWidget> getWindowWidgets() {
        return this.windowWidgets;
    }

    public List<IWidgetKeyInput> getWidgetKeyInputs() {
        return ImmutableList.copyOf(this.widgetKeyInputs);
    }

    public List<IWidgetMouseInput> getWidgetMouseInputs() {
        return ImmutableList.copyOf(this.widgetMouseInputs);
    }

    public List<IWidget> getWidgets() {
        return ImmutableList.copyOf(this.widgets);
    }

    void addSlot(Slot slot) {
        this.func_75146_a(slot);
    }

    public void func_75132_a(ICrafting iCrafting) {
        if (iCrafting instanceof EntityPlayerMP) {
            this.entityPlayerMPs.add((EntityPlayerMP)iCrafting);
        }
        this.changesOnly = false;
        super.func_75132_a(iCrafting);
    }

    public void func_75142_b() {
        if (this.isClient) {
            return;
        }
        super.func_75142_b();
        ByteBuf buffer = Unpooled.buffer();
        PacketBuffer packetBuffer = new PacketBuffer(buffer);
        for (IWidgetServerNetwork widget : this.widgetNetworks) {
            widget.addToDescription(packetBuffer);
        }
        this.previousPacket.setIndex(0, this.previousPacket.writerIndex());
        if (ByteBufUtil.equals((ByteBuf)buffer, (ByteBuf)this.previousPacket)) {
            return;
        }
        this.previousPacket = Unpooled.copiedBuffer((ByteBuf)buffer);
        for (EntityPlayerMP player : this.entityPlayerMPs) {
            NetworkHandler.sendPacketToPlayer(new PacketGUIData(this.field_75152_c, packetBuffer), (EntityPlayer)player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_82847_b(ICrafting par1ICrafting) {
        if (par1ICrafting instanceof EntityPlayerMP) {
            this.entityPlayerMPs.remove(par1ICrafting);
        }
        super.func_82847_b(par1ICrafting);
    }

    protected void validate() {
        for (IWidget widget : this.widgets) {
            widget.addToContainer(this);
        }
        this.fixed = true;
    }

    public void addPlayerSlotsToBottom(IInventory inventory) {
        this.addPlayerSlots(inventory, (this.width - 162) / 2, this.height - 95);
    }

    public void crop() {
        this.crop(4);
    }

    public void crop(int border) {
        int maxX = 18;
        int maxY = 18;
        for (IWidget widget : this.windowWidgets.get(null)) {
            maxX = Math.max(maxX, widget.getX() + widget.getW());
            maxY = Math.max(maxY, widget.getY() + widget.getH());
        }
        this.width = maxX + border;
        this.height = maxY + border;
    }

    public void cropAndAddPlayerSlots(InventoryPlayer inventory) {
        this.crop(4);
        this.height += 95;
        if (this.width < 170) {
            this.width = 170;
        }
        this.addPlayerSlotsToBottom((IInventory)inventory);
    }

    public void addPlayerSlots(IInventory inventory, int x, int y) {
        int j;
        this.playerSlotsStart = 0;
        for (IWidget w : this.widgets) {
            if (!(w instanceof Slot)) continue;
            ++this.playerSlotsStart;
        }
        this.addWidget(new WidgetTextTranslate(x, y, inventory.func_70005_c_(), 162));
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                WidgetSlot w = new WidgetSlot(inventory, k + j * 9 + 9, x + k * 18, y + 14 + j * 18);
                this.addWidget(w);
            }
        }
        for (j = 0; j < 9; ++j) {
            WidgetSlot w = new WidgetSlot(inventory, j, x + j * 18, y + 14 + 58);
            this.addWidget(w);
        }
    }

    public void addWidget(IWidget w) {
        this.addWidget(w, null);
    }

    public void addWidget(IWidget w, DynamicWindow dynamicWindow) {
        if (this.fixed) {
            throw new IllegalStateException();
        }
        this.widgets.add(w);
        if (dynamicWindow != null) {
            this.windows.add(dynamicWindow);
        }
        this.windowWidgets.put((Object)dynamicWindow, (Object)w);
        this.windowOwner.put(w, dynamicWindow);
        if (w instanceof IWidgetKeyInput) {
            this.widgetKeyInputs.add((IWidgetKeyInput)w);
        }
        if (w instanceof IWidgetMouseInput) {
            this.widgetMouseInputs.add((IWidgetMouseInput)w);
        }
        if (w instanceof IWidgetClientNetwork) {
            this.widgetReceivers.add((IWidgetClientNetwork)w);
        }
        if (w instanceof IWidgetServerNetwork) {
            this.widgetNetworks.add((IWidgetServerNetwork)w);
        }
        if (w instanceof IAdditionalWidgets) {
            for (IWidget iWidget : ((IAdditionalWidgets)((Object)w)).getAdditionalWidgets()) {
                this.addWidget(iWidget, dynamicWindow);
            }
        }
    }

    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int par2) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.field_75151_b.get(par2);
        if (this.playerSlotsStart > 0 && slot != null && slot.func_75216_d()) {
            ItemStack otherItemStack = slot.func_75211_c();
            itemstack = otherItemStack.func_77946_l();
            if (par2 < this.playerSlotsStart ? !this.func_75135_a(otherItemStack, this.playerSlotsStart, this.field_75151_b.size(), true) : !this.func_75135_a(otherItemStack, 0, this.playerSlotsStart, false)) {
                return null;
            }
            if (otherItemStack.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    protected boolean func_75135_a(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        int i;
        boolean flag = false;
        int n = i = reverseDirection ? endIndex - 1 : startIndex;
        if (stack.func_77985_e()) {
            while (stack.field_77994_a > 0 && (!reverseDirection && i < endIndex || reverseDirection && i >= startIndex)) {
                Slot slot = (Slot)this.field_75151_b.get(i);
                ItemStack itemstack = slot.func_75211_c();
                if (itemstack != null && slot.func_75214_a(itemstack) && itemstack.func_77973_b() == stack.func_77973_b() && (!stack.func_77981_g() || stack.func_77960_j() == itemstack.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack)) {
                    int j = itemstack.field_77994_a + stack.field_77994_a;
                    if (j <= Math.min(stack.func_77976_d(), slot.func_178170_b(itemstack))) {
                        stack.field_77994_a = 0;
                        itemstack.field_77994_a = j;
                        slot.func_75218_e();
                        flag = true;
                    } else if (itemstack.field_77994_a < stack.func_77976_d()) {
                        stack.field_77994_a -= stack.func_77976_d() - itemstack.field_77994_a;
                        itemstack.field_77994_a = stack.func_77976_d();
                        slot.func_75218_e();
                        flag = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (stack.field_77994_a > 0) {
            int n2 = i = reverseDirection ? endIndex - 1 : startIndex;
            while (!reverseDirection && i < endIndex || reverseDirection && i >= startIndex) {
                Slot slot1 = (Slot)this.field_75151_b.get(i);
                ItemStack otherStack = slot1.func_75211_c();
                if (otherStack == null && slot1.func_75214_a(stack)) {
                    int maxInsert = slot1.func_178170_b(stack);
                    if (stack.field_77994_a > maxInsert) {
                        slot1.func_75215_d(stack.func_77979_a(maxInsert));
                        slot1.func_75218_e();
                        flag = true;
                    } else {
                        slot1.func_75215_d(stack.func_77946_l());
                        slot1.func_75218_e();
                        stack.field_77994_a = 0;
                        flag = true;
                        break;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public int getStringWidth(String text) {
        return ExtraUtils2.proxy.apply(STRING_WIDTH_FUNCTION, text);
    }

    public void addTitle(String name) {
        this.addTitle(Lang.translate(name), false);
    }

    public void addTitle(String name, boolean translate) {
        WidgetText e = translate ? new WidgetTextTranslate(5, 5, name, this.getStringWidth(StatCollector.func_74838_a((String)name))) : new WidgetText(5, 5, name, this.getStringWidth(name));
        this.addWidget(e);
    }

    public ItemStack func_75144_a(int slotId, int clickedButton, int mode, EntityPlayer playerIn) {
        Slot slot;
        if (slotId >= 0 && slotId < this.field_75151_b.size() && (slot = (Slot)this.field_75151_b.get(slotId)) instanceof ISlotClick) {
            return ((ISlotClick)slot).slotClick(this, slotId, clickedButton, mode, playerIn);
        }
        return super.func_75144_a(slotId, clickedButton, mode, playerIn);
    }

    @SideOnly(value=Side.CLIENT)
    public void sendInputPacket(IWidgetClientNetwork widget, PacketBuffer buffer) {
        int i = this.widgetReceivers.indexOf(widget);
        if (i < 0) {
            throw new RuntimeException("Unable to find widget");
        }
        NetworkHandler.sendPacketToServer(new PacketGUIInput(this.field_75152_c, i, buffer));
    }

    public HashSet<DynamicWindow> getWindows() {
        return this.windows;
    }

    public void onSlotChanged(int index) {
        this.field_75153_a.set(index, genericItemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void loadGuiDimensions(DynamicGui dynamicGui) {
        dynamicGui.field_146999_f = this.width;
        dynamicGui.field_147000_g = this.height;
        dynamicGui.field_147003_i = (dynamicGui.field_146294_l - dynamicGui.field_146999_f) / 2;
        dynamicGui.field_147009_r = (dynamicGui.field_146295_m - dynamicGui.field_147000_g) / 2;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean drawBackgroundOverride(DynamicGui gui) {
        return false;
    }

    @NetworkHandler.XUPacket
    public static class PacketGUIData
    extends XUPacketServerToClient {
        private int windowId;
        private PacketBuffer packetBuffer;

        public PacketGUIData() {
        }

        public PacketGUIData(int windowId, PacketBuffer packetBuffer) {
            this.windowId = windowId;
            this.packetBuffer = packetBuffer;
        }

        @Override
        public void writeData() throws Exception {
            this.writeInt(this.windowId);
            this.writePacketBuffer(this.packetBuffer);
        }

        @Override
        public void readData(EntityPlayer player) {
            this.windowId = this.readInt();
            this.packetBuffer = this.readPacketBuffer();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public Runnable doStuffClient() {
            return new Runnable(){

                @Override
                public void run() {
                    Container openContainer = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
                    if (PacketGUIData.this.windowId == 0 || openContainer.field_75152_c != PacketGUIData.this.windowId) {
                        return;
                    }
                    DynamicContainer dynamicContainer = (DynamicContainer)openContainer;
                    for (IWidgetServerNetwork widget : dynamicContainer.widgetNetworks) {
                        widget.handleDescriptionPacket(PacketGUIData.this.packetBuffer);
                    }
                }
            };
        }
    }

    @NetworkHandler.XUPacket
    public static class PacketGUIInput
    extends XUPacketClientToServer {
        private int windowId;
        private int widgetId;
        private PacketBuffer packetBuffer;
        private EntityPlayer player;

        public PacketGUIInput() {
        }

        public PacketGUIInput(int windowId, int widgetId, PacketBuffer packetBuffer) {
            this.windowId = windowId;
            this.widgetId = widgetId;
            this.packetBuffer = packetBuffer;
        }

        @Override
        public void writeData() throws Exception {
            this.writeInt(this.windowId);
            this.writeShort(this.widgetId);
            if (this.packetBuffer == null) {
                this.writeInt(0);
            } else {
                this.writePacketBuffer(this.packetBuffer);
            }
        }

        @Override
        public void readData(EntityPlayer player) {
            this.player = player;
            this.windowId = this.readInt();
            this.widgetId = this.readUnsignedShort();
            this.packetBuffer = this.readPacketBuffer();
        }

        @Override
        public Runnable doStuffServer() {
            return new Runnable(){

                @Override
                public void run() {
                    Container openContainer = ((PacketGUIInput)PacketGUIInput.this).player.field_71070_bA;
                    if (PacketGUIInput.this.windowId == 0 || openContainer.field_75152_c != PacketGUIInput.this.windowId || !openContainer.func_75145_c(PacketGUIInput.this.player)) {
                        return;
                    }
                    DynamicContainer dynamicContainer = (DynamicContainer)openContainer;
                    List receivers = dynamicContainer.widgetReceivers;
                    if (PacketGUIInput.this.widgetId < 0 || PacketGUIInput.this.widgetId >= receivers.size()) {
                        return;
                    }
                    ((IWidgetClientNetwork)receivers.get(PacketGUIInput.this.widgetId)).receiveClientPacket(PacketGUIInput.this.packetBuffer);
                }
            };
        }
    }
}

