/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.gui;

import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.WidgetBase;
import com.rwtema.extrautils2.gui.backend.WidgetTextDataScroll;
import com.rwtema.extrautils2.items.ItemIngredients;
import com.rwtema.extrautils2.network.PacketBuffer;
import com.rwtema.extrautils2.power.Freq;
import com.rwtema.extrautils2.power.IPower;
import com.rwtema.extrautils2.power.PowerManager;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import gnu.trove.map.hash.TObjectFloatHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerPowerReport
extends DynamicContainer {
    public ContainerPowerReport(final EntityPlayer player) {
        this.addWidget(new WidgetTextDataScroll(4, 24, 176, 176){
            EntityPlayerMP playerMP;
            {
                super(x0, x1, x2, x3);
                this.playerMP = player instanceof EntityPlayerMP ? (EntityPlayerMP)player : null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addToDescription(PacketBuffer packet) {
                Object object = PowerManager.MUTEX;
                synchronized (object) {
                    TObjectIntHashMap numPowers = new TObjectIntHashMap();
                    TObjectFloatHashMap powerOutput = new TObjectFloatHashMap();
                    PowerManager.PowerFreq powerFreq = PowerManager.instance.getPowerFreq(Freq.getBasePlayerFreq(this.playerMP));
                    for (IPower handler : powerFreq.powerHandlers) {
                        String name = handler.getName();
                        if (name == null) continue;
                        float f = PowerManager.getCurrentPower(handler);
                        numPowers.adjustOrPutValue((Object)name, 1, 1);
                        powerOutput.adjustOrPutValue((Object)name, f, f);
                    }
                    Set names = numPowers.keySet();
                    packet.writeInt(names.size());
                    for (String name : names) {
                        packet.writeString(name);
                        packet.writeInt(numPowers.get((Object)name));
                        packet.writeFloat(powerOutput.get((Object)name));
                    }
                }
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            protected String constructText(PacketBuffer packet) {
                int n = packet.readInt();
                if (n == 0) {
                    return Lang.translate("No Power Handlers");
                }
                ArrayList<String> generators = new ArrayList<String>();
                ArrayList<String> drainers = new ArrayList<String>();
                ArrayList<String> inactive = new ArrayList<String>();
                for (int i = 0; i < n; ++i) {
                    String formattedText = StatCollector.func_74838_a((String)packet.readString());
                    int num = packet.readInt();
                    float power = packet.readFloat();
                    if (power < 0.0f) {
                        generators.add(Lang.translateArgs("%s x %s: %s GP", formattedText, num, StringHelper.niceFormat(-power)));
                        continue;
                    }
                    if (power > 0.0f) {
                        drainers.add(Lang.translateArgs("%s x %s: %s GP", formattedText, num, StringHelper.niceFormat(power)));
                        continue;
                    }
                    inactive.add(Lang.translateArgs("%s x %s", formattedText, num));
                }
                Collections.sort(generators);
                Collections.sort(drainers);
                StringBuilder builder = new StringBuilder();
                this.addEntries(builder, generators, "Power Generators");
                this.addEntries(builder, drainers, "Power Users");
                this.addEntries(builder, inactive, "Inactive");
                return builder.toString();
            }

            @SideOnly(value=Side.CLIENT)
            private void addEntries(StringBuilder builder, ArrayList<String> generators, String text) {
                if (!generators.isEmpty()) {
                    builder.append(Lang.translate(text)).append('\n');
                    for (String s : generators) {
                        builder.append(' ').append(s).append('\n');
                    }
                }
            }
        });
        this.crop(4);
        if (XU2Entries.itemIngredients.enabled) {
            this.addWidget(new WidgetBase(this.width / 2, 0, 0, 0){
                int size;
                {
                    this.size = 40;
                }

                @Override
                public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
                    manager.func_110577_a(TextureMap.field_110575_b);
                    TextureAtlasSprite sprite = Textures.sprites.get(ItemIngredients.Type.REDSTONE_CRYSTAL.texture);
                    if (sprite != null) {
                        gui.func_175175_a(guiLeft + this.getX() - this.size, guiTop + this.getY() - this.size, sprite, this.size * 2, this.size * 2);
                    }
                    manager.func_110577_a(gui.getWidgetTexture());
                }
            });
        }
        this.validate();
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }
}

