/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.eventhandlers;

import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.NBTHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RevengeHandler {
    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new RevengeHandler());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Entity victim = event.entity;
        World worldObj = victim.field_70170_p;
        if (worldObj == null || worldObj.field_72995_K) {
            return;
        }
        if (!worldObj.func_82736_K().func_82766_b("showDeathMessages")) {
            return;
        }
        Entity attacker = event.source.func_76346_g();
        if (!(attacker instanceof EntityLivingBase)) {
            return;
        }
        boolean attackerIsPlayer = attacker instanceof EntityPlayerMP;
        boolean victimIsPlayer = victim instanceof EntityPlayerMP;
        if (victimIsPlayer || attackerIsPlayer) {
            if (!attackerIsPlayer) {
                NBTTagCompound killList = NBTHelper.getOrInitTagCompound(attacker.getEntityData(), "entityKillList");
                EntityPlayerMP victimPlayer = (EntityPlayerMP)victim;
                String tagKey = this.getTagKey(victimPlayer);
                int kills = killList.func_74762_e(tagKey);
                if (++kills == 4) {
                    this.sendToPlayersFriends(victimPlayer, this.getDominationMessage(attacker, victim));
                }
                killList.func_74768_a(tagKey, kills);
            } else if (!victimIsPlayer) {
                EntityPlayerMP attackerPlayer;
                String tagKey;
                NBTTagCompound entityData = victim.getEntityData();
                if (!entityData.func_150297_b("entityKillList", 10)) {
                    return;
                }
                NBTTagCompound killList = entityData.func_74775_l("entityKillList");
                int kills = killList.func_74762_e(tagKey = this.getTagKey(attackerPlayer = (EntityPlayerMP)attacker));
                if (kills > 0) {
                    this.sendToPlayersFriends(attackerPlayer, this.getRevengeMessage(attacker, victim, kills >= 4));
                }
                killList.func_74768_a(tagKey, 0);
            } else {
                int kills;
                String tagKey;
                NBTTagCompound killList;
                EntityPlayerMP victimPlayer = (EntityPlayerMP)victim;
                NBTTagCompound victimPersistentTag = NBTHelper.getPersistentTag((EntityPlayer)victimPlayer);
                if (victimPersistentTag.func_150297_b("playerKillList", 10)) {
                    killList = victimPersistentTag.func_74775_l("playerKillList");
                    kills = killList.func_74762_e(tagKey = this.getTagKey((EntityPlayerMP)attacker));
                    if (kills >= 4) {
                        this.sendToPlayersFriends(victimPlayer, this.getRevengeMessage(attacker, victim, true));
                    }
                    killList.func_74768_a(tagKey, 0);
                }
                killList = NBTHelper.getOrInitTagCompound(NBTHelper.getPersistentTag((EntityPlayer)((EntityPlayerMP)attacker)), "playerKillList");
                tagKey = this.getTagKey((EntityPlayerMP)victim);
                kills = killList.func_74762_e(tagKey);
                if (++kills == 4) {
                    this.sendToPlayersFriends(victimPlayer, this.getDominationMessage(attacker, victim));
                }
                killList.func_74768_a(tagKey, kills);
            }
        }
    }

    private void sendToPlayersFriends(EntityPlayerMP playerMP, IChatComponent chatComponent) {
        Team team = playerMP.func_96124_cp();
        if (team != null && team.func_178771_j() != Team.EnumVisible.ALWAYS) {
            if (team.func_178771_j() == Team.EnumVisible.HIDE_FOR_OTHER_TEAMS) {
                playerMP.field_71133_b.func_71203_ab().func_177453_a((EntityPlayer)playerMP, chatComponent);
            } else if (team.func_178771_j() == Team.EnumVisible.HIDE_FOR_OWN_TEAM) {
                playerMP.field_71133_b.func_71203_ab().func_177452_b((EntityPlayer)playerMP, chatComponent);
            }
        } else {
            this.sendToAllPlayers(playerMP.field_71133_b, chatComponent);
        }
    }

    private void sendToAllPlayers(MinecraftServer mcServer, IChatComponent chatComponent) {
        mcServer.func_71203_ab().func_148539_a(chatComponent);
    }

    private IChatComponent getRevengeMessage(Entity attacker, Entity victim, boolean endDomination) {
        if (endDomination) {
            return Lang.chat("%s got revenge on nemesis %s", attacker.func_145748_c_(), victim.func_145748_c_());
        }
        return Lang.chat("%s got revenge on %s", attacker.func_145748_c_(), victim.func_145748_c_());
    }

    private IChatComponent getDominationMessage(Entity attacker, Entity victim) {
        return Lang.chat("%s is dominating %s", attacker.func_145748_c_(), victim.func_145748_c_());
    }

    public String getTagKey(EntityPlayerMP player) {
        return player.func_70005_c_();
    }
}

