/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.eventhandlers;

import com.rwtema.extrautils2.utils.XURandom;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import gnu.trove.procedure.TObjectDoubleProcedure;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class RareSeedHandler {
    private static final List<WeightedRandom.Item> seedEntries = (List)ObfuscationReflectionHelper.getPrivateValue(ForgeHooks.class, null, (String[])new String[]{"seedList"});
    private static final TObjectDoubleHashMap<WeightedRandom.Item> probabilities = new TObjectDoubleHashMap();

    public static void register(ItemStack seed, double probability) {
        int p = -Math.abs(XURandom.rand.nextInt() | 0x57EF);
        MinecraftForge.addGrassSeed((ItemStack)seed, (int)p);
        WeightedRandom.Item item = null;
        for (WeightedRandom.Item seedEntry : seedEntries) {
            if (seedEntry.field_76292_a != p) continue;
            if (item != null) {
                throw new RuntimeException("Unable to register seed entry");
            }
            item = seedEntry;
        }
        if (item == null) {
            throw new RuntimeException("Unable to register seed entry");
        }
        item.field_76292_a = 0;
        probabilities.put(item, probability);
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        this.recalcProb();
    }

    @SubscribeEvent
    public void onDrops(BlockEvent.HarvestDropsEvent event) {
        this.recalcProb();
    }

    public void recalcProb() {
        probabilities.forEachEntry((TObjectDoubleProcedure)new TObjectDoubleProcedure<WeightedRandom.Item>(){

            public boolean execute(WeightedRandom.Item a, double b) {
                a.field_76292_a = 0;
                return true;
            }
        });
        int i = 0;
        for (int i1 = 0; i1 < seedEntries.size(); ++i1) {
            WeightedRandom.Item entry = seedEntries.get(i1);
            i += entry.field_76292_a;
        }
        final int totalWeight = i;
        probabilities.forEachEntry((TObjectDoubleProcedure)new TObjectDoubleProcedure<WeightedRandom.Item>(){

            public boolean execute(WeightedRandom.Item a, double b) {
                double k = b * (double)totalWeight;
                int w = (int)Math.floor(k);
                double p = k - (double)w;
                if (XURandom.rand.nextDouble() < p) {
                    ++w;
                }
                a.field_76292_a = w;
                return true;
            }
        });
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)new RareSeedHandler());
    }
}

