/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.entity;

import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.ClientCallable;
import com.rwtema.extrautils2.entity.EntityBoomerang;
import com.rwtema.extrautils2.entity.RenderEntityBoomerang;
import com.rwtema.extrautils2.entity.RenderFactory;
import net.minecraft.entity.DataWatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Rotations;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class XUEntityManager {
    static int id = 0;

    public static void init() {
        XUEntityManager.registerEntity(EntityBoomerang.class, 64, 5, true);
        ExtraUtils2.proxy.run(new ClientCallable(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void runClient() {
                RenderFactory.registerRenderer(EntityBoomerang.class, RenderEntityBoomerang.class);
            }
        });
    }

    private static void registerEntity(Class<EntityBoomerang> clazz, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        String name = clazz.getSimpleName().toLowerCase();
        if (name.startsWith("entity")) {
            name = name.replace("entity", "");
        }
        EntityRegistry.registerModEntity(clazz, (String)name, (int)id, (Object)ExtraUtils2.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
        ++id;
    }

    public static void readDataWatchersFromNBT(DataWatcher watcher, NBTTagCompound tags) {
        block10: for (DataWatcher.WatchableObject watchableObject : watcher.func_75685_c()) {
            Object value;
            String key;
            int id = watchableObject.func_75672_a();
            if (id <= 4 || !tags.func_74764_b(key = "Watcher " + id)) continue;
            switch (watchableObject.func_75674_c()) {
                case 0: {
                    value = tags.func_74771_c(key);
                    break;
                }
                case 1: {
                    value = tags.func_74765_d(key);
                    break;
                }
                case 2: {
                    value = tags.func_74762_e(key);
                    break;
                }
                case 3: {
                    value = Float.valueOf(tags.func_74760_g(key));
                    break;
                }
                case 4: {
                    value = tags.func_74779_i(key);
                    break;
                }
                case 5: {
                    value = ItemStack.func_77949_a((NBTTagCompound)tags.func_74775_l(key));
                    break;
                }
                case 6: {
                    value = BlockPos.func_177969_a((long)tags.func_74763_f(key));
                    break;
                }
                case 7: {
                    value = new Rotations(tags.func_150295_c(key, 5));
                    break;
                }
                default: {
                    continue block10;
                }
            }
            watcher.func_75692_b(id, value);
        }
    }

    public static void writeDataWatchersToNBT(DataWatcher watcher, NBTTagCompound tags) {
        block10: for (DataWatcher.WatchableObject watchableObject : watcher.func_75685_c()) {
            NBTTagString value;
            int id = watchableObject.func_75672_a();
            if (id <= 4) continue;
            String key = "Watcher " + id;
            Object object = watchableObject.func_75669_b();
            switch (watchableObject.func_75674_c()) {
                case 0: {
                    value = new NBTTagByte(((Byte)object).byteValue());
                    break;
                }
                case 1: {
                    value = new NBTTagShort(((Short)object).shortValue());
                    break;
                }
                case 2: {
                    value = new NBTTagInt(((Integer)object).intValue());
                    break;
                }
                case 3: {
                    value = new NBTTagFloat(((Float)object).floatValue());
                    break;
                }
                case 4: {
                    value = new NBTTagString((String)object);
                    break;
                }
                case 5: {
                    NBTTagCompound tag = new NBTTagCompound();
                    if (object != null) {
                        ((ItemStack)object).func_77955_b(tag);
                    }
                    value = tag;
                    break;
                }
                case 6: {
                    value = new NBTTagLong(((BlockPos)object).func_177986_g());
                    break;
                }
                case 7: {
                    Rotations rotations = (Rotations)object;
                    value = rotations.func_179414_a();
                    break;
                }
                default: {
                    continue block10;
                }
            }
            tags.func_74782_a(key, (NBTBase)value);
        }
    }
}

