/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.entity;

import com.google.common.collect.Iterables;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.entity.XUEntityManager;
import com.rwtema.extrautils2.utils.helpers.PlayerHelper;
import io.netty.buffer.ByteBuf;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2BPacketChangeGameState;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class EntityBoomerang
extends Entity
implements IEntityAdditionalSpawnData,
IProjectile {
    public static final WeakHashMap<Object, WeakReference<EntityBoomerang>> boomerangOwners = new WeakHashMap();
    public static final WeakHashMap<Object, WeakReference<EntityBoomerang>> boomerangOwnersClient = ExtraUtils2.proxy.nullifyOnServer(new WeakHashMap());
    private static final int DATAWATCHER_OUT_FLAG = 16;
    private static final int DATAWATCHER_HOME_X = 17;
    private static final int DATAWATCHER_HOME_Y = 18;
    private static final int DATAWATCHER_HOME_Z = 19;
    private static final int DATAWATCHER_OWNER_ID = 20;
    int flyTime;
    UUID owner = null;

    public EntityBoomerang(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
        this.field_70145_X = true;
        this.field_70155_l = 10.0;
    }

    public EntityBoomerang(World worldIn, double x, double y, double z, Object owner) {
        this(worldIn);
        this.func_70012_b(x, y, z, 0.0f, 0.0f);
        this.setHome((float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v);
        if (owner != null) {
            EntityBoomerang.getBoomerangOwners(worldIn).put(owner, new WeakReference<EntityBoomerang>(this));
        }
    }

    public EntityBoomerang(World worldIn, EntityLivingBase shooter) {
        this(worldIn);
        if (!(shooter instanceof EntityPlayer) || PlayerHelper.isPlayerReal((EntityPlayer)shooter)) {
            this.owner = shooter.func_110124_au();
            if (worldIn.field_72995_K) {
                boomerangOwnersClient.put(shooter, new WeakReference<EntityBoomerang>(this));
            } else {
                boomerangOwners.put(shooter, new WeakReference<EntityBoomerang>(this));
            }
        }
        Vec3 eyeVec = this.getEyeVec((Entity)shooter);
        this.func_70012_b(eyeVec.field_72450_a, eyeVec.field_72448_b, eyeVec.field_72449_c, shooter.field_70177_z, shooter.field_70125_A);
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 1.25f, 0.0f);
        this.setHome((float)eyeVec.field_72450_a, (float)eyeVec.field_72448_b, (float)eyeVec.field_72449_c);
    }

    public static WeakHashMap<Object, WeakReference<EntityBoomerang>> getBoomerangOwners(World worldIn) {
        return worldIn.field_72995_K ? boomerangOwnersClient : boomerangOwners;
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70126_B = this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 180.0 / Math.PI);
    }

    public void setHome(float x, float y, float z) {
        this.field_70180_af.func_75692_b(17, (Object)Float.valueOf(x));
        this.field_70180_af.func_75692_b(18, (Object)Float.valueOf(y));
        this.field_70180_af.func_75692_b(19, (Object)Float.valueOf(z));
    }

    public Vec3 getHome() {
        return new Vec3((double)this.field_70180_af.func_111145_d(17), (double)this.field_70180_af.func_111145_d(18), (double)this.field_70180_af.func_111145_d(19));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70126_B = this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(18, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(19, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(20, (Object)-1);
    }

    protected void func_70037_a(NBTTagCompound tag) {
        XUEntityManager.readDataWatchersFromNBT(this.field_70180_af, tag);
        this.owner = tag.func_74764_b("Target_UUIDL") ? new UUID(tag.func_74763_f("Target_UUIDU"), tag.func_74763_f("Target_UUIDL")) : null;
    }

    protected void func_70014_b(NBTTagCompound tag) {
        XUEntityManager.writeDataWatchersToNBT(this.field_70180_af, tag);
        if (this.owner != null) {
            tag.func_74772_a("Target_UUIDL", this.owner.getLeastSignificantBits());
            tag.func_74772_a("Target_UUIDU", this.owner.getMostSignificantBits());
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        Entity owner = this.getOwner();
        boolean isRemote = this.field_70170_p.field_72995_K;
        Vec3 dest = this.calcTargetVec();
        ++this.flyTime;
        byte flag = this.field_70180_af.func_75683_a(16);
        Vec3 destDiff = dest.func_178786_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        float d = MathHelper.func_76133_a((double)(destDiff.field_72450_a * destDiff.field_72450_a + destDiff.field_72448_b * destDiff.field_72448_b + destDiff.field_72449_c * destDiff.field_72449_c));
        destDiff = destDiff.func_72432_b();
        double ACCELERATION = (double)this.flyTime * 0.001 + (double)flag * 0.05;
        if ((double)d < 1.0E-4 && this.flyTime > 25 || ACCELERATION > 1.0) {
            this.setMeDead();
            return;
        }
        this.field_70159_w *= 1.0 - ACCELERATION;
        this.field_70181_x *= 1.0 - ACCELERATION;
        this.field_70179_y *= 1.0 - ACCELERATION;
        this.field_70159_w += destDiff.field_72450_a * ACCELERATION;
        this.field_70181_x += destDiff.field_72448_b * ACCELERATION;
        this.field_70179_y += destDiff.field_72449_c * ACCELERATION;
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 180.0 / Math.PI);
        if ((this.flyTime > 5 || flag != 0) && MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y)) >= d) {
            this.func_70012_b(dest.field_72450_a, dest.field_72448_b, dest.field_72449_c, this.field_70177_z, this.field_70125_A);
            this.setMeDead();
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        } else {
            HashSet prevPosSet = new HashSet();
            Iterables.addAll(prevPosSet, this.getNeighbourBlocks());
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            for (BlockPos newPos : this.getNeighbourBlocks()) {
                IBlockState blockState;
                Block block;
                if (prevPosSet.contains(newPos) || (block = (blockState = this.field_70170_p.func_180495_p(newPos)).func_177230_c()) != Blocks.field_150430_aB && block != Blocks.field_150471_bO && block != Blocks.field_150442_at) continue;
                block.func_180639_a(this.field_70170_p, newPos, blockState, (EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.field_70170_p)), EnumFacing.DOWN, 0.0f, 0.0f, 0.0f);
            }
        }
        if (flag == 0) {
            for (int k = 0; k < 4; ++k) {
                double t = (double)k / 4.0;
                double dx = this.field_70165_t - this.field_70169_q;
                double dy = this.field_70163_u - this.field_70167_r;
                double dz = this.field_70161_v - this.field_70166_s;
                this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT, this.field_70165_t + dx * t, this.field_70163_u + dy * t, this.field_70161_v + dz * t, -dx, -dy + 0.2, -dz, new int[0]);
            }
        }
        Vec3 startVec = new Vec3(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3 endVec = new Vec3(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        MovingObjectPosition movingobjectposition = this.field_70170_p.func_147447_a(startVec, endVec, false, true, false);
        if (!isRemote) {
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double d0 = 0.0;
            for (Entity e : list) {
                double d1;
                if (e instanceof EntityItem || e instanceof EntityXPOrb) {
                    if (e.field_70154_o != null) continue;
                    this.addItem(e);
                    continue;
                }
                if (flag == 1 || !e.func_70067_L() || this.isOwner(e)) continue;
                if (e instanceof EntityPlayer) {
                    EntityPlayer entityplayer = (EntityPlayer)e;
                    if (entityplayer.field_71075_bZ.field_75102_a || owner instanceof EntityPlayer && !((EntityPlayer)owner).func_96122_a(entityplayer)) continue;
                }
                float f1 = 0.3f;
                AxisAlignedBB axisAlignedBB = e.func_174813_aQ().func_72314_b((double)f1, (double)f1, (double)f1);
                MovingObjectPosition mop = axisAlignedBB.func_72327_a(startVec, endVec);
                if (mop == null || !((d1 = startVec.func_72436_e(mop.field_72307_f)) < d0) && d0 != 0.0) continue;
                entity = e;
                d0 = d1;
            }
            if (flag == 0 && entity != null && entity.func_70097_a((DamageSource)new DamageSourceBoomerang(this, owner), 4.0f) && entity instanceof EntityLivingBase && !(entity instanceof EntityEnderman)) {
                this.field_70179_y = 0.0;
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
                this.field_70180_af.func_75692_b(16, (Object)1);
                EntityLivingBase entitylivingbase = (EntityLivingBase)entity;
                if (owner instanceof EntityLivingBase) {
                    EnchantmentHelper.func_151384_a((EntityLivingBase)entitylivingbase, (Entity)owner);
                    EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)owner), (Entity)entitylivingbase);
                }
                entitylivingbase.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 60, 0));
                if (owner != null && entity != owner && entity instanceof EntityPlayer && owner instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)owner).field_71135_a.func_147359_a((Packet)new S2BPacketChangeGameState(6, 0.0f));
                }
            }
        }
        if (movingobjectposition != null) {
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
            this.field_70180_af.func_75692_b(16, (Object)1);
        }
    }

    public void addItem(Entity entity) {
        if (this.field_70128_L || entity == null || entity.field_70128_L) {
            return;
        }
        EntityItem entityItem = entity instanceof EntityItem ? (EntityItem)entity : null;
        EntityXPOrb xp = entity instanceof EntityXPOrb ? (EntityXPOrb)entity : null;
        EntityBoomerang parent = this;
        while (parent.field_70153_n != null) {
            parent = parent.field_70153_n;
            Entity checkEntity = parent;
            if (entityItem != null && checkEntity instanceof EntityItem && this.combine(entityItem, (EntityItem)checkEntity)) {
                this.field_70170_p.func_72900_e((Entity)entityItem);
                return;
            }
            if (xp == null || !(checkEntity instanceof EntityXPOrb)) continue;
            ((EntityXPOrb)checkEntity).field_70530_e += xp.field_70530_e;
            this.field_70170_p.func_72900_e((Entity)xp);
            return;
        }
        entity.func_70078_a((Entity)parent);
    }

    public boolean combine(EntityItem adding, EntityItem current) {
        if (adding == current) {
            return true;
        }
        if (!adding.func_70089_S() || !current.func_70089_S()) {
            return true;
        }
        ItemStack addingStack = adding.func_92059_d();
        ItemStack currentStack = current.func_92059_d();
        if (addingStack == null || currentStack == null) {
            return true;
        }
        if (!ItemHandlerHelper.canItemStacksStack((ItemStack)addingStack, (ItemStack)currentStack)) {
            return false;
        }
        int allowedAmount = currentStack.func_77976_d() - currentStack.field_77994_a;
        if (allowedAmount == 0) {
            return false;
        }
        int toAdd = addingStack.field_77994_a;
        if (toAdd <= allowedAmount) {
            addingStack.field_77994_a -= toAdd;
            adding.func_92058_a(addingStack);
            currentStack.field_77994_a += toAdd;
            current.func_92058_a(currentStack);
            return true;
        }
        addingStack.field_77994_a -= allowedAmount;
        adding.func_92058_a(addingStack);
        currentStack.field_77994_a += allowedAmount;
        current.func_92058_a(currentStack);
        return false;
    }

    public void setMeDead() {
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        if (this.field_70153_n != null) {
            Entity riddenByEntity = this.field_70153_n;
            while (riddenByEntity != null) {
                riddenByEntity.func_70078_a(null);
                riddenByEntity.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, riddenByEntity.field_70177_z, riddenByEntity.field_70125_A);
                riddenByEntity = riddenByEntity.field_70153_n;
            }
        }
        if (this.field_70154_o != null) {
            this.func_70078_a(null);
        }
        this.field_70170_p.func_72900_e((Entity)this);
    }

    @Nonnull
    public HashSet<BlockPos> getNeighbourBlocksSet() {
        Iterable<BlockPos> allInBox = this.getNeighbourBlocks();
        HashSet<BlockPos> pos = new HashSet<BlockPos>();
        Iterables.addAll(pos, allInBox);
        return pos;
    }

    @Nonnull
    public Iterable<BlockPos> getNeighbourBlocks() {
        AxisAlignedBB expand = this.func_174813_aQ();
        return BlockPos.func_177980_a((BlockPos)new BlockPos(MathHelper.func_76128_c((double)expand.field_72340_a), MathHelper.func_76128_c((double)expand.field_72338_b), MathHelper.func_76128_c((double)expand.field_72339_c)), (BlockPos)new BlockPos(MathHelper.func_76143_f((double)expand.field_72336_d), MathHelper.func_76143_f((double)expand.field_72337_e), MathHelper.func_76143_f((double)expand.field_72334_f)));
    }

    public boolean isOwner(Entity entity) {
        if (this.field_70170_p.field_72995_K) {
            int i = this.field_70180_af.func_75679_c(20);
            return entity.func_145782_y() == i;
        }
        return this.owner != null && this.owner.equals(entity.func_110124_au());
    }

    public Entity getOwner() {
        WeakReference<EntityBoomerang> reference;
        WeakHashMap<Object, WeakReference<EntityBoomerang>> boomerangOwners;
        Entity entity;
        if (this.field_70170_p.field_72995_K) {
            int i = this.field_70180_af.func_75679_c(20);
            entity = this.field_70170_p.func_73045_a(i);
            boomerangOwners = boomerangOwnersClient;
        } else {
            if (this.owner == null) {
                return null;
            }
            entity = ((WorldServer)this.field_70170_p).func_175733_a(this.owner);
            boomerangOwners = EntityBoomerang.boomerangOwners;
        }
        if (entity != null && ((reference = boomerangOwners.get(entity)) == null || reference.get() == null)) {
            boomerangOwners.put(entity, new WeakReference<EntityBoomerang>(this));
        }
        return entity;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.field_70170_p.field_72995_K) {
            boomerangOwnersClient.remove(this.getOwner());
        } else {
            boomerangOwners.remove(this.getOwner());
        }
    }

    public Vec3 calcTargetVec() {
        if (this.field_70170_p.field_72995_K) {
            Entity entity;
            int i = this.field_70180_af.func_75679_c(20);
            if (i != -1 && (entity = this.field_70170_p.func_73045_a(i)) != null) {
                return this.getEyeVec(entity);
            }
        } else {
            Entity entity;
            if (this.owner != null && (entity = ((WorldServer)this.field_70170_p).func_175733_a(this.owner)) != null) {
                this.field_70180_af.func_75692_b(20, (Object)entity.func_145782_y());
                Vec3 eyeVec = this.getEyeVec(entity);
                this.setHome((float)eyeVec.field_72450_a, (float)eyeVec.field_72448_b, (float)eyeVec.field_72449_c);
                return eyeVec;
            }
            this.field_70180_af.func_75692_b(20, (Object)-1);
        }
        return this.getHome();
    }

    @Nonnull
    public Vec3 getEyeVec(Entity entity) {
        return new Vec3(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e() * 0.8, entity.field_70161_v);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.flyTime);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.flyTime = additionalData.readInt();
    }

    public class DamageSourceBoomerang
    extends EntityDamageSourceIndirect {
        public DamageSourceBoomerang(EntityBoomerang indirectEntityIn, Entity owner) {
            super("boomerang", (Entity)indirectEntityIn, owner);
        }
    }
}

