/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.crafting.jei;

import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.crafting.EnchantRecipe;
import com.rwtema.extrautils2.crafting.jei.JEIRadar;
import com.rwtema.extrautils2.crafting.jei.JEIVanillaCraftingRecipeHandler;
import com.rwtema.extrautils2.crafting.jei.ResonatorHandler;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.DynamicWindow;
import com.rwtema.extrautils2.tile.TileResonator;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.LogHelper;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IItemListOverlay;
import mezz.jei.api.IItemRegistry;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;

@JEIPlugin
public class XUJEIPlugin
implements IModPlugin {
    public static IJeiHelpers jeiHelpers;
    public static IRecipeRegistry recipeRegistry;

    public XUJEIPlugin() {
        LogHelper.info("Extra Utilities 2 JEI Plugin - ACTIVATE!", new Object[0]);
    }

    public void onJeiHelpersAvailable(IJeiHelpers jeiHelpers) {
        XUJEIPlugin.jeiHelpers = jeiHelpers;
    }

    public void onItemRegistryAvailable(IItemRegistry itemRegistry) {
        if (XU2Entries.itemFakeCopy.isActive()) {
            jeiHelpers.getItemBlacklist().addItemToBlacklist(XU2Entries.itemFakeCopy.newStack(1, Short.MAX_VALUE));
        }
    }

    public void register(@Nonnull IModRegistry registry) {
        if (XU2Entries.sunCrystal.isActive()) {
            registry.addDescription(XU2Entries.sunCrystal.newStack(1), new String[]{Lang.translate("Craft an empty Sun Crystal first, then throw the crystal on the ground in direct sunlight.")});
        }
        if (XU2Entries.blockEnderLilly.isActive()) {
            registry.addDescription(XU2Entries.blockEnderLilly.newStack(1), new String[]{Lang.translate("Found in dungeon chests.")});
        }
        if (XU2Entries.blockRedOrchid.isActive()) {
            registry.addDescription(XU2Entries.blockRedOrchid.newStack(1), new String[]{Lang.translate("Found in dungeon chests.")});
        }
        if (XU2Entries.resonator.isActive()) {
            ResonatorHandler resonator = new ResonatorHandler();
            registry.addRecipeCategories(new IRecipeCategory[]{resonator});
            registry.addRecipeHandlers(new IRecipeHandler[]{resonator});
            registry.addRecipes(TileResonator.resonatorRecipes);
        }
        registry.addRecipeHandlers(new IRecipeHandler[]{new JEIVanillaCraftingRecipeHandler<EnchantRecipe>(EnchantRecipe.class)});
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new IAdvancedGuiHandler<DynamicGui>(){

            @Nonnull
            public Class<DynamicGui> getGuiContainerClass() {
                return DynamicGui.class;
            }

            @Nullable
            public List<Rectangle> getGuiExtraAreas(DynamicGui gui) {
                ArrayList<Rectangle> rectangles = new ArrayList<Rectangle>();
                for (DynamicWindow window : gui.container.getWindows()) {
                    rectangles.add(new Rectangle(gui.field_147003_i + window.x, gui.field_147009_r + window.y, window.w, window.h));
                }
                return rectangles;
            }
        }});
    }

    public void onRecipeRegistryAvailable(@Nonnull IRecipeRegistry recipeRegistry) {
        XUJEIPlugin.recipeRegistry = recipeRegistry;
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
        IItemListOverlay itemListOverlay = jeiRuntime.getItemListOverlay();
        JEIRadar.register(itemListOverlay);
    }
}

