/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.crafting.jei;

import com.google.common.collect.Lists;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.crafting.jei.XUJEIPlugin;
import com.rwtema.extrautils2.tile.TileResonator;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

class ResonatorHandler
implements IRecipeHandler<TileResonator.ResonatorRecipe>,
IRecipeCategory {
    public static final String uid = "ExtraUtils2.resonator";
    public static final int recipeWidth = 116;
    public static final int BETWEEN_DIST = 60;
    public static final int slotX1 = 79;
    public static final int slotX0 = 19;
    IDrawable slotDrawable = XUJEIPlugin.jeiHelpers.getGuiHelper().getSlotDrawable();
    IDrawable background = XUJEIPlugin.jeiHelpers.getGuiHelper().createBlankDrawable(116, 54);

    ResonatorHandler() {
    }

    @Nonnull
    public Class<TileResonator.ResonatorRecipe> getRecipeClass() {
        return TileResonator.ResonatorRecipe.class;
    }

    @Nonnull
    public String getRecipeCategoryUid() {
        return uid;
    }

    @Nonnull
    public IRecipeWrapper getRecipeWrapper(@Nonnull TileResonator.ResonatorRecipe recipe) {
        final TileResonator.ResonatorRecipe resonatorRecipe = recipe;
        return new IRecipeWrapper(){
            String energyString;
            {
                this.energyString = Lang.translateArgs("%s GP", StringHelper.niceFormat((double)resonatorRecipe.energy / 100.0));
            }

            public List getInputs() {
                return Lists.newArrayList((Object[])new ItemStack[]{resonatorRecipe.input});
            }

            public List getOutputs() {
                return Lists.newArrayList((Object[])new ItemStack[]{resonatorRecipe.output});
            }

            public List<FluidStack> getFluidInputs() {
                return null;
            }

            public List<FluidStack> getFluidOutputs() {
                return null;
            }

            public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight) {
                int stringWidth = minecraft.field_71466_p.func_78256_a(this.energyString);
                minecraft.field_71466_p.func_78279_b(this.energyString, Math.max(19, (recipeWidth - stringWidth) / 2), 4, 60, Color.gray.getRGB());
            }

            public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            }

            public void drawAnimations(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight) {
            }

            @Nullable
            public List<String> getTooltipStrings(int mouseX, int mouseY) {
                return null;
            }

            public boolean handleClick(@Nonnull Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
                return false;
            }
        };
    }

    public boolean isRecipeValid(@Nonnull TileResonator.ResonatorRecipe recipe) {
        return true;
    }

    @Nonnull
    public String getUid() {
        return uid;
    }

    @Nonnull
    public String getTitle() {
        return Lang.getItemName((Block)XU2Entries.resonator.value);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.slotDrawable.draw(minecraft, 19, 0);
        this.slotDrawable.draw(minecraft, 79, 0);
    }

    public void drawAnimations(@Nonnull Minecraft minecraft) {
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 19, 0);
        guiItemStacks.setFromRecipe(0, recipeWrapper.getInputs());
        guiItemStacks.init(1, false, 79, 0);
        guiItemStacks.setFromRecipe(1, recipeWrapper.getOutputs());
    }
}

