/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.chunkloading;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.mojang.authlib.GameProfile;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.chunkloading.ChunkLoaderLoginTimes;
import com.rwtema.extrautils2.tile.TileChunkLoader;
import com.rwtema.extrautils2.utils.helpers.DescribeHelper;
import com.rwtema.extrautils2.utils.helpers.NBTHelper;
import gnu.trove.list.array.TIntArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class XUChunkLoaderManager
implements ForgeChunkManager.LoadingCallback,
ForgeChunkManager.PlayerOrderedLoadingCallback {
    public static final HashMultimap<World, TileChunkLoader> chunkLoaders = HashMultimap.create();
    public static XUChunkLoaderManager instance = new XUChunkLoaderManager();
    public static boolean dirty = false;
    private static HashMap<World, HashMap<GameProfile, ForgeChunkManager.Ticket>> playerTickets = new HashMap();

    public static void init() {
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)ExtraUtils2.instance, (ForgeChunkManager.LoadingCallback)instance);
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(TileChunkLoader loader) {
        HashMultimap<World, TileChunkLoader> hashMultimap = chunkLoaders;
        synchronized (hashMultimap) {
            ForgeChunkManager.Ticket playerTicket;
            GameProfile profile = loader.getProfile();
            if (profile != null && (playerTicket = instance.getPlayerTicket(profile, loader.world())) != null) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)playerTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(loader.func_174877_v().func_177958_n() >> 4, loader.func_174877_v().func_177952_p() >> 4));
            }
            chunkLoaders.put((Object)loader.world(), (Object)loader);
            dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(TileChunkLoader loader) {
        HashMultimap<World, TileChunkLoader> hashMultimap = chunkLoaders;
        synchronized (hashMultimap) {
            chunkLoaders.remove((Object)loader.world(), (Object)loader);
            dirty = true;
        }
    }

    public static void clear() {
        chunkLoaders.clear();
        playerTickets.clear();
        ChunkLoaderLoginTimes.instance.loaded = false;
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (dirty) {
            this.reloadChunkLoaders();
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        playerTickets.remove(event.world);
        chunkLoaders.removeAll((Object)event.world);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadChunkLoaders() {
        HashMultimap<World, TileChunkLoader> hashMultimap = chunkLoaders;
        synchronized (hashMultimap) {
            ForgeChunkManager.Ticket ticket2;
            dirty = false;
            HashMultimap worldChunks = HashMultimap.create();
            HashMultimap toUnload = HashMultimap.create();
            HashMultimap loaded = HashMultimap.create();
            HashMultimap toAdd = HashMultimap.create();
            for (HashMap<GameProfile, ForgeChunkManager.Ticket> map : playerTickets.values()) {
                for (ForgeChunkManager.Ticket ticket2 : map.values()) {
                    ImmutableSet chunkList = ticket2.getChunkList();
                    for (ChunkCoordIntPair pair : chunkList) {
                        ticket2.world.func_180495_p(pair.func_180619_a(20));
                    }
                    worldChunks.putAll((Object)ticket2.world, (Iterable)chunkList);
                    toUnload.putAll((Object)ticket2, (Iterable)chunkList);
                    loaded.putAll((Object)ticket2, (Iterable)chunkList);
                }
            }
            Iterator iterator = chunkLoaders.values().iterator();
            while (iterator.hasNext()) {
                TileChunkLoader chunkLoader = (TileChunkLoader)iterator.next();
                if (chunkLoader.func_145837_r()) {
                    dirty = true;
                    iterator.remove();
                }
                if (!chunkLoader.isLoaded()) {
                    dirty = true;
                }
                GameProfile profile = chunkLoader.getProfile();
                if (!chunkLoader.active || profile == null || !ChunkLoaderLoginTimes.instance.isValid(profile) || (ticket2 = this.getPlayerTicket(profile, chunkLoader.world())) == null) continue;
                for (ChunkCoordIntPair coordIntPair : chunkLoader.getChunkCoords()) {
                    worldChunks.remove((Object)chunkLoader.world(), (Object)coordIntPair);
                    toUnload.remove((Object)ticket2, (Object)coordIntPair);
                    if (loaded.containsEntry((Object)ticket2, (Object)coordIntPair)) continue;
                    toAdd.put((Object)ticket2, (Object)coordIntPair);
                }
            }
            for (HashMap<GameProfile, ForgeChunkManager.Ticket> map : playerTickets.values()) {
                Iterator<ForgeChunkManager.Ticket> iterator2 = map.values().iterator();
                while (iterator2.hasNext()) {
                    ticket2 = iterator2.next();
                    for (ChunkCoordIntPair pair : toUnload.get((Object)ticket2)) {
                        ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket2, (ChunkCoordIntPair)pair);
                    }
                    for (ChunkCoordIntPair pair : toAdd.get((Object)ticket2)) {
                        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket2, (ChunkCoordIntPair)pair);
                    }
                    if (ticket2.getChunkList().isEmpty()) {
                        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket2);
                        iterator2.remove();
                        continue;
                    }
                    TIntArrayList x = new TIntArrayList();
                    TIntArrayList z = new TIntArrayList();
                    for (ChunkCoordIntPair chunkCoordIntPair : ticket2.getChunkList()) {
                        x.add(chunkCoordIntPair.field_77276_a);
                        z.add(chunkCoordIntPair.field_77275_b);
                    }
                    ticket2.getModData().func_74783_a("x", x.toArray());
                    ticket2.getModData().func_74783_a("z", z.toArray());
                }
            }
        }
    }

    public ForgeChunkManager.Ticket getPlayerTicket(GameProfile profile, World world) {
        ForgeChunkManager.Ticket ticket;
        HashMap<Object, Object> gameProfileTicketHashMap = playerTickets.get(world);
        if (gameProfileTicketHashMap == null) {
            gameProfileTicketHashMap = new HashMap();
            playerTickets.put(world, gameProfileTicketHashMap);
        }
        if ((ticket = gameProfileTicketHashMap.get(profile)) == null) {
            ticket = ForgeChunkManager.requestPlayerTicket((Object)ExtraUtils2.instance, (String)profile.getName(), (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            NBTTagCompound tag = ticket.getModData();
            tag.func_74778_a("Name", profile.getName());
            UUID id = profile.getId();
            if (id != null) {
                tag.func_74772_a("UUIDL", id.getLeastSignificantBits());
                tag.func_74772_a("UUIDU", id.getMostSignificantBits());
            }
            gameProfileTicketHashMap.put(profile, ticket);
        }
        return ticket;
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        dirty = true;
        HashMap<GameProfile, ForgeChunkManager.Ticket> cache = new HashMap<GameProfile, ForgeChunkManager.Ticket>();
        playerTickets.put(world, cache);
        for (ForgeChunkManager.Ticket ticket : tickets) {
            int[] z;
            NBTTagCompound modData = ticket.getModData();
            GameProfile profile = NBTHelper.profileFromNBT(modData);
            cache.put(profile, ticket);
            int[] x = modData.func_74759_k("x");
            if (x.length != (z = modData.func_74759_k("z")).length) continue;
            for (int i = 0; i < x.length; ++i) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(x[i], z[i]));
                Chunk chunk = world.func_72964_e(x[i], z[i]);
            }
        }
    }

    public void getDebug(List<String> info) {
        DescribeHelper.addDescription(info, "Chunk Loaders", chunkLoaders);
        DescribeHelper.addDescription(info, "Player Tickets", playerTickets);
    }

    public ListMultimap<String, ForgeChunkManager.Ticket> playerTicketsLoaded(ListMultimap<String, ForgeChunkManager.Ticket> tickets, World world) {
        return tickets;
    }
}

