/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.chunkloading;

import com.mojang.authlib.GameProfile;
import com.rwtema.extrautils2.backend.save.SaveModule;
import com.rwtema.extrautils2.chunkloading.XUChunkLoaderManager;
import com.rwtema.extrautils2.utils.helpers.NBTHelper;
import gnu.trove.map.hash.TObjectLongHashMap;
import gnu.trove.procedure.TObjectLongProcedure;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class ChunkLoaderLoginTimes
extends SaveModule {
    private static final long MAX_WAIT_TIME = 604800000L;
    public static ChunkLoaderLoginTimes instance;
    static TObjectLongHashMap<GameProfile> loginTimes;
    boolean loaded = false;

    public ChunkLoaderLoginTimes() {
        super("ChunkLoaderData");
    }

    public boolean isValid(GameProfile profile) {
        if (!this.loaded) {
            return true;
        }
        for (EntityPlayerMP playerMP : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            if (!playerMP.func_146103_bH().equals((Object)profile)) continue;
            loginTimes.put((Object)profile, System.currentTimeMillis());
            return true;
        }
        long l = System.currentTimeMillis() - loginTimes.get((Object)profile);
        return l < 604800000L;
    }

    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        loginTimes.put((Object)event.player.func_146103_bH(), System.currentTimeMillis());
        XUChunkLoaderManager.dirty = true;
        this.markDirty();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        loginTimes.clear();
        NBTTagList loginTimes = nbt.func_150295_c("LoginTimes", 10);
        for (int i = 0; i < loginTimes.func_74745_c(); ++i) {
            NBTTagCompound loginTime = loginTimes.func_150305_b(i);
            GameProfile profile = NBTHelper.profileFromNBT(loginTime);
            if (profile == null) continue;
            ChunkLoaderLoginTimes.loginTimes.put((Object)profile, loginTime.func_74763_f("LoginTime"));
        }
        this.loaded = true;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        final NBTTagList tagList = new NBTTagList();
        loginTimes.forEachEntry((TObjectLongProcedure)new TObjectLongProcedure<GameProfile>(){

            public boolean execute(GameProfile a, long b) {
                NBTTagCompound t = NBTHelper.proifleToNBT(a);
                t.func_74772_a("LoginTime", b);
                tagList.func_74742_a((NBTBase)t);
                return true;
            }
        });
        nbt.func_74782_a("LoginTimes", (NBTBase)tagList);
    }

    @Override
    public void reset() {
        loginTimes.clear();
    }

    static {
        loginTimes = new TObjectLongHashMap();
        instance = new ChunkLoaderLoginTimes();
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }
}

