/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.book;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.entries.Entry;
import com.rwtema.extrautils2.backend.entries.EntryHandler;
import com.rwtema.extrautils2.utils.LogHelper;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.IResource;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;

public class BookHandler {
    public static final Book book;

    public static ItemStack newStack() {
        if (book == null) {
            return null;
        }
        NBTTagCompound tags = new NBTTagCompound();
        ArrayList<NBTTagString> pages = new ArrayList<NBTTagString>();
        FontRenderer fontRendererObj = Minecraft.func_71410_x().field_71466_p;
        TIntObjectHashMap contents = new TIntObjectHashMap();
        for (Book.Page page : BookHandler.book.pages) {
            StringBuilder builder = new StringBuilder();
            String title = null;
            if (page.entry != null) {
                ItemStack itemStack = page.entry.newStack(1, page.meta);
                title = itemStack != null ? itemStack.func_82833_r() : page.entry.name;
            }
            if (page.title != null) {
                title = page.title;
            }
            if (title != null) {
                contents.put(pages.size(), (Object)title);
                builder.append(EnumChatFormatting.UNDERLINE).append(title).append(EnumChatFormatting.RESET).append("\n\n");
            }
            builder.append(page.text);
            String string = builder.toString();
            List strings = fontRendererObj.func_78271_c(string, 116);
            StringBuilder builder1 = new StringBuilder();
            int k = 0;
            for (String s : strings) {
                builder1.append(s).append('\n');
                if (++k < 13) continue;
                pages.add(new NBTTagString(builder1.toString()));
                builder1 = new StringBuilder();
                k = 0;
            }
            if (k == 0) continue;
            pages.add(new NBTTagString(builder1.toString()));
        }
        NBTTagList pageList = new NBTTagList();
        pageList.func_74742_a((NBTBase)new NBTTagString("Extra Utilities 2\nManual\n(temp GUI stand in)"));
        int offset = 3 + contents.size() / 13;
        int[] keys = contents.keys();
        Arrays.sort(keys);
        StringBuilder builder = new StringBuilder("Table of Contents\n\n");
        int k = 2;
        for (int key : keys) {
            String line = (String)contents.get(key);
            int a = key + offset;
            while (fontRendererObj.func_78271_c(line + " " + a, 116).size() > 1) {
                line = line.substring(0, line.length() - 1);
            }
            line = line + " ";
            while (fontRendererObj.func_78271_c(line + " " + a, 116).size() == 1) {
                line = line + " ";
            }
            line = line + a;
            builder.append(line).append('\n');
            if (++k < 13) continue;
            k = 0;
            pageList.func_74742_a((NBTBase)new NBTTagString(builder.toString()));
            builder = new StringBuilder();
        }
        if (k != 0) {
            pageList.func_74742_a((NBTBase)new NBTTagString(builder.toString()));
        }
        for (NBTTagString page : pages) {
            pageList.func_74742_a((NBTBase)page);
        }
        tags.func_74782_a("pages", (NBTBase)pageList);
        tags.func_74778_a("title", BookHandler.book.title);
        tags.func_74778_a("author", "RWTema");
        ItemStack stack = new ItemStack(Items.field_151164_bB);
        stack.func_77982_d(tags);
        return stack;
    }

    static {
        Book b;
        Gson DES = new GsonBuilder().registerTypeAdapter(Entry.class, (Object)new EntryDeserializer()).create();
        try {
            IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("extrautils2", "lang/book/en_US.json"));
            InputStreamReader reader = new InputStreamReader(resource.func_110527_b());
            b = (Book)DES.fromJson((Reader)reader, Book.class);
        }
        catch (IOException e) {
            b = null;
        }
        book = b;
        if (ExtraUtils2.deobf_folder && book != null) {
            HashSet entries = Sets.newHashSet(EntryHandler.entries);
            for (Book.Page page : BookHandler.book.pages) {
                entries.remove(page.entry);
            }
            for (Entry entry : entries) {
                LogHelper.info("Missing Book Data: " + entry.name, new Object[0]);
            }
            LogHelper.info("Missing Book Count: ", entries.size());
        }
    }

    public static class EntryDeserializer
    implements JsonDeserializer<Entry> {
        public Entry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String asString = json.getAsString().toLowerCase();
            Entry entry = EntryHandler.entryHashMap.get(asString);
            if (entry != null) {
                return entry;
            }
            for (Map.Entry<String, Entry> e : EntryHandler.entryHashMap.entrySet()) {
                String key = e.getKey().toLowerCase();
                if (!key.contains(asString) && !asString.contains(key)) continue;
                return e.getValue();
            }
            return null;
        }
    }

    public static class Book {
        public String id;
        public String title;
        public List<Page> pages;

        public static class Page {
            String title;
            @Nullable
            Entry entry;
            String text;
            int meta = 0;
        }
    }
}

