/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.BoxRotatable;
import com.rwtema.extrautils2.backend.model.BoxSingleQuad;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.backend.model.UV;
import com.rwtema.extrautils2.tile.TileSpotlight;
import com.rwtema.extrautils2.utils.Lang;
import java.util.List;
import java.util.Random;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

public class BlockSpotlight
extends XUBlock {
    public static final WeakHashMap<TileEntity, BoxModel> worldModelCache = new WeakHashMap();
    public static final WeakHashMap<TileEntity, BoxModel> renderModelCache = new WeakHashMap(1);
    BoxModel invCache;

    public BlockSpotlight() {
        super(Material.field_151576_e);
    }

    @Override
    protected XUBlockStateCreator createBlockState() {
        return new XUBlockStateCreator((XUBlock)this, new IProperty[]{XUBlockStateCreator.ROTATION_ALL});
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.xuBlockState.getStateFromDropMeta(meta).func_177226_a((IProperty)XUBlockStateCreator.ROTATION_ALL, (Comparable)facing);
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        super.registerTextures();
        Textures.register("spotlight", "spotlight_stand", "gradient_64");
    }

    public BoxModel getStandModel(EnumFacing facing) {
        BoxModel model = new BoxModel();
        model.addBoxI(2, 0, 2, 14, 1, 14, "spotlight_stand");
        Box stand = model.addBox(0.46875f, 0.0625f, 0.46875f, 0.53125f, 0.5f, 0.53125f);
        model.setTexture("spotlight_stand");
        stand.setTextureBounds(new float[][]{{15.0f, 15.0f, 16.0f, 16.0f}, {15.0f, 15.0f, 16.0f, 16.0f}, {15.0f, 8.0f, 16.0f, 16.0f}, {15.0f, 8.0f, 16.0f, 16.0f}, {15.0f, 8.0f, 16.0f, 16.0f}, {15.0f, 8.0f, 16.0f, 16.0f}});
        model.rotateToSide(facing.func_176734_d());
        return model;
    }

    public boolean canRenderInLayer(EnumWorldBlockLayer layer) {
        return layer == EnumWorldBlockLayer.SOLID || layer == EnumWorldBlockLayer.TRANSLUCENT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BoxModel getRenderModel(IBlockAccess world, BlockPos pos, @Nullable IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileSpotlight) {
            BoxModel model = renderModelCache.get(tileEntity);
            if (model != null) {
                return model;
            }
            model = new BoxModel();
            model.addAll(super.getRenderModel(world, pos, state));
            TileSpotlight spotlight = (TileSpotlight)tileEntity;
            BoxRotatable lamp = (BoxRotatable)model.get(model.size() - 1);
            float[] normal = (float[])spotlight.getBaseNormal().clone();
            if (tileEntity.func_145831_w().field_72995_K && spotlight.active) {
                UV[] faceVec = lamp.faceVecs[5];
                float d = -0.1f;
                float d2 = 4.0f;
                Vector3f v = new Vector3f(d * normal[0] + 0.5f, d * normal[1] + 0.5f, d * normal[2] + 0.5f);
                for (int i = 0; i < 4; ++i) {
                    UV a = faceVec[i];
                    UV b = faceVec[(i + 1) % 4];
                    BoxSingleQuad glow = new BoxSingleQuad(new UV(a.x, a.y, a.z, 1), new UV(b.x, b.y, b.z, 2), new UV(v.x + (b.x - v.x) * d2, v.y + (b.y - v.y) * d2, v.z + (b.z - v.z) * d2, 3), new UV(v.x + (a.x - v.x) * d2, v.y + (a.y - v.y) * d2, v.z + (a.z - v.z) * d2, 0));
                    glow.setTexture("gradient_64");
                    glow.noCollide = true;
                    glow.setDoubleSided(true);
                    glow.addShading = false;
                    glow.layer = EnumWorldBlockLayer.TRANSLUCENT;
                    model.add(glow);
                }
            }
            renderModelCache.put(tileEntity, model);
            return model;
        }
        return this.invCache;
    }

    @Override
    @Nonnull
    public BoxModel getWorldModel(IBlockAccess world, BlockPos pos, @Nullable IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileSpotlight) {
            BoxModel model = worldModelCache.get(tileEntity);
            if (model != null) {
                return model;
            }
            if (state == null) {
                state = world.func_180495_p(pos);
            }
            TileSpotlight spotlight = (TileSpotlight)tileEntity;
            model = new BoxModel();
            model.addAll(this.getStandModel((EnumFacing)state.func_177229_b((IProperty)XUBlockStateCreator.ROTATION_ALL)));
            BoxRotatable lamp = new BoxRotatable(0.1875f, 0.3125f, 0.3125f, 0.8125f, 0.6875f, 0.6875f);
            lamp.setTexture("spotlight");
            lamp.setTextureBounds(new float[][]{{10.0f, 10.0f, 0.0f, 16.0f}, {0.0f, 10.0f, 10.0f, 16.0f}, {0.0f, 10.0f, 10.0f, 16.0f}, {10.0f, 10.0f, 0.0f, 16.0f}, {10.0f, 10.0f, 16.0f, 16.0f}, {spotlight.active ? 10.0f : 0.0f, 0.0f, spotlight.active ? 16.0f : 6.0f, 6.0f}});
            float[] normal = (float[])spotlight.getBaseNormal().clone();
            float x = normal[0];
            float y = normal[1];
            float z = normal[2];
            lamp.rotate(MathHelper.func_76129_c((float)(1.0f - y * y)), y, 0.5f, 0.5f, 0.5f, 0.0f, 0.0f, 1.0f);
            lamp.rotate(x, -z, 0.5f, 0.5f, 0.5f, 0.0f, 1.0f, 0.0f);
            model.add(lamp);
            worldModelCache.put(tileEntity, model);
            return model;
        }
        return this.getInventoryModel(null);
    }

    @Override
    public void clearCaches() {
        this.invCache = null;
        worldModelCache.clear();
        renderModelCache.clear();
    }

    @Override
    @Nonnull
    public BoxModel getInventoryModel(@Nullable ItemStack item) {
        BoxModel inv = this.invCache;
        if (inv != null) {
            return this.invCache;
        }
        inv = new BoxModel();
        inv.addAll(this.getStandModel(EnumFacing.UP));
        inv.addBoxI((int)3, (int)5, (int)5, (int)13, (int)11, (int)11, (String)"spotlight").textureBounds = new float[][]{{10.0f, 0.0f, 0.0f, 6.0f}, {0.0f, 0.0f, 10.0f, 6.0f}, {10.0f, 0.0f, 0.0f, 6.0f}, {0.0f, 0.0f, 10.0f, 6.0f}, {10.0f, 0.0f, 16.0f, 6.0f}, {0.0f, 10.0f, 6.0f, 16.0f}};
        this.invCache = inv;
        return inv;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        tooltip.add(Lang.translateArgs("Power Required: %s GP", Float.valueOf(4.0f)));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileSpotlight();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World worldIn, BlockPos pos, IBlockState state, Random rand) {
    }
}

