/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.rwtema.extrautils2.backend.PropertyEnumSimple;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.XUBlockFull;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.textures.TextureRedstoneClock;
import com.rwtema.extrautils2.utils.datastructures.ThreadLocalBoolean;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockRedstoneClock
extends XUBlockFull {
    public static final PropertyEnumSimple<PowerState> propertyPowerState = new PropertyEnumSimple<PowerState>(PowerState.class);
    public static final int POWER_TIME = 2;
    public static final int TICK_TIME = 20;
    final ThreadLocal<Boolean> canProvidePower = new ThreadLocalBoolean(false);
    final ThreadLocal<Boolean> changing = new ThreadLocalBoolean(false);

    public BlockRedstoneClock() {
        super(Material.field_151576_e);
        for (PowerState powerState : PowerState.values()) {
            powerState.state = this.func_176223_P().func_177226_a(propertyPowerState, (Comparable)((Object)powerState));
        }
    }

    @Override
    protected XUBlockStateCreator createBlockState() {
        return new XUBlockStateCreator((XUBlock)this, new IProperty[]{propertyPowerState});
    }

    @Override
    public void registerTextures() {
        Textures.register("redstone_clock_off");
        Textures.textureNames.put("redstone_clock_on", new TextureRedstoneClock("ExtraUtils2:redstone_clock_on"));
    }

    @Override
    public String getTexture(IBlockState state, EnumFacing side) {
        if (state.func_177229_b(propertyPowerState) == PowerState.DISABLED) {
            return "redstone_clock_off";
        }
        return "redstone_clock_on";
    }

    public int func_149656_h() {
        return 2;
    }

    public int func_180656_a(IBlockAccess worldIn, BlockPos pos, IBlockState state, EnumFacing side) {
        if (!this.canProvidePower.get().booleanValue()) {
            return 0;
        }
        if (state.func_177229_b(propertyPowerState) == PowerState.ENABLED_POWERED) {
            return 15;
        }
        return 0;
    }

    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149637_q() {
        return false;
    }

    public boolean func_149744_f() {
        return true;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_180497_b(pos, (Block)this, 1, 0);
    }

    public boolean canConnectRedstone(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        if (this.changing.get().booleanValue()) {
            return;
        }
        boolean powered = this.isPowered((IBlockAccess)worldIn, pos);
        PowerState value = (PowerState)((Object)state.func_177229_b(propertyPowerState));
        if (powered && value != PowerState.DISABLED) {
            worldIn.func_180501_a(pos, PowerState.DISABLED.state, 3);
        } else if (!powered && value == PowerState.DISABLED) {
            int l = (int)(worldIn.func_82737_E() % 20L);
            this.changing.set(true);
            if (l < 2) {
                worldIn.func_180501_a(pos, PowerState.ENABLED_POWERED.state, 3);
                worldIn.func_180497_b(pos, (Block)this, 2 - l, 0);
            } else {
                worldIn.func_180501_a(pos, PowerState.ENABLED_NOT_POWERED.state, 3);
                worldIn.func_180497_b(pos, (Block)this, 20 - l, 0);
            }
            this.changing.set(false);
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        PowerState powerState = (PowerState)((Object)state.func_177229_b(propertyPowerState));
        if (powerState == PowerState.DISABLED) {
            return;
        }
        int l = (int)(worldIn.func_82737_E() % 20L);
        this.changing.set(true);
        if (l < 2) {
            worldIn.func_180501_a(pos, PowerState.ENABLED_POWERED.state, 1);
            worldIn.func_180497_b(pos, (Block)this, 2 - l, 0);
        } else {
            worldIn.func_180501_a(pos, PowerState.ENABLED_NOT_POWERED.state, 1);
            if (this.isPowered((IBlockAccess)worldIn, pos)) {
                worldIn.func_180501_a(pos, PowerState.DISABLED.state, 3);
            } else {
                worldIn.func_180497_b(pos, (Block)this, 20 - l, 0);
            }
        }
        this.changing.set(false);
    }

    @Override
    @Nonnull
    public BoxModel getWorldModel(IBlockAccess world, BlockPos pos, @Nullable IBlockState state) {
        return super.getWorldModel(world, pos, state);
    }

    private boolean isPowered(IBlockAccess worldIn, BlockPos pos) {
        this.canProvidePower.set(false);
        boolean powered = false;
        for (EnumFacing side : EnumFacing.values()) {
            if (worldIn.func_175627_a(pos.func_177972_a(side), side) <= 0) continue;
            powered = true;
            break;
        }
        this.canProvidePower.set(true);
        return powered;
    }

    static enum PowerState {
        ENABLED_NOT_POWERED,
        ENABLED_POWERED,
        DISABLED;

        public IBlockState state;
    }
}

