/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.rwtema.extrautils2.achievements.AchievementHelper;
import com.rwtema.extrautils2.backend.PropertyEnumSimple;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.XUBlockStatic;
import com.rwtema.extrautils2.backend.entries.IItemStackMaker;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.blocks.BlockDecorativeSolid;
import com.rwtema.extrautils2.crafting.CraftingHelper;
import com.rwtema.extrautils2.items.ItemIngredients;
import com.rwtema.extrautils2.power.IWorldPowerMultiplier;
import com.rwtema.extrautils2.power.PowerMultipliers;
import com.rwtema.extrautils2.tile.TilePassiveGenerator;
import com.rwtema.extrautils2.tile.TilePowerHandCrank;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPassiveGenerator
extends XUBlockStatic {
    public static final PropertyEnumSimple<GeneratorTypes> GENERATOR_TYPE = new PropertyEnumSimple<GeneratorTypes>(GeneratorTypes.class);
    public static final int BASE_SOLAR_VALUE = 2;

    public BlockPassiveGenerator() {
        super(Material.field_151576_e);
    }

    private static int getBaseSolarPower(World world) {
        return world.func_72935_r() ? 2 : 0;
    }

    @Override
    protected XUBlockStateCreator createBlockState() {
        return new XUBlockStateCreator((XUBlock)this, false, new IProperty[]{GENERATOR_TYPE});
    }

    @Override
    public BoxModel getModel(IBlockState baseState) {
        GeneratorTypes value = (GeneratorTypes)((Object)baseState.func_177229_b(GENERATOR_TYPE));
        BoxModel model = new BoxModel();
        value.createModel(model, false);
        return model;
    }

    @Override
    public BoxModel getModelInv(IBlockState baseState) {
        GeneratorTypes value = (GeneratorTypes)((Object)baseState.func_177229_b(GENERATOR_TYPE));
        BoxModel model = new BoxModel();
        value.createModel(model, true);
        return model;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return ((GeneratorTypes)((Object)state.func_177229_b(GENERATOR_TYPE))).createTileEntity(world);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public EnumWorldBlockLayer func_180664_k() {
        return super.func_180664_k();
    }

    public boolean func_176193_a(World worldIn, BlockPos pos, EnumFacing side, ItemStack stack) {
        if (!super.func_176193_a(worldIn, pos, side, stack)) {
            return false;
        }
        IBlockState state = this.xuBlockState.getStateFromItemStack(stack);
        return ((GeneratorTypes)((Object)state.func_177229_b(GENERATOR_TYPE))).validPos(worldIn, pos);
    }

    @Override
    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        if (!((GeneratorTypes)((Object)state.func_177229_b(GENERATOR_TYPE))).validPos(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            return;
        }
        super.func_176204_a(worldIn, pos, state, neighborBlock);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        ((GeneratorTypes)((Object)this.xuBlockState.getStateFromItemStack(stack).func_177229_b(GENERATOR_TYPE))).addInformation(stack, playerIn, tooltip, advanced);
    }

    public float func_176195_g(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos) == this.func_176223_P().func_177226_a(GENERATOR_TYPE, (Comparable)((Object)GeneratorTypes.CREATIVE))) {
            return -1.0f;
        }
        return super.func_176195_g(worldIn, pos);
    }

    public static enum GeneratorTypes implements IItemStackMaker
    {
        Solar(PowerMultipliers.SOLAR){

            @Override
            public void registerAchievements() {
                AchievementHelper.addAchievement("Solar Panel", "The sun gives power to all!", this, ItemIngredients.Type.REDSTONE_CRYSTAL);
            }

            @Override
            public float getPowerLevel(TilePassiveGenerator generator, World world) {
                if (world.field_73011_w.func_177495_o()) {
                    return 0.0f;
                }
                if (!world.func_175678_i(generator.func_174877_v().func_177984_a())) {
                    return 0.0f;
                }
                return 1.0f;
            }

            @Override
            public void createModel(BoxModel model, boolean isInv) {
                model.addBoxI(0, 0, 0, 16, 4, 16).setTextureSides("panel_side", 0, "panel_bottom", 1, "panel_solar");
            }

            @Override
            public boolean validPos(World worldIn, BlockPos pos) {
                return World.func_175683_a((IBlockAccess)worldIn, (BlockPos)pos.func_177977_b());
            }

            @Override
            public void addRecipe() {
                CraftingHelper.addShaped(this.newStack(3), "LLL", "BRB", Character.valueOf('L'), "gemLapis", Character.valueOf('R'), ItemIngredients.Type.REDSTONE_CRYSTAL.newStack(1), Character.valueOf('B'), BlockDecorativeSolid.DecorStates.stoneslab.newStack(1));
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add(Lang.translate("Gives power during daylight hours."));
                tooltip.add(Lang.translate("Must have clear line of sight to sky."));
                tooltip.add(Lang.translate("Power reduced by rain."));
                super.addInformation(stack, playerIn, tooltip, advanced);
            }
        }
        ,
        Lunar(PowerMultipliers.LUNAR){

            @Override
            public void registerAchievements() {
                AchievementHelper.addAchievement("Lunar Panel", "The moon gives power to all!", this, ItemIngredients.Type.DYE_POWDER_LUNAR);
            }

            @Override
            public float getPowerLevel(TilePassiveGenerator generator, World world) {
                if (world.field_73011_w.func_177495_o()) {
                    return 0.0f;
                }
                if (!world.func_175678_i(generator.func_174877_v().func_177984_a())) {
                    return 0.0f;
                }
                return 1.0f;
            }

            @Override
            public void createModel(BoxModel model, boolean isInv) {
                model.addBoxI(0, 0, 0, 16, 4, 16).setTexture("panel_side").setTextureSides(0, "panel_bottom", 1, "panel_lunar");
            }

            @Override
            public boolean validPos(World worldIn, BlockPos pos) {
                return World.func_175683_a((IBlockAccess)worldIn, (BlockPos)pos.func_177977_b());
            }

            @Override
            public void addRecipe() {
                CraftingHelper.addShaped(this.newStack(3), "LLL", "BrB", Character.valueOf('L'), ItemIngredients.Type.DYE_POWDER_LUNAR.newStack(1), Character.valueOf('r'), ItemIngredients.Type.REDSTONE_CRYSTAL.newStack(1), Character.valueOf('B'), BlockDecorativeSolid.DecorStates.stoneslab.newStack(1));
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add(Lang.translate("Gives power during night hours."));
                tooltip.add(Lang.translate("Must have clear line of sight to sky."));
                tooltip.add(Lang.translate("Power boosted by full moon."));
                tooltip.add(Lang.translate("Power reduced by rain."));
                super.addInformation(stack, playerIn, tooltip, advanced);
            }
        }
        ,
        Lava(IWorldPowerMultiplier.CONSTANT){

            @Override
            public void registerAchievements() {
                AchievementHelper.addAchievement("Lava Generator", "Adjacent heat! It burns!", this, BlockDecorativeSolid.DecorStates.stoneburnt);
            }

            @Override
            public float getPowerLevel(TilePassiveGenerator generator, World world) {
                float h = 0.0f;
                for (EnumFacing enumFacing : EnumFacing.field_176754_o) {
                    BlockPos offset = generator.func_174877_v().func_177972_a(enumFacing);
                    IBlockState blockState = generator.func_145831_w().func_180495_p(offset);
                    Block block = blockState.func_177230_c();
                    if (block != Blocks.field_150353_l && block != Blocks.field_150356_k || (h = Math.max(h, (float)(8 - (Integer)blockState.func_177229_b((IProperty)BlockLiquid.field_176367_b)))) != 8.0f) continue;
                    return 2.0f;
                }
                return h / 4.0f;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add(Lang.translateArgs("Gives %s GP when adjacent to lava.", 2));
            }

            @Override
            public void createModel(BoxModel model, boolean isInv) {
                model.addBoxI(0, 0, 0, 16, 16, 16, "panel_base").setTextureSides(0, "panel_lava", 1, "panel_lava");
            }

            @Override
            public void addRecipe() {
                CraftingHelper.addShaped(this.newStack(1), "BBB", "BRB", "BgB", Character.valueOf('g'), "ingotGold", Character.valueOf('R'), ItemIngredients.Type.REDSTONE_CRYSTAL.newStack(1), Character.valueOf('B'), BlockDecorativeSolid.DecorStates.stoneburnt.newStack(1));
            }
        }
        ,
        Water(IWorldPowerMultiplier.CONSTANT){

            @Override
            public void registerAchievements() {
                AchievementHelper.addAchievement("Water Mill", "The Flow of Water", this, BlockDecorativeSolid.DecorStates.stoneburnt);
            }

            @Override
            public float getPowerLevel(TilePassiveGenerator generator, World world) {
                float v = 0.0f;
                for (EnumFacing enumFacing : EnumFacing.field_176754_o) {
                    int value;
                    BlockPos offset = generator.func_174877_v().func_177972_a(enumFacing);
                    IBlockState blockState = world.func_180495_p(offset);
                    Block block = blockState.func_177230_c();
                    if (!this.isWater(block) || this.isWater(world.func_180495_p(offset.func_177984_a()).func_177230_c()) || (value = 8 - (Integer)blockState.func_177229_b((IProperty)BlockLiquid.field_176367_b)) >= 8) continue;
                    v += (float)((value + 1) / 2);
                }
                return v / 4.0f;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add(Lang.translate("Gives GP for adjacent flowing water blocks."));
                tooltip.add(Lang.translate("The higher the level, the more GP."));
                tooltip.add(Lang.translate("Source/full water blocks do not count."));
                tooltip.add(Lang.translateArgs("Max Power: %s GP", 4));
            }

            private boolean isWater(Block block) {
                return block == Blocks.field_150355_j || block == Blocks.field_150358_i;
            }

            @Override
            public void createModel(BoxModel model, boolean isInv) {
                model.addBoxI(0, 0, 0, 16, 16, 16, "panel_base").setTextureSides(1, "panel_water");
                model.addBoxOverlay(0.0f).setTexture("fan_spinning_small").setInvisible(3).setLayer(EnumWorldBlockLayer.CUTOUT);
            }

            @Override
            public void addRecipe() {
                CraftingHelper.addShaped(this.newStack(1), "BBB", "gRg", "BBB", Character.valueOf('g'), ItemIngredients.Type.REDSTONE_GEAR.newStack(1), Character.valueOf('R'), ItemIngredients.Type.REDSTONE_CRYSTAL.newStack(1), Character.valueOf('B'), BlockDecorativeSolid.DecorStates.stoneburnt.newStack(1));
            }
        }
        ,
        Wind(PowerMultipliers.WIND){
            EnumFacing[] sides = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.NORTH};

            @Override
            public void registerAchievements() {
                AchievementHelper.addAchievement("Wind Mill", "Winds light to variable", this, BlockDecorativeSolid.DecorStates.stoneburnt);
            }

            @Override
            public float getPowerLevel(TilePassiveGenerator generator, World world) {
                for (EnumFacing enumFacing : this.sides) {
                    if (world.func_175623_d(generator.func_174877_v().func_177972_a(enumFacing))) continue;
                    return 0.0f;
                }
                return this.basePowerGen();
            }

            @Override
            public void createModel(BoxModel model, boolean isInv) {
                model.addBoxI(0, 0, 0, 16, 1, 16, "panel_base").setTextureSides(0, "panel_air");
                model.addBoxI(0, 15, 0, 16, 16, 16, "panel_base").setTextureSides(1, "panel_air");
                model.addBoxI(0, 1, 0, 1, 15, 16, "panel_base");
                model.addBoxI(15, 1, 0, 16, 15, 16, "panel_base");
                model.addBoxI(1, 1, 8, 15, 15, 8, "fan_spinning").setInvisible(true, true, false, false, true, true).setLayer(EnumWorldBlockLayer.CUTOUT);
            }

            @Override
            public void addRecipe() {
                CraftingHelper.addShaped(this.newStack(1), true, "BBB", " gR", "BBB", Character.valueOf('g'), ItemIngredients.Type.REDSTONE_GEAR.newStack(1), Character.valueOf('R'), ItemIngredients.Type.REDSTONE_CRYSTAL.newStack(1), Character.valueOf('B'), BlockDecorativeSolid.DecorStates.stoneburnt.newStack(1));
            }

            @Override
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add(Lang.translate("Generates power from wind."));
                tooltip.add(Lang.translate("Power boosted by rain."));
                tooltip.add(Lang.translate("North/south blocks must be clear"));
                super.addInformation(stack, playerIn, tooltip, advanced);
            }
        }
        ,
        FIRE(IWorldPowerMultiplier.CONSTANT){

            @Override
            public void registerAchievements() {
                AchievementHelper.addAchievement("Fire Mill", "Rising Heat!", this, BlockDecorativeSolid.DecorStates.stoneburnt);
            }

            @Override
            public float getPowerLevel(TilePassiveGenerator generator, World world) {
                IBlockState blockState = world.func_180495_p(generator.func_174877_v().func_177977_b());
                if (blockState.func_177230_c() != Blocks.field_150480_ab) {
                    return 0.0f;
                }
                return 2.0f;
            }

            @Override
            public void createModel(BoxModel model, boolean isInv) {
                model.addBoxI(0, 0, 0, 16, 16, 1, "panel_base").setTextureSides(2, "panel_fire");
                model.addBoxI(0, 0, 15, 16, 16, 16, "panel_base").setTextureSides(3, "panel_fire");
                model.addBoxI(0, 0, 1, 1, 16, 15, "panel_base").setTextureSides(4, "panel_fire");
                model.addBoxI(15, 0, 1, 16, 16, 15, "panel_base").setTextureSides(5, "panel_fire");
                model.addBoxI(1, 8, 1, 15, 8, 15, "fan_spinning").setInvisible(false, false, true, true, true, true).setLayer(EnumWorldBlockLayer.CUTOUT);
            }

            @Override
            public void addRecipe() {
                CraftingHelper.addShaped(this.newStack(1), true, "BRB", "BgB", "B B", Character.valueOf('g'), ItemIngredients.Type.REDSTONE_GEAR.newStack(1), Character.valueOf('R'), ItemIngredients.Type.REDSTONE_CRYSTAL.newStack(1), Character.valueOf('B'), BlockDecorativeSolid.DecorStates.stoneburnt.newStack(1));
            }

            @Override
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add(Lang.translateArgs("Gives %s GP when placed over fire.", 2));
            }
        }
        ,
        CREATIVE(IWorldPowerMultiplier.CONSTANT){

            @Override
            public void registerAchievements() {
            }

            @Override
            public float getPowerLevel(TilePassiveGenerator generator, World world) {
                return 10000.0f;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add(Lang.translate("Creative-only item."));
            }

            @Override
            public void createModel(BoxModel model, boolean isInv) {
                model.addBoxI(0, 0, 0, 16, 16, 16, "panel_creative").setTextureSides(0, "panel_creative_top", 1, "panel_creative_top");
            }

            @Override
            public void addRecipe() {
            }
        }
        ,
        PLAYER_WIND_UP(IWorldPowerMultiplier.CONSTANT){

            @Override
            public float getPowerLevel(TilePassiveGenerator generator, World world) {
                return 1.0f;
            }

            @Override
            public void createModel(BoxModel model, boolean isInv) {
                model.addBoxI(0, 0, 0, 16, 6, 16, "panel_stone_side").setTextureSides(0, "panel_stone_base", 1, "panel_stone_base");
                if (isInv) {
                    model.addBoxI(6, 6, 6, 10, 10, 10, "redstone_gear");
                    model.addBoxI(2, 7, 7, 14, 9, 9, "redstone_gear");
                    model.addBoxI(7, 7, 2, 9, 9, 14, "redstone_gear");
                    model.addBoxI(1, 7, 1, 15, 9, 15, "redstone_gear").setInvisible(-4);
                    model.addBoxI(1, 6, 7, 15, 10, 9, "redstone_gear").setInvisible(-13);
                    model.addBoxI(7, 6, 1, 9, 10, 15, "redstone_gear").setInvisible(-49);
                } else {
                    model.addBoxI(1, 6, 1, 15, 10, 15, "redstone_gear").setInvisible(-1);
                }
            }

            @Override
            public void addRecipe() {
                CraftingHelper.addShaped(this.newStack(), " R ", "BCB", Character.valueOf('R'), ItemIngredients.Type.REDSTONE_GEAR, Character.valueOf('B'), BlockDecorativeSolid.DecorStates.stoneslab, Character.valueOf('C'), ItemIngredients.Type.REDSTONE_CRYSTAL);
            }

            @Override
            public void registerAchievements() {
                AchievementHelper.addAchievement("Manual Mill", "Hold right click to temporarily generate power.", this, ItemIngredients.Type.REDSTONE_CRYSTAL);
            }

            @Override
            public TilePassiveGenerator createTileEntity(World world) {
                return new TilePowerHandCrank();
            }
        };

        public final IWorldPowerMultiplier powerMultiplier;

        private GeneratorTypes(IWorldPowerMultiplier powerMultiplier) {
            this.powerMultiplier = powerMultiplier;
        }

        public ItemStack newStack(int i) {
            return XU2Entries.passiveGenerator.newStack(i, new Object[]{GENERATOR_TYPE, this});
        }

        public abstract float getPowerLevel(TilePassiveGenerator var1, World var2);

        public abstract void createModel(BoxModel var1, boolean var2);

        public boolean validPos(World worldIn, BlockPos pos) {
            return true;
        }

        public abstract void addRecipe();

        public float basePowerGen() {
            return 1.0f;
        }

        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
            if (this.powerMultiplier != IWorldPowerMultiplier.CONSTANT) {
                tooltip.add(Lang.translateArgs("Base Power Given: %s GP", Float.valueOf(this.basePowerGen())));
                WorldClient theWorld = Minecraft.func_71410_x().field_71441_e;
                if (theWorld != null) {
                    tooltip.add(Lang.translateArgs("Cur Power Given: %s GP", StringHelper.niceFormat(this.basePowerGen() * this.powerMultiplier.multiplier((World)theWorld))));
                }
            } else {
                tooltip.add(Lang.translateArgs("Power Given: %s GP", Float.valueOf(this.basePowerGen())));
            }
        }

        @Override
        public ItemStack newStack() {
            return this.newStack(1);
        }

        public abstract void registerAchievements();

        public TilePassiveGenerator createTileEntity(World world) {
            return new TilePassiveGenerator();
        }
    }
}

