/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.rwtema.extrautils2.backend.XUBlockStatic;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxMimic;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.items.ItemIngredients;
import com.rwtema.extrautils2.utils.helpers.ColorHelper;
import com.rwtema.extrautils2.utils.helpers.WorldHelper;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockStone;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMoonStone
extends XUBlockStatic {
    public static IBlockState mimicState = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.STONE);

    public BlockMoonStone() {
        super(Material.field_151576_e);
    }

    public int func_176207_c(IBlockAccess worldIn, BlockPos pos) {
        EnumWorldBlockLayer renderLayer = MinecraftForgeClient.getRenderLayer();
        if (renderLayer == EnumWorldBlockLayer.TRANSLUCENT) {
            return 0xF000F0;
        }
        return super.func_176207_c(worldIn, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World worldIn, BlockPos pos, IBlockState state, Random rand) {
    }

    public boolean isFullMoon(World world) {
        return world.func_130001_d() == 1.0f;
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BoxModel getRenderModel(IBlockAccess world, BlockPos pos, @Nullable IBlockState state) {
        BoxModel model = BoxModel.newStandardBlock(false);
        model.add(new BoxMimic(world, pos, mimicState));
        if (WorldHelper.isFullMoon((World)Minecraft.func_71410_x().field_71441_e)) {
            Box box = model.addBox(-9.765625E-4f, -9.765625E-4f, -9.765625E-4f, 1.0009766f, 1.0009766f, 1.0009766f).setTexture("moon_stone_cutout");
            box.layer = EnumWorldBlockLayer.TRANSLUCENT;
            int combinedLight = world.func_175626_b(pos, 0);
            int b = combinedLight >> 4 & 0xF;
            b = (int)((float)b * WorldHelper.getMoonBrightness((World)Minecraft.func_71410_x().field_71441_e));
            int alpha = 255 - 2 * b * 16;
            box.color = ColorHelper.makeAlphaWhite(alpha);
        }
        return model;
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Blocks.field_150348_b.func_180660_a(mimicState, rand, fortune);
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return Blocks.field_150348_b.func_180651_a(mimicState);
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        World world1;
        List drops = Blocks.field_150348_b.getDrops(world, pos, mimicState, fortune);
        if (world instanceof World && WorldHelper.isFullMoon(world1 = (World)world)) {
            drops.add(ItemIngredients.Type.MOON_STONE.newStack(1));
        }
        return drops;
    }

    @Override
    public BoxModel getModel(IBlockState state) {
        BoxModel model = BoxModel.newStandardBlock(false);
        model.add(new BoxMimic(mimicState));
        Box box = model.addBox(-9.765625E-4f, -9.765625E-4f, -9.765625E-4f, 1.0009766f, 1.0009766f, 1.0009766f).setTexture("moon_stone_cutout");
        box.layer = EnumWorldBlockLayer.TRANSLUCENT;
        return model;
    }
}

