/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.rwtema.extrautils2.backend.PropertyEnumSimple;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.XUBlockConnectedTextureBase;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.entries.IItemStackMaker;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.blocks.BlockDecorativeSolid;
import com.rwtema.extrautils2.crafting.CraftingHelper;
import com.rwtema.extrautils2.textures.ConnectedTexture;
import com.rwtema.extrautils2.textures.ISolidWorldTexture;
import com.rwtema.extrautils2.tile.TileResonator;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDecorativeGlass
extends XUBlockConnectedTextureBase {
    public static final PropertyEnumSimple<DecorStates> decor = new PropertyEnumSimple<DecorStates>(DecorStates.class);

    public BlockDecorativeGlass() {
        super(Material.field_151592_s);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        for (DecorStates decorState : DecorStates.values()) {
            decorState.tex = new ConnectedTexture(decorState.toString(), this.xuBlockState.defaultState.func_177226_a(decor, (Comparable)((Object)decorState)), this);
        }
    }

    @Override
    protected XUBlockStateCreator createBlockState() {
        return new XUBlockStateCreator((XUBlock)this, false, new IProperty[]{decor});
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.TRANSLUCENT;
    }

    public boolean canRenderInLayer(EnumWorldBlockLayer layer) {
        return layer == EnumWorldBlockLayer.CUTOUT || layer == EnumWorldBlockLayer.TRANSLUCENT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ISolidWorldTexture getConnectedTexture(IBlockState state, EnumFacing side) {
        return ((DecorStates)((Object)state.func_177229_b(BlockDecorativeGlass.decor))).tex;
    }

    @Override
    public boolean isNormalCube(IBlockAccess world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean func_149686_d() {
        return false;
    }

    public int getLightOpacity(IBlockAccess world, BlockPos pos) {
        if (world instanceof World && !((World)world).func_175667_e(pos)) {
            return 0;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return 0;
        }
        return ((DecorStates)((Object)state.func_177229_b(BlockDecorativeGlass.decor))).opacity;
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        if (world instanceof World && !((World)world).func_175667_e(pos)) {
            return 0;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return 0;
        }
        return ((DecorStates)((Object)state.func_177229_b(BlockDecorativeGlass.decor))).light_level;
    }

    @Override
    public EnumWorldBlockLayer renderLayer(IBlockState state) {
        return ((DecorStates)((Object)state.func_177229_b(BlockDecorativeGlass.decor))).layer;
    }

    public boolean canConnectRedstone(IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (world instanceof World && !((World)world).func_175667_e(pos)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == this && ((DecorStates)((Object)state.func_177229_b(BlockDecorativeGlass.decor))).redstone_level > 0;
    }

    public int func_180656_a(IBlockAccess worldIn, BlockPos pos, IBlockState state, EnumFacing side) {
        if (state == null) {
            if (worldIn instanceof World && !((World)worldIn).func_175667_e(pos)) {
                return 0;
            }
            state = worldIn.func_180495_p(pos);
        }
        if (state.func_177230_c() != this) {
            return 0;
        }
        return ((DecorStates)((Object)state.func_177229_b(BlockDecorativeGlass.decor))).redstone_level;
    }

    public static enum DecorStates implements IItemStackMaker
    {
        glass{

            @Override
            public void addRecipes() {
                FurnaceRecipes.func_77602_a().func_151394_a(BlockDecorativeSolid.DecorStates.sandy_glass.newStack(1), this.newStack(1), 0.0f);
            }
        }
        ,
        glass_border{

            @Override
            public void addRecipes() {
                CraftingHelper.addShaped(this.newStack(1), "SS", "SS", Character.valueOf('S'), glass.newStack(1));
            }
        }
        ,
        glass_diamonds{

            @Override
            public void addRecipes() {
                CraftingHelper.addShaped(this.newStack(1), "SS", "SS", Character.valueOf('S'), glass_border.newStack(1));
            }
        }
        ,
        darkglass{
            {
                this.layer = EnumWorldBlockLayer.TRANSLUCENT;
                this.opacity = 255;
            }

            @Override
            public void addRecipes() {
                CraftingHelper.addShapeless(this.newStack(2), glass.newStack(1), "dyeBlack", glass.newStack(1));
            }
        }
        ,
        glass_glowstone{
            {
                this.layer = EnumWorldBlockLayer.TRANSLUCENT;
                this.light_level = 15;
            }

            @Override
            public void addRecipes() {
                CraftingHelper.addShapeless(this.newStack(2), glass.newStack(1), "dustGlowstone", glass.newStack(1));
            }
        }
        ,
        glass_redstone{
            {
                this.redstone_level = 15;
            }

            @Override
            public void addRecipes() {
                if (XU2Entries.resonator.isActive()) {
                    TileResonator.register(glass.newStack(1), this.newStack(1), 100);
                } else {
                    CraftingHelper.addShapeless(this.newStack(2), glass.newStack(1), "dustRedstone", glass.newStack(1));
                }
            }
        };

        @SideOnly(value=Side.CLIENT)
        public ISolidWorldTexture tex;
        int opacity = 0;
        int light_level = 0;
        int redstone_level = 0;
        EnumWorldBlockLayer layer = EnumWorldBlockLayer.CUTOUT;

        public abstract void addRecipes();

        public ItemStack newStack(int amount) {
            return XU2Entries.decorativeGlass.newStack(amount, new Object[]{decor, this});
        }

        @Override
        public ItemStack newStack() {
            return this.newStack(1);
        }
    }
}

