/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.rwtema.extrautils2.backend.PropertyEnumSimple;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.XUBlockConnectedTextureBase;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.textures.ConnectedTexture;
import com.rwtema.extrautils2.textures.ISolidWorldTexture;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BlockCursedEarth
extends XUBlockConnectedTextureBase {
    public static final PropertyEnumSimple<Type> TYPE = new PropertyEnumSimple<Type>(Type.class);
    ISolidWorldTexture tex;

    public BlockCursedEarth() {
        super(Material.field_151577_b);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.func_149675_a(true);
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)Blocks.field_150346_d);
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        EntityLiving mob;
        if (worldIn == null || worldIn.field_72995_K) {
            return;
        }
        WorldServer world = (WorldServer)worldIn;
        EnumCreatureType type = EnumCreatureType.MONSTER;
        BiomeGenBase.SpawnListEntry entry = world.func_175734_a(type, pos);
        if (!world.func_175732_a(type, entry, pos)) {
            return;
        }
        try {
            mob = (EntityLiving)entry.field_76300_b.getConstructor(World.class).newInstance(world);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        float x = (float)pos.func_177958_n() + 0.5f;
        float y = pos.func_177956_o() + 1;
        float z = (float)pos.func_177952_p() + 0.5f;
        mob.func_70012_b((double)x, (double)y, (double)z, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)mob, (World)world, (float)x, (float)y, (float)z)) {
            mob.func_180482_a(world.func_175649_E(new BlockPos((Entity)mob)), null);
        }
        if (!mob.func_70058_J() || !mob.func_70601_bi()) {
            return;
        }
        mob.field_98038_p = true;
        mob.getEntityData().func_74768_a("CursedEarth", 1200);
        mob.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 3600, 1));
        mob.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 3600, 1));
        IAttributeInstance entityAttribute = mob.func_110148_a(SharedMonsterAttributes.field_111265_b);
        if (entityAttribute != null) {
            entityAttribute.func_111121_a(new AttributeModifier("CursedEarthBonus", 0.5, 2));
        }
        if (state.func_177229_b(TYPE) == Type.CURSED_SUPERCHARGED && mob instanceof EntityMob) {
            EntityMob entityMob;
            double d;
            EntityPlayer closestPlayer;
            ((EntityMob)mob).field_70172_ad = 40;
            mob.func_98053_h(true);
            mob.func_110163_bv();
            if (mob instanceof EntityCreeper) {
                mob.func_70096_w().func_75692_b(17, (Object)1);
            }
            mob.getEntityData().func_82580_o("CursedEarth");
            if (!world.field_73010_i.isEmpty() && (closestPlayer = world.func_72890_a((Entity)mob, d = entityAttribute != null ? entityAttribute.func_111126_e() : 16.0)) != null && (entityMob = (EntityMob)mob).func_70638_az() == null) {
                entityMob.func_70624_b((EntityLivingBase)closestPlayer);
            }
        }
        world.func_72838_d((Entity)mob);
        mob.func_70642_aH();
    }

    @SubscribeEvent
    public void entTick(LivingEvent.LivingUpdateEvent event) {
        int cursedEarth;
        NBTTagCompound entityData = event.entity.getEntityData();
        if (entityData.func_74764_b("CursedEarth") && (cursedEarth = entityData.func_74762_e("CursedEarth")) > 0) {
            if (cursedEarth == 1) {
                event.entity.func_70106_y();
            } else {
                entityData.func_74768_a("CursedEarth", --cursedEarth);
            }
        }
    }

    @Override
    protected XUBlockStateCreator createBlockState() {
        return new XUBlockStateCreator((XUBlock)this, new IProperty[]{TYPE});
    }

    @Override
    public boolean func_149662_c() {
        return true;
    }

    @Override
    public ISolidWorldTexture getConnectedTexture(IBlockState state, EnumFacing side) {
        return this.tex;
    }

    @Override
    public void registerTextures() {
        this.tex = new ConnectedTexture("evil_earth", this.func_176223_P(), this);
    }

    public static enum Type {
        CURSED_NORMAL,
        CURSED_SUPERCHARGED;

    }
}

