/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend.model;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.backend.IXUItem;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.MutableModel;
import com.rwtema.extrautils2.backend.model.NullModel;
import com.rwtema.extrautils2.backend.model.Transforms;
import com.rwtema.extrautils2.utils.client.BakedQuadTint;
import com.rwtema.extrautils2.utils.helpers.QuadHelper;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.WeakHashMap;
import javax.vecmath.Matrix4f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.ISmartItemModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class PassthruModelItem
extends NullModel
implements ISmartItemModel {
    public static WeakHashMap<TextureAtlasSprite, ImmutableList<BakedQuad>> quads2dcache = new WeakHashMap<TextureAtlasSprite, ImmutableList<BakedQuad>>(){

        @Override
        public ImmutableList<BakedQuad> get(Object key) {
            ImmutableList bakedQuads = (ImmutableList)super.get(key);
            if (bakedQuads == null) {
                TextureAtlasSprite sprite = (TextureAtlasSprite)key;
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.add((Object)QuadHelper.buildQuad(DefaultVertexFormats.field_176599_b, TRSRTransformation.identity(), EnumFacing.SOUTH, -1, 0.0f, 0.0f, 0.5f, sprite.func_94209_e(), sprite.func_94210_h(), 0.0f, 1.0f, 0.5f, sprite.func_94209_e(), sprite.func_94206_g(), 1.0f, 1.0f, 0.5f, sprite.func_94212_f(), sprite.func_94206_g(), 1.0f, 0.0f, 0.5f, sprite.func_94212_f(), sprite.func_94210_h()));
                builder.add((Object)QuadHelper.buildQuad(DefaultVertexFormats.field_176599_b, TRSRTransformation.identity(), EnumFacing.NORTH, -1, 0.0f, 0.0f, 0.5f, sprite.func_94209_e(), sprite.func_94210_h(), 1.0f, 0.0f, 0.5f, sprite.func_94212_f(), sprite.func_94210_h(), 1.0f, 1.0f, 0.5f, sprite.func_94212_f(), sprite.func_94206_g(), 0.0f, 1.0f, 0.5f, sprite.func_94209_e(), sprite.func_94206_g()));
                bakedQuads = builder.build();
                this.put(sprite, bakedQuads);
            }
            return bakedQuads;
        }
    };
    public static WeakHashMap<TextureAtlasSprite, ImmutableList<BakedQuad>> pseudoQuads2dCache = new WeakHashMap<TextureAtlasSprite, ImmutableList<BakedQuad>>(){

        @Override
        public ImmutableList<BakedQuad> get(Object key) {
            ImmutableList bakedQuads = (ImmutableList)super.get(key);
            if (bakedQuads == null) {
                TextureAtlasSprite sprite = (TextureAtlasSprite)key;
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.add((Object)QuadHelper.buildQuad(DefaultVertexFormats.field_176599_b, TRSRTransformation.identity(), EnumFacing.SOUTH, -1, 0.0f, 0.0f, 0.46875f, sprite.func_94209_e(), sprite.func_94210_h(), 0.0f, 1.0f, 0.46875f, sprite.func_94209_e(), sprite.func_94206_g(), 1.0f, 1.0f, 0.46875f, sprite.func_94212_f(), sprite.func_94206_g(), 1.0f, 0.0f, 0.46875f, sprite.func_94212_f(), sprite.func_94210_h()));
                builder.add((Object)QuadHelper.buildQuad(DefaultVertexFormats.field_176599_b, TRSRTransformation.identity(), EnumFacing.NORTH, -1, 0.0f, 0.0f, 0.53125f, sprite.func_94209_e(), sprite.func_94210_h(), 1.0f, 0.0f, 0.53125f, sprite.func_94212_f(), sprite.func_94210_h(), 1.0f, 1.0f, 0.53125f, sprite.func_94212_f(), sprite.func_94206_g(), 0.0f, 1.0f, 0.53125f, sprite.func_94209_e(), sprite.func_94206_g()));
                bakedQuads = builder.build();
                this.put(sprite, bakedQuads);
            }
            return bakedQuads;
        }
    };
    public static WeakHashMap<TextureAtlasSprite, ImmutableList<BakedQuad>> quads3dcache = new WeakHashMap<TextureAtlasSprite, ImmutableList<BakedQuad>>(){

        @Override
        public ImmutableList<BakedQuad> get(Object key) {
            ImmutableList bakedQuads = (ImmutableList)super.get(key);
            if (bakedQuads == null) {
                TextureAtlasSprite sprite = (TextureAtlasSprite)key;
                bakedQuads = ItemLayerModel.instance.getQuadsForSprite(-1, sprite, DefaultVertexFormats.field_176599_b, Optional.of((Object)TRSRTransformation.identity()));
                this.put(sprite, bakedQuads);
            }
            return bakedQuads;
        }
    };
    public static TIntObjectHashMap<WeakHashMap<BakedQuad, BakedQuadTint>> tintedQuads = new TIntObjectHashMap<WeakHashMap<BakedQuad, BakedQuadTint>>(){

        public WeakHashMap<BakedQuad, BakedQuadTint> get(final int key) {
            WeakHashMap weakHashMap = (WeakHashMap)super.get(key);
            if (weakHashMap != null) {
                return weakHashMap;
            }
            weakHashMap = new WeakHashMap<BakedQuad, BakedQuadTint>(){

                @Override
                public BakedQuadTint get(Object quadKey) {
                    BakedQuadTint quadTint = (BakedQuadTint)((Object)super.get(quadKey));
                    if (quadTint != null) {
                        return quadTint;
                    }
                    BakedQuad quad = (BakedQuad)quadKey;
                    quadTint = new BakedQuadTint(quad, key);
                    this.put(quad, quadTint);
                    return quadTint;
                }
            };
            this.put(key, weakHashMap);
            return weakHashMap;
        }
    };
    private final IXUItem item;
    ModelLayer model;

    public PassthruModelItem(IXUItem item) {
        this(item, item.renderAsTool() ? Transforms.itemToolsTransforms : Transforms.itemTransforms);
    }

    public PassthruModelItem(IXUItem item, EnumMap<ItemCameraTransforms.TransformType, Matrix4f> transforms) {
        this(item, new ModelLayer(transforms));
    }

    public PassthruModelItem(IXUItem item, ModelLayer model) {
        this.item = item;
        this.model = model;
    }

    @Override
    public TextureAtlasSprite func_177554_e() {
        return this.item.getBaseTexture();
    }

    public IBakedModel handleItemState(ItemStack stack) {
        this.model.clear();
        this.item.addQuads(this.model, stack);
        return this.model;
    }

    public static class ModelLayer
    extends MutableModel {
        static ItemCameraTransforms.TransformType[] types = new ItemCameraTransforms.TransformType[]{ItemCameraTransforms.TransformType.GUI, ItemCameraTransforms.TransformType.NONE};
        public MutableModel lowPolyVersion;

        public ModelLayer(EnumMap<ItemCameraTransforms.TransformType, Matrix4f> itemTransforms) {
            super(itemTransforms);
            this.isGui3D = false;
            this.ambientOcclusion = false;
            this.lowPolyVersion = new MutableModel(itemTransforms);
            for (ItemCameraTransforms.TransformType type : types) {
                this.transformMap.put(type, Pair.of((Object)this.lowPolyVersion, (Object)((Pair)this.transformMap.get(type)).getRight()));
            }
        }

        public void addBoxModel(BoxModel boxModel) {
            for (Box box : boxModel) {
                for (EnumFacing facing : EnumFacing.values()) {
                    List<BakedQuad> quads = box.getQuads(facing);
                    if (quads == null) continue;
                    this.addAllQuads(quads);
                }
                List<BakedQuad> quads = box.getQuads(null);
                if (quads == null) continue;
                this.addAllQuads(quads);
            }
        }

        @Override
        public void clear() {
            super.clear();
            this.lowPolyVersion.clear();
        }

        public void addSprite(TextureAtlasSprite sprite) {
            this.generalQuads.addAll((Collection)quads3dcache.get(sprite));
            this.lowPolyVersion.generalQuads.addAll((Collection)quads2dcache.get(sprite));
        }

        public void addSprite(TextureAtlasSprite sprite, boolean draw3d) {
            this.generalQuads.addAll((Collection)(draw3d ? quads3dcache : quads2dcache).get(sprite));
            this.lowPolyVersion.generalQuads.addAll((Collection)quads2dcache.get(sprite));
        }

        public void addTintedSprite(TextureAtlasSprite sprite, boolean draw3d, int tint) {
            if (tint == -1) {
                this.addSprite(sprite, draw3d);
            } else {
                for (BakedQuad bakedQuad : (draw3d ? quads3dcache : quads2dcache).get(sprite)) {
                    this.generalQuads.add(((WeakHashMap)tintedQuads.get(tint)).get(bakedQuad));
                }
                for (BakedQuad bakedQuad : quads2dcache.get(sprite)) {
                    this.lowPolyVersion.generalQuads.add((BakedQuad)((WeakHashMap)tintedQuads.get(tint)).get(bakedQuad));
                }
            }
        }

        public void addQuad(BakedQuad quad) {
            this.generalQuads.add(quad);
            this.lowPolyVersion.generalQuads.add(quad);
        }

        public void addAllQuads(Collection<BakedQuad> quads) {
            this.generalQuads.addAll(quads);
            this.lowPolyVersion.generalQuads.addAll(quads);
        }
    }
}

