/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.backend.model.Transforms;
import com.rwtema.extrautils2.utils.client.GLState;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import org.apache.commons.lang3.tuple.Pair;

public class MutableModel
implements IPerspectiveAwareModel {
    public final List<BakedQuad> generalQuads = Lists.newArrayList();
    public final List<List<BakedQuad>> sidedQuads = ImmutableList.of((Object)Lists.newArrayList(), (Object)Lists.newArrayList(), (Object)Lists.newArrayList(), (Object)Lists.newArrayList(), (Object)Lists.newArrayList(), (Object)Lists.newArrayList());
    public final EnumMap<ItemCameraTransforms.TransformType, Pair<IFlexibleBakedModel, Matrix4f>> transformMap;
    public boolean ambientOcclusion;
    public TextureAtlasSprite tex;
    public boolean isGui3D;
    private List<GLState<?>> states;

    public MutableModel(EnumMap<ItemCameraTransforms.TransformType, Matrix4f> type) {
        this.transformMap = Transforms.createMap((IFlexibleBakedModel)this, type);
    }

    public void clear() {
        this.tex = null;
        this.states = null;
        this.generalQuads.clear();
        for (List<BakedQuad> sidedQuad : this.sidedQuads) {
            sidedQuad.clear();
        }
    }

    public List<BakedQuad> func_177551_a(EnumFacing side) {
        return this.sidedQuads.get(side.func_176745_a());
    }

    public List<BakedQuad> func_177550_a() {
        return this.generalQuads;
    }

    public boolean func_177555_b() {
        return this.ambientOcclusion;
    }

    public void addGLState(GLState<?> state) {
        if (this.states == null) {
            this.states = new ArrayList();
        }
        this.states.add(state);
    }

    public boolean func_177556_c() {
        return this.isGui3D;
    }

    public boolean func_177553_d() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        TextureAtlasSprite tex = this.tex;
        return tex == null ? Textures.MISSING_SPRITE : tex;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public Pair<IFlexibleBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        this.handleGLStates();
        return this.transformMap.get(cameraTransformType);
    }

    public void handleGLStates() {
        if (this.states != null && "Client thread".equals(Thread.currentThread().getName())) {
            for (GLState<?> state : this.states) {
                state.setValue();
            }
        }
    }

    public VertexFormat getFormat() {
        return DefaultVertexFormats.field_176600_a;
    }

    public Iterable<BakedQuad> getAllQuads() {
        return Iterables.concat(this.generalQuads, (Iterable)Iterables.concat(this.sidedQuads));
    }

    public void rotateY(float x, float z, float t) {
        float c = MathHelper.func_76134_b((float)t);
        float s = MathHelper.func_76126_a((float)t);
        for (BakedQuad quad : this.getAllQuads()) {
            int[] data = quad.func_178209_a();
            for (int i = 0; i < 28; i += 7) {
                float ax = Float.intBitsToFloat(data[i]) - x;
                float az = Float.intBitsToFloat(data[i + 2]) - z;
                data[i] = Float.floatToRawIntBits(x + ax * c - az * s);
                data[i + 2] = Float.floatToRawIntBits(z + ax * s + az * c);
            }
        }
    }
}

