/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend.model;

import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.UV;
import com.rwtema.extrautils2.utils.helpers.QuadHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;

public class BoxRotatable
extends Box {
    public UV[][] faceVecs;

    public BoxRotatable(UV[][] faceVecs) {
        super(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.faceVecs = faceVecs;
        this.rebuildBounds();
    }

    public BoxRotatable(float x0, float y0, float z0, float x1, float y1, float z1) {
        super(x0, y0, z0, x1, y1, z1);
        this.faceVecs = new UV[][]{{new UV(x1, y0, z0, 0), new UV(x1, y0, z1, 1), new UV(x0, y0, z1, 2), new UV(x0, y0, z0, 3)}, {new UV(x0, y1, z0, 0), new UV(x0, y1, z1, 1), new UV(x1, y1, z1, 2), new UV(x1, y1, z0, 3)}, {new UV(x0, y0, z0, 0), new UV(x0, y1, z0, 1), new UV(x1, y1, z0, 2), new UV(x1, y0, z0, 3)}, {new UV(x1, y0, z1, 0), new UV(x1, y1, z1, 1), new UV(x0, y1, z1, 2), new UV(x0, y0, z1, 3)}, {new UV(x0, y0, z1, 0), new UV(x0, y1, z1, 1), new UV(x0, y1, z0, 2), new UV(x0, y0, z0, 3)}, {new UV(x1, y0, z0, 0), new UV(x1, y1, z0, 1), new UV(x1, y1, z1, 2), new UV(x1, y0, z1, 3)}};
        this.rebuildBounds();
    }

    @Override
    public Box setBounds(float x0, float y0, float z0, float x1, float y1, float z1) {
        if (this.faceVecs == null) {
            return super.setBounds(x0, y0, z0, x1, y1, z1);
        }
        this.rebuildBounds();
        return this;
    }

    protected void rebuildBounds() {
        this.minX = Float.MAX_VALUE;
        this.minY = Float.MAX_VALUE;
        this.minZ = Float.MAX_VALUE;
        this.maxX = Float.MIN_VALUE;
        this.maxY = Float.MIN_VALUE;
        this.maxZ = Float.MIN_VALUE;
        UV[][] arr$ = this.faceVecs;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            UV[] faceVec;
            for (UV uv : faceVec = arr$[i$]) {
                this.minX = Math.min(uv.x, this.minX);
                this.maxX = Math.max(uv.x, this.maxX);
                this.minY = Math.min(uv.y, this.minY);
                this.maxY = Math.max(uv.y, this.maxY);
                this.minZ = Math.min(uv.z, this.minZ);
                this.maxZ = Math.max(uv.z, this.maxZ);
            }
        }
    }

    public BoxRotatable rotate(float theta, float rx, float ry, float rz, float ux, float uy, float uz) {
        float c = MathHelper.func_76134_b((float)(theta * ((float)Math.PI / 180)));
        float s = MathHelper.func_76126_a((float)(theta * ((float)Math.PI / 180)));
        return this.rotate(c, s, rz, ux, uy, uz, rx, ry);
    }

    public BoxRotatable rotate(float c, float s, float rx, float ry, float rz, float ux, float uy, float uz) {
        float d = c * c + s * s;
        if ((double)d < 1.0E-6) {
            return this;
        }
        if ((double)Math.abs(d - 1.0f) > 1.0E-6) {
            d = MathHelper.func_76129_c((float)d);
            c /= d;
            s /= d;
        }
        float c2 = 1.0f - c;
        float uxy = ux * uy * c2;
        float uxz = ux * uz * c2;
        float uyz = uy * uz * c2;
        UV[][] arr$ = this.faceVecs;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            UV[] faceVec;
            for (UV uv : faceVec = arr$[i$]) {
                float px = uv.x - rx;
                float py = uv.y - ry;
                float pz = uv.z - rz;
                uv.x = rx + px * (c + ux * ux * c2) + py * (uxy - uz * s) + pz * (uxz + uy * s);
                uv.y = ry + px * (uxy + uz * s) + py * (c + uy * uy * c2) + pz * (uyz - ux * s);
                uv.z = rz + px * (uxz - uy * s) + py * (uyz + ux * s) + pz * (c + uz * uz * c2);
            }
        }
        this.rebuildBounds();
        this.clearCache();
        return this;
    }

    @Override
    public List<BakedQuad> makeQuads(@Nullable EnumFacing side) {
        if (side != null) {
            return null;
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(6);
        for (int i = 0; i < this.faceVecs.length; ++i) {
            UV[] faceVec = this.faceVecs[i];
            if (this.invisible[i]) continue;
            quads.add(QuadHelper.createBakedQuad(faceVec, this.texture, true, this.tint));
        }
        return quads;
    }

    @Override
    public Box setTextureBounds(float[][] bounds) {
        for (int i = 0; i < this.faceVecs.length; ++i) {
            float[] bound = bounds[i];
            if (bound == null) continue;
            for (int j = 0; j < 4; ++j) {
                UV uv = this.faceVecs[i][j];
                uv.setUVTextureBounds(bound[0] / 16.0f, bound[2] / 16.0f, bound[1] / 16.0f, bound[3] / 16.0f, j);
            }
        }
        return this;
    }

    @Override
    public Box copy() {
        UV[][] newVecs = new UV[this.faceVecs.length][4];
        for (int i = 0; i < this.faceVecs.length; ++i) {
            for (int j = 0; j < 4; ++j) {
                newVecs[i][j] = this.faceVecs[i][j].copy();
            }
        }
        return new BoxRotatable(newVecs);
    }
}

