/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend.model;

import com.google.common.collect.Lists;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.model.CachedRenderers;
import com.rwtema.extrautils2.backend.model.IClientClearCache;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.utils.helpers.ColorHelper;
import com.rwtema.extrautils2.utils.helpers.QuadHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.MathHelper;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.IColoredBakedQuad;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Box
implements IClientClearCache {
    public static final String MISSING_TEXTURE = "[Missing]";
    public static final Box fullBox = new Box(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    public static int[] rotAdd = new int[]{0, 1, 2, 3};
    static int BOTTOM = 0;
    static int TOP = 1;
    static int NORTH = 2;
    static int SOUTH = 3;
    static int WEST = 4;
    static int EAST = 5;
    static int[][][] sidesVertex = new int[][][]{new int[][]{{1, 2, 4}, {1, 2, 5}, {0, 2, 5}, {0, 2, 4}}, new int[][]{{0, 3, 4}, {0, 3, 5}, {1, 3, 5}, {1, 3, 4}}, new int[][]{{0, 2, 4}, {0, 3, 4}, {1, 3, 4}, {1, 2, 4}}, new int[][]{{1, 2, 5}, {1, 3, 5}, {0, 3, 5}, {0, 2, 5}}, new int[][]{{0, 2, 4}, {0, 2, 5}, {0, 3, 5}, {0, 3, 4}}, new int[][]{{1, 3, 4}, {1, 3, 5}, {1, 2, 5}, {1, 2, 4}}};
    static int[][][] uv = new int[][][]{new int[][]{{1, 5}, {1, 4}, {0, 4}, {0, 5}}, new int[][]{{0, 5}, {0, 4}, {1, 4}, {1, 5}}, new int[][]{{1, 2}, {1, 3}, {0, 3}, {0, 2}}, new int[][]{{1, 2}, {1, 3}, {0, 3}, {0, 2}}, new int[][]{{4, 2}, {5, 2}, {5, 3}, {4, 3}}, new int[][]{{5, 3}, {4, 3}, {4, 2}, {5, 2}}};
    static int[] colShade = new int[]{-8355712, -1, -3355444, -3355444, -6710887, -6710887};
    static float[] colShadeMult = new float[]{0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f};
    public final int[] rotate = new int[6];
    public final String[] textureSide = new String[6];
    public final boolean[] invisible = new boolean[6];
    public float[][] textureBounds = null;
    public float minX;
    public float minY;
    public float minZ;
    public float maxX;
    public float maxY;
    public float maxZ;
    public String texture;
    public int color = -1;
    public boolean noCollide;
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad>[] cachedQuads;
    public EnumWorldBlockLayer layer = EnumWorldBlockLayer.SOLID;
    public boolean[] flipU = null;
    public boolean[] flipV = null;
    public int tint = -1;
    public float[] renderOffset = null;
    @SideOnly(value=Side.CLIENT)
    TextureAtlasSprite sprite;

    public Box(float x0, float y0, float z0, float x1, float y1, float z1) {
        this.setBounds(x0, y0, z0, x1, y1, z1);
    }

    public Box(int x0, int y0, int z0, int x1, int y1, int z1, boolean dummy) {
        this.setBounds((float)x0 / 16.0f, (float)y0 / 16.0f, (float)z0 / 16.0f, (float)x1 / 16.0f, (float)y1 / 16.0f, (float)z1 / 16.0f);
    }

    public Box(Box box) {
        this(box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ);
    }

    @SideOnly(value=Side.CLIENT)
    private static List<BakedQuad> makeFlatSideBakedQuad(Box box, @Nonnull EnumFacing side, TextureAtlasSprite textureAtlasSprite, int tint, int color) {
        int i;
        int index = side.func_176745_a();
        int[] vertex = new int[28];
        int rot = box.rotate[side.ordinal()] & 3;
        for (i = 0; i < 4; ++i) {
            vertex[i * 7 + 0] = Float.floatToRawIntBits(box.getPos(sidesVertex[index][i][0]));
            vertex[i * 7 + 1] = Float.floatToRawIntBits(box.getPos(sidesVertex[index][i][1]));
            vertex[i * 7 + 2] = Float.floatToRawIntBits(box.getPos(sidesVertex[index][i][2]));
        }
        if (color == -1) {
            for (i = 0; i < 4; ++i) {
                vertex[i * 7 + 3] = colShade[index];
            }
        } else {
            for (i = 0; i < 4; ++i) {
                vertex[i * 7 + 3] = ColorHelper.multShade(color, colShadeMult[index]);
            }
        }
        Box.loadTextureUV(box, textureAtlasSprite, index, vertex, rot, box.textureBounds, box.flipU, box.flipV);
        ForgeHooksClient.fillNormal((int[])vertex, (EnumFacing)side);
        BakedQuad quad = color == -1 ? new BakedQuad(vertex, tint, side) : new IColoredBakedQuad.ColoredBakedQuad(vertex, tint, side);
        return Lists.newArrayList((Object[])new BakedQuad[]{quad});
    }

    @SideOnly(value=Side.CLIENT)
    public static void loadTextureUV(Box box, TextureAtlasSprite sprite, int index, int[] vertex, int rot, @Nullable float[][] textureBounds, @Nullable boolean[] flipU, @Nullable boolean[] flipV) {
        for (int i = 0; i < 4; ++i) {
            float v;
            float u;
            float dv;
            float du;
            float[] textureBound = null;
            if (textureBounds != null && (textureBound = textureBounds[index]) != null) {
                du = 16.0f * fullBox.getPos(uv[index][i][0]);
                dv = 16.0f * fullBox.getPos(uv[index][i][1]);
            } else {
                du = 16.0f * box.getPos(uv[index][i][0]);
                dv = 16.0f - 16.0f * box.getPos(uv[index][i][1]);
            }
            if (flipU != null && flipU[index]) {
                du = 16.0f - du;
            }
            if (flipV != null && flipV[index]) {
                dv = 16.0f - dv;
            }
            if (textureBound != null) {
                du = textureBound[0] + (textureBound[2] - textureBound[0]) * du / 16.0f;
                dv = textureBound[1] + (textureBound[3] - textureBound[1]) * dv / 16.0f;
            }
            if (rot == 0) {
                u = du;
                v = dv;
            } else if (rot == 1) {
                u = 16.0f - dv;
                v = du;
            } else if (rot == 2) {
                u = 16.0f - du;
                v = 16.0f - dv;
            } else {
                u = dv;
                v = 16.0f - du;
            }
            u = Box.clamp(u);
            v = Box.clamp(v);
            vertex[i * 7 + 4] = Float.floatToRawIntBits(MathHelper.func_76131_a((float)sprite.func_94214_a((double)u), (float)sprite.func_94209_e(), (float)sprite.func_94212_f()));
            vertex[i * 7 + 5] = Float.floatToRawIntBits(MathHelper.func_76131_a((float)sprite.func_94207_b((double)v), (float)sprite.func_94206_g(), (float)sprite.func_94210_h()));
        }
    }

    public static float clamp(float f) {
        return f;
    }

    public static List<BakedQuad> offsetQuadList(List<BakedQuad> quads, float[] offsets) {
        if (offsets == null || quads == null) {
            return quads;
        }
        for (BakedQuad quad : quads) {
            Box.offsetQuad(quad, offsets);
        }
        return quads;
    }

    public static void offsetQuad(BakedQuad quad, float[] offsets) {
        int[] vertex = quad.func_178209_a();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 3; ++j) {
                vertex[i * 7 + j] = Float.floatToRawIntBits(Float.intBitsToFloat(vertex[i * 7 + j]) + offsets[j]);
            }
        }
    }

    public Box setTint(int tint) {
        this.tint = tint;
        return this;
    }

    public Box setLayer(EnumWorldBlockLayer layer) {
        this.layer = layer;
        return this;
    }

    public Box setBounds(float x0, float y0, float z0, float x1, float y1, float z1) {
        this.minX = Math.min(x0, x1);
        this.minY = Math.min(y0, y1);
        this.minZ = Math.min(z0, z1);
        this.maxX = Math.max(x0, x1);
        this.maxY = Math.max(y0, y1);
        this.maxZ = Math.max(z0, z1);
        return this;
    }

    public Box increaseBounds(Box other) {
        if (other.minX < this.minX) {
            this.minX = other.minX;
        }
        if (other.minY < this.minY) {
            this.minY = other.minY;
        }
        if (other.minZ < this.minZ) {
            this.minZ = other.minZ;
        }
        if (other.maxX > this.maxX) {
            this.maxX = other.maxX;
        }
        if (other.maxY > this.maxY) {
            this.maxY = other.maxY;
        }
        if (other.maxZ > this.maxZ) {
            this.maxZ = other.maxZ;
        }
        return this;
    }

    public Box copy() {
        Box box = new Box(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        this.copyBaseProperties(box);
        return box;
    }

    protected void copyBaseProperties(Box box) {
        box.color = this.color;
        System.arraycopy(this.rotate, 0, box.rotate, 0, 6);
        System.arraycopy(this.invisible, 0, box.invisible, 0, 6);
        System.arraycopy(this.textureSide, 0, box.textureSide, 0, 6);
        box.texture = this.texture;
        box.noCollide = this.noCollide;
        box.layer = this.layer;
        if (this.flipU != null) {
            box.flipU = (boolean[])this.flipU.clone();
        }
        if (this.flipV != null) {
            box.flipV = (boolean[])this.flipV.clone();
        }
        box.tint = this.tint;
        if (this.renderOffset != null) {
            box.renderOffset = (float[])this.renderOffset.clone();
        }
    }

    public Box rotateY(int numRotations) {
        if (numRotations == 0) {
            return this;
        }
        if (numRotations < 0) {
            numRotations += 4;
        }
        numRotations &= 3;
        for (int i = 0; i < numRotations; ++i) {
            Box prev = this.copy();
            this.minZ = prev.minX;
            this.maxZ = prev.maxX;
            this.minX = 1.0f - prev.maxZ;
            this.maxX = 1.0f - prev.minZ;
            String temp = this.textureSide[2];
            this.textureSide[2] = this.textureSide[4];
            this.textureSide[4] = this.textureSide[3];
            this.textureSide[3] = this.textureSide[5];
            this.textureSide[5] = temp;
            boolean t = this.invisible[2];
            this.invisible[2] = this.invisible[4];
            this.invisible[4] = this.invisible[3];
            this.invisible[3] = this.invisible[5];
            this.invisible[5] = t;
            if (this.flipU != null) {
                t = this.flipU[2];
                this.flipU[2] = this.flipU[4];
                this.flipU[4] = this.flipU[3];
                this.flipU[3] = this.flipU[5];
                this.flipU[5] = t;
            }
            if (this.flipV == null) continue;
            t = this.flipV[2];
            this.flipV[2] = this.flipV[4];
            this.flipV[4] = this.flipV[3];
            this.flipV[3] = this.flipV[5];
            this.flipV[5] = t;
        }
        this.rotate[Box.TOP] = this.rotate[TOP] + rotAdd[numRotations] & 3;
        this.rotate[Box.BOTTOM] = this.rotate[BOTTOM] + rotAdd[numRotations] & 3;
        this.clearCache();
        return this;
    }

    public Box swapIcons(int a, int b) {
        boolean t;
        boolean t2 = this.invisible[a];
        this.invisible[a] = this.invisible[b];
        this.invisible[b] = t2;
        String temp = this.textureSide[a];
        this.textureSide[a] = this.textureSide[b];
        this.textureSide[b] = temp;
        if (this.flipU != null) {
            t = this.flipU[b];
            this.flipU[b] = this.flipU[a];
            this.flipU[a] = t;
        }
        if (this.flipV != null) {
            t = this.flipV[b];
            this.flipV[b] = this.flipV[a];
            this.flipV[a] = t;
        }
        return this;
    }

    public Box rotateToSideTex(EnumFacing dir) {
        switch (dir) {
            case DOWN: {
                break;
            }
            case UP: {
                this.swapIcons(0, 1);
                this.rotate[Box.EAST] = 3;
                this.rotate[Box.WEST] = 3;
                this.rotate[Box.SOUTH] = 3;
                this.rotate[Box.NORTH] = 3;
                break;
            }
            case NORTH: {
                this.swapIcons(1, 3);
                this.swapIcons(0, 2);
                this.rotate[Box.SOUTH] = 2;
                this.rotate[Box.NORTH] = 1;
                this.rotate[Box.TOP] = 3;
                this.rotate[Box.BOTTOM] = 3;
                break;
            }
            case SOUTH: {
                this.swapIcons(1, 2);
                this.swapIcons(0, 3);
                this.rotate[Box.SOUTH] = 1;
                this.rotate[Box.NORTH] = 2;
                break;
            }
            case WEST: {
                this.swapIcons(1, 5);
                this.swapIcons(0, 4);
                this.rotate[Box.EAST] = 2;
                this.rotate[Box.WEST] = 1;
                this.rotate[Box.TOP] = 1;
                this.rotate[Box.BOTTOM] = 2;
                break;
            }
            case EAST: {
                this.swapIcons(1, 4);
                this.swapIcons(0, 5);
                this.rotate[Box.EAST] = 1;
                this.rotate[Box.WEST] = 2;
                this.rotate[Box.TOP] = 2;
                this.rotate[Box.BOTTOM] = 1;
                break;
            }
        }
        return this;
    }

    public Box rotateToSide(EnumFacing dir) {
        Box prev = this.copy();
        this.clearCache();
        this.rotateToSideTex(dir);
        switch (dir) {
            case DOWN: {
                break;
            }
            case UP: {
                this.minY = 1.0f - prev.maxY;
                this.maxY = 1.0f - prev.minY;
                break;
            }
            case NORTH: {
                this.minZ = prev.minY;
                this.maxZ = prev.maxY;
                this.minY = prev.minX;
                this.maxY = prev.maxX;
                this.minX = prev.minZ;
                this.maxX = prev.maxZ;
                break;
            }
            case SOUTH: {
                this.minZ = 1.0f - prev.maxY;
                this.maxZ = 1.0f - prev.minY;
                this.minY = prev.minX;
                this.maxY = prev.maxX;
                this.minX = 1.0f - prev.maxZ;
                this.maxX = 1.0f - prev.minZ;
                break;
            }
            case WEST: {
                this.minX = prev.minY;
                this.maxX = prev.maxY;
                this.minY = prev.minX;
                this.maxY = prev.maxX;
                this.minZ = 1.0f - prev.maxZ;
                this.maxZ = 1.0f - prev.minZ;
                break;
            }
            case EAST: {
                this.minX = 1.0f - prev.maxY;
                this.maxX = 1.0f - prev.minY;
                this.minY = prev.minX;
                this.maxY = prev.maxX;
                break;
            }
        }
        return this;
    }

    public Box setTexture(String tex) {
        this.texture = tex;
        return this;
    }

    public Box setTextureSides(Object ... tex) {
        int s = -1;
        for (Object aTex : tex) {
            if (aTex instanceof Integer) {
                s = (Integer)aTex;
            }
            if (aTex instanceof EnumFacing) {
                s = ((EnumFacing)aTex).func_176745_a();
                continue;
            }
            if (!(aTex instanceof String)) continue;
            if (s == -1) {
                this.texture = (String)aTex;
                continue;
            }
            if (s < 0 || s >= 6) continue;
            this.textureSide[s] = (String)aTex;
            ++s;
        }
        return this;
    }

    public boolean isFlush(EnumFacing side) {
        switch (side) {
            case DOWN: {
                return this.minY <= 0.0f;
            }
            case UP: {
                return this.maxY >= 1.0f;
            }
            case NORTH: {
                return this.minZ <= 0.0f;
            }
            case SOUTH: {
                return this.maxZ >= 1.0f;
            }
            case WEST: {
                return this.minX <= 0.0f;
            }
            case EAST: {
                return this.maxX >= 1.0f;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTex() {
        if (this.sprite != null) {
            return this.sprite;
        }
        if (this.texture != null && (this.sprite = Textures.sprites.get(this.texture)) != null) {
            CachedRenderers.register(this);
            return this.sprite;
        }
        for (int i = 0; i < 6; ++i) {
            this.sprite = this.getTextureSide(i);
            if (this.sprite == null) continue;
            CachedRenderers.register(this);
            return this.sprite;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> getQuads(@Nullable EnumFacing side) {
        if (side != null && this.invisible[side.ordinal()]) {
            return null;
        }
        List<BakedQuad>[] cache = this.cachedQuads;
        if (cache == null) {
            cache = new List[7];
            for (EnumFacing face : EnumFacing.values()) {
                cache[face.func_176745_a()] = Box.offsetQuadList(this.makeQuads(face), this.renderOffset);
            }
            cache[6] = Box.offsetQuadList(this.makeQuads(null), this.renderOffset);
            this.cachedQuads = cache;
        }
        int i = side == null ? 6 : side.func_176745_a();
        return cache[i];
    }

    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> makeQuads(@Nullable EnumFacing side) {
        if (side == null) {
            return null;
        }
        int index = side.func_176745_a();
        switch (index) {
            case 0: 
            case 1: {
                if (this.minX == this.maxX) {
                    return null;
                }
                if (this.minZ != this.maxZ) break;
                return null;
            }
            case 2: 
            case 3: {
                if (this.minX == this.maxX) {
                    return null;
                }
                if (this.minY != this.maxY) break;
                return null;
            }
            case 4: 
            case 5: {
                if (this.minY == this.maxY) {
                    return null;
                }
                if (this.minZ != this.maxZ) break;
                return null;
            }
        }
        TextureAtlasSprite textureAtlasSprite = this.getTextureSide(index);
        if (textureAtlasSprite == null) {
            textureAtlasSprite = Textures.MISSING_SPRITE;
        }
        return Box.makeFlatSideBakedQuad(this, side, textureAtlasSprite, this.tint, this.color);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureSide(int index) {
        String tex = this.textureSide[index];
        if (tex == null) {
            tex = this.texture;
        }
        if (tex == null) {
            return null;
        }
        TextureAtlasSprite textureAtlasSprite = Textures.sprites.get(tex);
        if (textureAtlasSprite == null) {
            return null;
        }
        return textureAtlasSprite;
    }

    @SideOnly(value=Side.CLIENT)
    private float getPos(int i) {
        switch (i) {
            case 0: {
                return this.minX;
            }
            case 1: {
                return this.maxX;
            }
            case 2: {
                return this.minY;
            }
            case 3: {
                return this.maxY;
            }
            case 4: {
                return this.minZ;
            }
            case 5: {
                return this.maxZ;
            }
        }
        throw new RuntimeException(i + " is not valid side");
    }

    public void clearCache() {
        ExtraUtils2.proxy.clearClientCache(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientClear() {
        this.sprite = null;
        this.cachedQuads = null;
    }

    public Box setInvisible(boolean ... sides) {
        System.arraycopy(sides, 0, this.invisible, 0, sides.length);
        return this;
    }

    public Box setInvisible(int mask) {
        for (int i = 0; i < this.invisible.length; ++i) {
            this.invisible[i] = (mask & 1 << i) != 0;
        }
        return this;
    }

    public List<BakedQuad> addReverseQuads(List<BakedQuad> bakedQuads) {
        if (bakedQuads == null || bakedQuads.isEmpty()) {
            return bakedQuads;
        }
        ArrayList<BakedQuad> rev = new ArrayList<BakedQuad>(bakedQuads.size() * 2);
        rev.addAll(bakedQuads);
        for (BakedQuad bakedQuad : bakedQuads) {
            rev.add(QuadHelper.reverse(bakedQuad));
        }
        return rev;
    }

    public Box setTextureBounds(float[][] floats) {
        this.textureBounds = floats;
        return this;
    }

    public Box setFlipU(int ... sides) {
        this.flipU = new boolean[6];
        for (int side : sides) {
            this.flipU[side] = true;
        }
        return this;
    }

    public Box setFlipV(int ... sides) {
        this.flipV = new boolean[6];
        for (int side : sides) {
            this.flipV[side] = true;
        }
        return this;
    }

    public void setRenderOffset(float dx, float dy, float dz) {
        this.renderOffset = new float[]{dx, dy, dz};
    }

    public void setInvisible(EnumFacing ... facing) {
        for (EnumFacing enumFacing : facing) {
            this.invisible[enumFacing.ordinal()] = true;
        }
    }
}

